/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.seamcat.calculator.CalculatorInputField;
import org.seamcat.presentation.genericgui.IdentityMapper;
import org.seamcat.presentation.genericgui.ValueMapper;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.ValueWithUsageFlag;
import org.seamcat.presentation.genericgui.util.Assert;

public class OptionalIntItem
extends AbstractItem<ValueWithUsageFlag<Integer>, Object> {
    private CalculatorInputField valueWidget;
    private JCheckBox conditionCheckBox;
    private ValueMapper<Integer, Integer> valueMapper = new IdentityMapper<Integer>();

    @Override
    public OptionalIntItem label(String label) {
        super.label(label);
        return this;
    }

    @Override
    public OptionalIntItem unit(String unit) {
        super.unit(unit);
        return this;
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        ArrayList<WidgetAndKind> widgets = new ArrayList<WidgetAndKind>();
        this.conditionCheckBox = new JCheckBox(this.getLabel());
        if (this.getToolTipText() != null) {
            this.conditionCheckBox.setToolTipText(this.getToolTipText());
        }
        this.conditionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionalIntItem.this.updateWidgetRelevance(OptionalIntItem.this.conditionCheckBox.isSelected());
                OptionalIntItem.this.fireItemChanged();
            }
        });
        widgets.add(new WidgetAndKind(this.conditionCheckBox, WidgetKind.LABEL));
        this.valueWidget = new CalculatorInputField();
        this.valueWidget.setIntegerMode(true);
        this.valueWidget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionalIntItem.this.fireItemChanged();
            }
        });
        widgets.add(new WidgetAndKind(this.valueWidget, WidgetKind.VALUE));
        widgets.add(new WidgetAndKind(new JLabel(this.getUnit()), WidgetKind.UNIT));
        return widgets;
    }

    @Override
    public ValueWithUsageFlag<Integer> getValue() {
        return new ValueWithUsageFlag<Integer>(this.conditionCheckBox.isSelected(), this.valueMapper.mapToModelValue((int)this.valueWidget.getValueAsDouble()));
    }

    @Override
    public void setValue(ValueWithUsageFlag<Integer> value) {
        Assert.notNull("Value is null", value);
        this.valueWidget.setValue(this.valueMapper.mapToWidgetValue((Integer)value.value));
        this.conditionCheckBox.setSelected(value.useValue);
        this.updateWidgetRelevance(value.useValue);
    }

    protected void updateWidgetRelevance(boolean enabled) {
        this.valueWidget.setEnabled(enabled);
    }
}

