/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.presentation.DialogMaskFunctionDefine;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.ValueWithUsageFlag;
import org.seamcat.presentation.valuepreview.ButtonWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.LabelWithValuePreviewTip;
import org.seamcat.presentation.valuepreview.ValuePreviewTextUtil;
import org.seamcat.presentation.valuepreview.ValuePreviewableFunction2Adapter;

public class OptionalMaskFunctionItem
extends AbstractItem<ValueWithUsageFlag<MaskFunction>, Object> {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private String functionDialogTitle;
    private MaskFunction function;
    private JFrame parent;
    private String xAxisName;
    private String yAxisName;
    private JCheckBox conditionCheckBox;
    private ButtonWithValuePreviewTip functionButton;
    private LabelWithValuePreviewTip valuePreviewLabel;

    public OptionalMaskFunctionItem(JFrame parent, String name, String xAxisName, String yAxisName) {
        this.parent = parent;
        this.xAxisName = xAxisName;
        this.yAxisName = yAxisName;
        this.functionDialogTitle = name + " X(MHz) / Y(dBm)";
    }

    @Override
    public OptionalMaskFunctionItem label(String label) {
        super.label(label);
        return this;
    }

    @Override
    public OptionalMaskFunctionItem unit(String unit) {
        super.unit(unit);
        return this;
    }

    public OptionalMaskFunctionItem axisNames(String xAxisName, String yAxisName) {
        this.xAxisName = xAxisName;
        this.yAxisName = yAxisName;
        return this;
    }

    @Override
    public ValueWithUsageFlag<MaskFunction> getValue() {
        return new ValueWithUsageFlag<MaskFunction>(this.conditionCheckBox.isSelected(), this.function);
    }

    @Override
    public void setValue(ValueWithUsageFlag<MaskFunction> value) {
        this.conditionCheckBox.setSelected(value.useValue);
        this.function = (MaskFunction)value.value;
        this.updateValuePreview(this.function);
        this.updateWidgetRelevance();
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        ArrayList<WidgetAndKind> widgets = new ArrayList<WidgetAndKind>();
        this.conditionCheckBox = new JCheckBox(this.getLabel());
        this.conditionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionalMaskFunctionItem.this.updateWidgetRelevance();
                OptionalMaskFunctionItem.this.fireItemChanged();
            }
        });
        widgets.add(new WidgetAndKind(this.conditionCheckBox, WidgetKind.LABEL));
        this.functionButton = new ButtonWithValuePreviewTip(STRINGLIST.getString("BTN_CAPTION_FUNCTION"));
        this.functionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionalMaskFunctionItem.this.showFunctionDialog();
            }
        });
        widgets.add(new WidgetAndKind(this.functionButton, WidgetKind.VALUE));
        this.valuePreviewLabel = new LabelWithValuePreviewTip();
        widgets.add(new WidgetAndKind(this.valuePreviewLabel, WidgetKind.VALUE_PREVIEW));
        widgets.add(new WidgetAndKind(new JLabel(this.getUnit()), WidgetKind.UNIT));
        return widgets;
    }

    @Override
    public void setRelevant(boolean relevant) {
        super.setRelevant(relevant);
        this.updateWidgetRelevance();
    }

    private void showFunctionDialog() {
        DialogMaskFunctionDefine dialog = new DialogMaskFunctionDefine((Frame)this.parent, true);
        if (dialog.show(this.function, this.functionDialogTitle, this.xAxisName, this.yAxisName)) {
            this.function = dialog.getFunction();
            this.updateValuePreview(this.function);
            this.fireItemChanged();
        }
    }

    private void updateValuePreview(MaskFunction function) {
        this.valuePreviewLabel.setText(ValuePreviewTextUtil.previewLabelText(function.toString()));
        ValuePreviewableFunction2Adapter previewable = new ValuePreviewableFunction2Adapter(function).axisNames(this.xAxisName, this.yAxisName);
        this.valuePreviewLabel.setPreviewable(previewable);
        this.functionButton.setPreviewable(previewable);
    }

    private void updateWidgetRelevance() {
        this.functionButton.setEnabled(this.isRelevant() && this.conditionCheckBox.isSelected());
        this.valuePreviewLabel.setEnabled(this.isRelevant() && this.conditionCheckBox.isSelected());
    }
}

