/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.seamcat.model.types.Configuration;
import org.seamcat.presentation.PluginDialog;
import org.seamcat.presentation.eventprocessing.PluginConfigurationPanel;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.valuepreview.ButtonWithValuePreviewTip;

public class PluginItem
extends AbstractItem<Configuration, Object> {
    private Configuration configuration;
    private PluginConfigurationPanel editor;
    private JFrame parent;
    private String name;
    private JLabel preview;
    private JButton pluginEditButton;
    private ActionListener actionListener;

    public PluginItem(JFrame parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public Configuration getValue() {
        return this.configuration;
    }

    @Override
    public void setValue(Configuration value) {
        this.configuration = value;
        this.updateValuePreview();
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        List<WidgetAndKind> widgets = super.createWidgets();
        this.pluginEditButton = new ButtonWithValuePreviewTip("Edit");
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginItem.this.showDialog();
            }
        };
        this.pluginEditButton.addActionListener(this.actionListener);
        widgets.add(new WidgetAndKind(this.pluginEditButton, WidgetKind.VALUE));
        this.preview = new JLabel();
        widgets.add(new WidgetAndKind(this.preview, WidgetKind.VALUE_PREVIEW));
        return widgets;
    }

    private void showDialog() {
        this.editor = new PluginConfigurationPanel(this.parent, this.configuration, false, this.configuration.getClass());
        PluginDialog dialog = new PluginDialog((Frame)this.parent, this.name, this.editor);
        if (dialog.display()) {
            this.configuration = this.editor.getModel();
            this.updateValuePreview();
        }
    }

    private void updateValuePreview() {
        this.preview.setText("[" + this.configuration.description().name() + "]");
    }

    @Override
    public void dispose() {
        super.dispose();
        this.pluginEditButton.removeActionListener(this.actionListener);
    }
}

