/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.item;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.seamcat.presentation.genericgui.WidgetAndKind;
import org.seamcat.presentation.genericgui.WidgetKind;
import org.seamcat.presentation.genericgui.item.AbstractItem;

public class SelectionItem<ValueType>
extends AbstractItem<ValueType, Object> {
    private List<ComboBoxElement<ValueType>> values = new ArrayList<ComboBoxElement<ValueType>>();
    private JComboBox valueWidget;

    @Override
    public SelectionItem<ValueType> label(String label) {
        super.label(label);
        return this;
    }

    public SelectionItem<ValueType> values(Iterable<ValueType> values) {
        for (ValueType value : values) {
            this.values.add(new ComboBoxElement<ValueType>(value));
        }
        return this;
    }

    public SelectionItem<ValueType> value(ValueType value, String selectionString) {
        this.values.add(new ComboBoxElement<ValueType>(value, selectionString));
        return this;
    }

    @Override
    public List<WidgetAndKind> createWidgets() {
        List<WidgetAndKind> widgets = super.createWidgets();
        this.valueWidget = new JComboBox();
        this.valueWidget.setModel(new DefaultComboBoxModel<Object>(this.values.toArray()));
        this.valueWidget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionItem.this.fireItemChanged();
            }
        });
        widgets.add(new WidgetAndKind(this.valueWidget, WidgetKind.VALUE));
        return widgets;
    }

    private ComboBoxElement<ValueType> findElementForValue(ValueType value) {
        for (ComboBoxElement<ValueType> element : this.values) {
            if (!element.value.equals(value)) continue;
            return element;
        }
        return null;
    }

    @Override
    public ValueType getValue() {
        return ((ComboBoxElement)this.valueWidget.getSelectedItem()).value;
    }

    @Override
    public void setValue(ValueType value) {
        if (value == null) {
            this.valueWidget.setSelectedItem(value);
            return;
        }
        ComboBoxElement<ValueType> element = this.findElementForValue(value);
        if (element == null) {
            throw new RuntimeException("Value " + value + " is not valid for object selection");
        }
        this.valueWidget.setSelectedItem(element);
    }

    public void addActionListener(ActionListener listener) {
        this.valueWidget.addActionListener(listener);
    }

    private static class ComboBoxElement<ValueType> {
        ValueType value;
        String selectionString;

        ComboBoxElement(ValueType value, String selectionString) {
            this.value = value;
            this.selectionString = selectionString;
        }

        ComboBoxElement(ValueType value) {
            this(value, value.toString());
        }

        public String toString() {
            return this.selectionString;
        }
    }
}

