/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.panelbuilder;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import org.seamcat.function.FunctionType;
import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.plugin.CalculatedValue;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.Horizontal;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.Spherical;
import org.seamcat.model.plugin.Vertical;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.BooleanItem;
import org.seamcat.presentation.genericgui.item.CalculatedValueItem;
import org.seamcat.presentation.genericgui.item.DistributionItem;
import org.seamcat.presentation.genericgui.item.DoubleItem;
import org.seamcat.presentation.genericgui.item.EmbeddedPluginItem;
import org.seamcat.presentation.genericgui.item.FunctionItem;
import org.seamcat.presentation.genericgui.item.FunctionLibraryItem;
import org.seamcat.presentation.genericgui.item.IntegerItem;
import org.seamcat.presentation.genericgui.item.LLDItem;
import org.seamcat.presentation.genericgui.item.ListItem;
import org.seamcat.presentation.genericgui.item.MaskFunctionItem;
import org.seamcat.presentation.genericgui.item.MaskFunctionLibraryItem;
import org.seamcat.presentation.genericgui.item.OptionalDistributionItem;
import org.seamcat.presentation.genericgui.item.OptionalDoubleItem;
import org.seamcat.presentation.genericgui.item.OptionalFunctionItem;
import org.seamcat.presentation.genericgui.item.OptionalFunctionLibraryItem;
import org.seamcat.presentation.genericgui.item.OptionalIntItem;
import org.seamcat.presentation.genericgui.item.OptionalMaskFunctionItem;
import org.seamcat.presentation.genericgui.item.PluginItem;
import org.seamcat.presentation.genericgui.item.SelectionItem;
import org.seamcat.presentation.genericgui.item.TextItem;
import org.seamcat.presentation.genericgui.item.ValueWithUsageFlag;
import org.seamcat.presentation.genericgui.panelbuilder.CompositeEditor;

public class ConfigItem {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private AbstractItem item;
    private boolean isCalculated;
    private CalculatedValueItem calculated;

    public boolean isCalculated() {
        return this.isCalculated;
    }

    public CalculatedValueItem getCalculated() {
        return this.calculated;
    }

    public ConfigItem(JFrame owner, Method method, Object owningObject, Object defaultValue) {
        Type tType;
        Type genericReturnType;
        String unit;
        Config con = method.getAnnotation(Config.class);
        Class<?> type = method.getReturnType();
        String name = method.getName();
        String information = null;
        String toolTip = null;
        int linesToDisplay = con.textlines();
        name = con.name().isEmpty() ? name : con.name();
        String[] distributions = con.distributions();
        if (resourceBundle.containsKey(name)) {
            name = resourceBundle.getString(name);
        }
        String string = unit = con.unit().isEmpty() ? null : con.unit();
        if (!con.information().isEmpty()) {
            information = ConfigItem.infoText(con.information());
        }
        if (!con.toolTip().isEmpty()) {
            toolTip = con.toolTip();
        }
        if (type.isPrimitive()) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                this.item = new BooleanItem();
            } else if (Double.TYPE.isAssignableFrom(type)) {
                this.item = new DoubleItem();
            } else if (Integer.TYPE.isAssignableFrom(type)) {
                this.item = new IntegerItem();
            }
        } else if (Boolean.class.isAssignableFrom(type)) {
            this.item = new BooleanItem();
        } else if (AbstractDistribution.class.isAssignableFrom(type)) {
            this.item = new DistributionItem(owner, distributions);
        } else if (String.class.isAssignableFrom(type)) {
            this.item = new TextItem().linesToDisplay(linesToDisplay);
        } else if (Enum.class.isAssignableFrom(type)) {
            List<?> selectionItems = Arrays.asList(type.getEnumConstants());
            this.item = new SelectionItem().values(selectionItems);
        } else if (EmissionMask.class.isAssignableFrom(type)) {
            this.item = new MaskFunctionLibraryItem<EmissionMask>(owner, EmissionMask.class);
        } else if (BlockingMask.class.isAssignableFrom(type)) {
            this.item = new FunctionLibraryItem(BlockingMask.class, owner);
        } else if (BitRateMapping.class.isAssignableFrom(type)) {
            this.item = new FunctionLibraryItem(BitRateMapping.class, owner);
        } else if (IntermodulationRejectionMask.class.isAssignableFrom(type)) {
            this.item = new FunctionLibraryItem(IntermodulationRejectionMask.class, owner);
        } else if (MaskFunction.class.isAssignableFrom(type)) {
            this.item = new MaskFunctionItem(owner);
        } else if (Function.class.isAssignableFrom(type)) {
            String[] labels = this.getAxisLabels(method, con);
            FunctionItem functionItem = new FunctionItem(owner, labels[0], labels[1]);
            this.item = functionItem.label(name).functionType(this.getFunctionType(method));
        } else if (Distribution.class.isAssignableFrom(type)) {
            this.item = new DistributionItem(owner, distributions);
        } else if (Double.class.isAssignableFrom(type)) {
            this.item = new DoubleItem();
        } else if (Integer.class.isAssignableFrom(type)) {
            this.item = new IntegerItem();
        } else if (PropagationModel.class.isAssignableFrom(type)) {
            this.item = con.embed() ? new EmbeddedPluginItem(owner, (Configuration)defaultValue, PropagationModelConfiguration.class) : new PluginItem(owner, name);
        } else if (AntennaGain.class.isAssignableFrom(type)) {
            this.item = con.embed() ? new EmbeddedPluginItem(owner, (Configuration)defaultValue, AntennaGainConfiguration.class) : new PluginItem(owner, name);
        } else if (CDMALLD.class.isAssignableFrom(type)) {
            CDMALLD lld;
            boolean downLink = true;
            if (defaultValue != null && !(lld = (CDMALLD)defaultValue).systemType().equals("downlink")) {
                downLink = false;
            }
            this.item = new LLDItem(owner, downLink);
        } else if (CalculatedValue.class.isAssignableFrom(type)) {
            this.calculated = new CalculatedValueItem();
            this.isCalculated = true;
            this.item = this.calculated;
        } else if (List.class.isAssignableFrom(type)) {
            this.item = new ListItem().label("test");
        } else if (OptionalValue.class.isAssignableFrom(type) && (genericReturnType = method.getGenericReturnType()) instanceof ParameterizedType && (tType = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0]) instanceof Class) {
            Class clazz = (Class)tType;
            if (clazz.isAssignableFrom(Function.class)) {
                String[] labels = this.getAxisLabels(method, con);
                OptionalFunctionItem functionItem = new OptionalFunctionItem(owner, name, labels[0], labels[1]);
                this.item = functionItem.functionType(this.getFunctionType(method));
            } else if (clazz.isAssignableFrom(MaskFunction.class)) {
                String[] labels = this.getAxisLabels(method, con);
                this.item = new OptionalMaskFunctionItem(owner, name, labels[0], labels[1]);
            } else if (clazz.isAssignableFrom(Integer.class)) {
                this.item = new OptionalIntItem();
            } else if (clazz.isAssignableFrom(Double.class)) {
                this.item = new OptionalDoubleItem();
            } else if (clazz.isAssignableFrom(Distribution.class)) {
                this.item = new OptionalDistributionItem(owner, distributions);
            } else if (clazz.isAssignableFrom(IntermodulationRejectionMask.class)) {
                this.item = new OptionalFunctionLibraryItem(IntermodulationRejectionMask.class, owner);
            } else if (clazz.isAssignableFrom(BitRateMapping.class)) {
                this.item = new OptionalFunctionLibraryItem(BitRateMapping.class, owner);
            }
        }
        if (this.item == null) {
            throw new RuntimeException("Missing widget for type: " + defaultValue);
        }
        this.item.label(name);
        if (unit != null) {
            this.item.unit(unit);
        }
        if (information != null) {
            this.item.information(information);
        }
        if (toolTip != null) {
            this.item.tooltip(toolTip);
        }
        this.item.initialize();
        this.setInitialValue(owningObject, defaultValue, method);
    }

    private void setInitialValue(Object model, Object value, Method method) {
        if (model != null) {
            try {
                value = method.invoke(model, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (value instanceof OptionalValue) {
            OptionalValue optionalValue = (OptionalValue)((Object)value);
            value = new ValueWithUsageFlag(optionalValue.isRelevant(), optionalValue.getValue());
        }
        this.item.setValue(value);
    }

    private String[] getAxisLabels(Method method, Config con) {
        String[] ranges = new String[]{"", ""};
        if (!"".equals(con.xAxis())) {
            ranges[0] = con.xAxis();
        }
        if (!"".equals(con.yAxis())) {
            ranges[1] = con.yAxis();
        }
        Horizontal hor = method.getAnnotation(Horizontal.class);
        Vertical ver = method.getAnnotation(Vertical.class);
        Spherical sph = method.getAnnotation(Spherical.class);
        if (hor != null || ver != null || sph != null) {
            ranges[0] = "Degree";
            ranges[1] = "Antenna gain relative to peak gain (dB)";
        }
        return ranges;
    }

    private FunctionType getFunctionType(Method method) {
        Horizontal hor = method.getAnnotation(Horizontal.class);
        if (hor != null) {
            return FunctionType.horizontal();
        }
        Vertical ver = method.getAnnotation(Vertical.class);
        if (ver != null) {
            return FunctionType.vertical();
        }
        Spherical sph = method.getAnnotation(Spherical.class);
        if (sph != null) {
            return FunctionType.spherical();
        }
        return FunctionType.none();
    }

    public AbstractItem getItem() {
        return this.item;
    }

    public static String infoText(String information) {
        return CompositeEditor.replaceIMG(resourceBundle.getString(information));
    }
}

