/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.genericgui.panelbuilder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JFrame;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.InfoMessageEvent;
import org.seamcat.events.TextWidgetValueUpdatedEvent;
import org.seamcat.model.Library;
import org.seamcat.model.factory.Model;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.components.GenericLibraryImportExportWidget;
import org.seamcat.presentation.components.GenericSelectionDialog;
import org.seamcat.presentation.genericgui.GenericModelEditorPanel;
import org.seamcat.presentation.genericgui.item.TextItem;
import org.seamcat.presentation.genericgui.panelbuilder.CompositeEditor;
import org.seamcat.presentation.library.ChangeNotifier;
import org.seamcat.presentation.library.LibraryItemWrapper;

public class LibraryItemDescriptionPanel<T extends LibraryItem>
extends GenericModelEditorPanel<T> {
    private final TextItem nameItem;
    private final TextItem descriptionItem;

    public LibraryItemDescriptionPanel(final JFrame owner, ChangeNotifier notifier, final Class<T> clazz, final CompositeEditor<T> parent, Description description) {
        GenericLibraryImportExportWidget importExportWidget = new GenericLibraryImportExportWidget();
        importExportWidget.addImportHandler(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List group = Model.getInstance().getLibrary().getGroup(clazz);
                GenericSelectionDialog dialog = new GenericSelectionDialog(owner, Library.typeName(clazz) + " Library", group);
                if (dialog.display()) {
                    parent.setModel((LibraryItem)dialog.getSelectedValue());
                }
            }
        });
        importExportWidget.addExportHandler(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Library library = Model.getInstance().getLibrary();
                LibraryItem model = (LibraryItem)parent.getModel();
                LibraryItem clone = ProxyHelper.deepCloneComposite(clazz, model);
                String name = LibraryItemWrapper.toString(model);
                if (!library.add(clazz, clone)) {
                    if (DialogHelper.overrideInLibrary(owner, name)) {
                        library.removeItem(clazz, model);
                        library.add(clazz, clone);
                        EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("'%s' overridden in library", name)));
                    }
                } else {
                    EventBusFactory.getEventBus().publish(new InfoMessageEvent(String.format("'%s' added to library", name)));
                }
            }
        });
        if (!SystemModel.class.isAssignableFrom(clazz)) {
            this.addItem(importExportWidget);
        }
        this.nameItem = new TextItem().label("Name").valueUpdatedEvent(new TextWidgetValueUpdatedEvent("", clazz));
        this.nameItem.initialize();
        this.nameItem.setValue(description.name());
        this.descriptionItem = new TextItem().label("Description").linesToDisplay(3);
        this.descriptionItem.initialize();
        this.descriptionItem.setValue(description.description());
        this.addItem(this.nameItem);
        this.addItem(this.descriptionItem);
        this.initializeWidgets();
        this.nameItem.addChangeNotifier(notifier);
    }

    public Description getDescription() {
        return new DescriptionImpl(this.nameItem.getValue(), this.descriptionItem.getValue());
    }
}

