/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.seamcat.cdma.CDMALinkLevelData;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.function.EmissionMaskImpl;
import org.seamcat.model.factory.Cache;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.plugin.Horizontal;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.Spherical;
import org.seamcat.model.plugin.Vertical;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.systems.cdma.CDMAGeneralSettings;
import org.seamcat.model.systems.cdma.CDMAGeneralSettingsUpLink;
import org.seamcat.model.systems.cdma.SystemModelCDMADownLink;
import org.seamcat.model.systems.cdma.SystemModelCDMAUpLink;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.presentation.AntennaPatterns;
import org.seamcat.presentation.JarComponentPanel;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.components.DiscreteFunctionGraph;
import org.seamcat.presentation.components.DiscreteFunctionTableModelAdapter;
import org.seamcat.presentation.eventprocessing.PluginConfigurationPanel;
import org.seamcat.presentation.genericgui.panelbuilder.CompositeEditor;
import org.seamcat.presentation.library.ChangeNotifier;
import org.seamcat.presentation.library.LibraryFunctionDetailPanel;
import org.seamcat.presentation.library.LibraryItemWrapper;
import org.seamcat.presentation.library.LinkLevelDataDetailPanel;
import org.seamcat.presentation.library.SpectrumEmissionMaskPanel;
import org.seamcat.presentation.library.SystemModelActiveTab;
import org.seamcat.presentation.simulationview.outline.SystemLayoutExplaination;
import org.seamcat.presentation.simulationview.outline.SystemLayoutPanel;
import org.seamcat.presentation.systems.SystemListItem;

public class LibraryDetailPanel<M extends LibraryItem>
extends JPanel {
    private final int index;
    private final Class<M> clazz;
    private ModelHolder<M> modelHolder;

    public LibraryDetailPanel(JFrame parent, Class<M> clazz, final LibraryItemWrapper<M> model, ChangeNotifier notifier, boolean libraryMode) {
        this.clazz = clazz;
        this.setLayout(new BorderLayout());
        this.index = model.getIndex();
        if (model.getItem() instanceof Configuration) {
            Configuration configuration = (Configuration)model.getItem();
            final PluginConfigurationPanel panel = new PluginConfigurationPanel(parent, configuration, true, configuration.getClass());
            if (configuration instanceof AntennaGainConfiguration) {
                JPanel combined = new JPanel(new GridLayout(1, 2));
                combined.add(new BorderPanel(new JScrollPane(panel), "Plugin Configuration"));
                combined.add(new BorderPanel(this.antennaPreview((AntennaGainConfiguration)configuration), "Preview"));
                this.add((Component)combined, "Center");
            } else {
                this.add((Component)new BorderPanel(new JScrollPane(panel), "Plugin Configuration"), "Center");
            }
            this.modelHolder = new ModelHolder<M>(){

                @Override
                public M getModel() {
                    return panel.getModel();
                }

                @Override
                public Component getComponent() {
                    return panel;
                }
            };
        } else if (model.getItem() instanceof EmissionMask) {
            final SpectrumEmissionMaskPanel panel = new SpectrumEmissionMaskPanel((EmissionMaskImpl)model.getItem(), notifier);
            this.add((Component)new BorderPanel(panel, "Spectrum Emission Mask"), "Center");
            this.modelHolder = new ModelHolder<M>(){

                @Override
                public M getModel() {
                    return panel.getModel();
                }

                @Override
                public Component getComponent() {
                    return panel;
                }
            };
        } else if (model.getItem() instanceof BlockingMask) {
            BlockingMask mask = (BlockingMask)model.getItem();
            final LibraryFunctionDetailPanel panel = new LibraryFunctionDetailPanel(parent, mask.getFunction(), mask.description(), notifier, "MHz", "dB");
            this.add((Component)new BorderPanel(panel, "Receiver Blocking Mask"), "Center");
            this.modelHolder = new ModelHolder<M>(){

                @Override
                public M getModel() {
                    return Factory.functionFactory().fromClass(BlockingMask.class, panel.getFunction(), panel.getDescription());
                }

                @Override
                public Component getComponent() {
                    return panel;
                }
            };
        } else if (model.getItem() instanceof BitRateMapping) {
            BitRateMapping mapping = (BitRateMapping)model.getItem();
            final LibraryFunctionDetailPanel panel = new LibraryFunctionDetailPanel(parent, mapping.getFunction(), mapping.description(), notifier, "SINR (dB)", "BitRate (bps/Hz)");
            this.add((Component)new BorderPanel(panel, "Bitrate mapping (Link Level Performance)"), "Center");
            this.modelHolder = new ModelHolder<M>(){

                @Override
                public M getModel() {
                    return Factory.functionFactory().fromClass(BitRateMapping.class, panel.getFunction(), panel.getDescription());
                }

                @Override
                public Component getComponent() {
                    return panel;
                }
            };
        } else if (model.getItem() instanceof IntermodulationRejectionMask) {
            IntermodulationRejectionMask mask = (IntermodulationRejectionMask)model.getItem();
            final LibraryFunctionDetailPanel panel = new LibraryFunctionDetailPanel(parent, mask.getFunction(), mask.description(), notifier, "MHz", "dB");
            this.add((Component)new BorderPanel(panel, "Intermodulation Rejection Mask"), "Center");
            this.modelHolder = new ModelHolder<M>(){

                @Override
                public M getModel() {
                    return Factory.functionFactory().intermodulationRejectMask(panel.getFunction(), panel.getDescription());
                }

                @Override
                public Component getComponent() {
                    return panel;
                }
            };
        } else if (model.getItem() instanceof JarConfigurationModel) {
            final JarComponentPanel panel = new JarComponentPanel((JarConfigurationModel)model.getItem());
            this.add((Component)new BorderPanel(panel, "Installed Jar Files"), "Center");
            this.modelHolder = new ModelHolder<M>(){

                @Override
                public M getModel() {
                    return model.getItem();
                }

                @Override
                public Component getComponent() {
                    return panel;
                }
            };
        } else if (model.getItem() instanceof CDMALLD) {
            final LinkLevelDataDetailPanel panel = new LinkLevelDataDetailPanel(parent, new CDMALinkLevelData((CDMALLD)model.getItem()));
            this.add((Component)new BorderPanel(panel, "CDMA Link Level Data"), "Center");
            this.modelHolder = new ModelHolder<M>(){

                @Override
                public M getModel() {
                    return model.getItem();
                }

                @Override
                public Component getComponent() {
                    return panel;
                }
            };
        } else if (model.getItem() instanceof SystemListItem) {
            SystemListItem item = (SystemListItem)model.getItem();
            SystemPlugin systemPlugin = item.getSystemPlugin();
            Object ui = systemPlugin.getUI();
            Class<? extends SystemModel> pluginUIClass = GenericTypeMarshaller.getPluginUIClass(systemPlugin);
            final CompositeEditor detailPanel = new CompositeEditor(parent, systemPlugin, libraryMode, notifier);
            if (ui instanceof SystemModelCDMAUpLink) {
                detailPanel.enableItem(CDMAGeneralSettingsUpLink.class, 7, false);
            } else if (ui instanceof SystemModelCDMADownLink) {
                detailPanel.enableItem(CDMAGeneralSettings.class, 7, false);
            }
            SystemLayoutExplaination explaination = new SystemLayoutExplaination();
            final SystemLayoutPanel panel = new SystemLayoutPanel(systemPlugin, explaination);
            final JSplitPane split = new JSplitPane(1);
            split.add(panel);
            split.add(explaination);
            split.setDividerLocation(800);
            split.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    split.setDividerLocation(0.8);
                }
            });
            final JTabbedPane jTabbedPane = detailPanel.getTabPane();
            final int systemLayoutIndex = jTabbedPane.getTabCount();
            jTabbedPane.add("System Layout", split);
            detailPanel.activeTab(SystemModelActiveTab.activeTab(pluginUIClass));
            this.add(detailPanel, "Center");
            this.modelHolder = new ModelHolder<M>((SystemModel)ui, systemPlugin, item){
                final /* synthetic */ SystemModel val$ui;
                final /* synthetic */ SystemPlugin val$systemPlugin;
                final /* synthetic */ SystemListItem val$item;
                {
                    this.val$ui = systemModel;
                    this.val$systemPlugin = systemPlugin;
                    this.val$item = systemListItem;
                }

                @Override
                public M getModel() {
                    SystemModel newModel = (SystemModel)detailPanel.getModel();
                    ProxyHelper.getHandler(newModel).setId(this.val$ui.id());
                    this.val$systemPlugin.setUI(newModel);
                    return this.val$item;
                }

                @Override
                public Component getComponent() {
                    return detailPanel;
                }
            };
            jTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (systemLayoutIndex == jTabbedPane.getSelectedIndex()) {
                        LibraryDetailPanel.this.modelHolder.getModel();
                        panel.tabSelected();
                    }
                }
            });
        } else {
            final CompositeEditor<M> detailPanel = new CompositeEditor<M>(parent, clazz, model.getItem(), true, notifier);
            this.add(detailPanel, "Center");
            this.modelHolder = new ModelHolder<M>(){

                @Override
                public M getModel() {
                    return (LibraryItem)detailPanel.getModel();
                }

                @Override
                public Component getComponent() {
                    return detailPanel;
                }
            };
        }
    }

    public JPanel antennaPreview(AntennaGainConfiguration configuration) {
        JPanel previewPanel = new JPanel(new GridLayout(2, 1));
        Class modelClass = configuration.getModelClass();
        int added = 0;
        try {
            for (Method method : Cache.orderedConfig(modelClass)) {
                JPanel spherical;
                JPanel vertical;
                JPanel horizontal = this.handle(method, AntennaPatterns.HORIZONTAL, Horizontal.class, "Horizontal", configuration.getModel());
                if (horizontal != null) {
                    previewPanel.add(horizontal);
                    ++added;
                }
                if ((vertical = this.handle(method, AntennaPatterns.VERTICAL, Vertical.class, "Vertical", configuration.getModel())) != null) {
                    previewPanel.add(vertical);
                    ++added;
                }
                if ((spherical = this.handle(method, AntennaPatterns.SPHERICAL, Spherical.class, "Spherical", configuration.getModel())) != null) {
                    previewPanel.add(spherical);
                    ++added;
                }
                if (added != 2) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return previewPanel;
    }

    private JPanel handle(Method method, AntennaPatterns pat, Class<? extends Annotation> ann, String name, Object model) throws InvocationTargetException, IllegalAccessException {
        DiscreteFunction function;
        Annotation annotation = method.getAnnotation(ann);
        if (annotation != null && (function = this.getFunction(method.invoke(model, new Object[0]))) != null) {
            DiscreteFunctionTableModelAdapter tableModel = new DiscreteFunctionTableModelAdapter();
            tableModel.setDiscreteFunction(function);
            DiscreteFunctionGraph graph = new DiscreteFunctionGraph(tableModel, pat, "Degree", "dB");
            return new BorderPanel(graph, name);
        }
        return null;
    }

    private DiscreteFunction getFunction(Object instance) {
        if (instance instanceof Function) {
            return (DiscreteFunction)instance;
        }
        if (instance instanceof OptionalValue && ((OptionalValue)instance).isRelevant()) {
            return (DiscreteFunction)((OptionalValue)instance).getValue();
        }
        return null;
    }

    public M getModel() {
        LibraryItem model = (LibraryItem)this.modelHolder.getModel();
        if (model instanceof SystemListItem) {
            Component component = this.modelHolder.getComponent();
            Integer activeTab = ((CompositeEditor)component).getActiveTab();
            SystemModelActiveTab.activeTab(GenericTypeMarshaller.getPluginUIClass(((SystemListItem)model).getSystemPlugin()), activeTab);
        }
        return (M)model;
    }

    public Component getComponent() {
        return this.modelHolder.getComponent();
    }

    public int getIndex() {
        return this.index;
    }

    public boolean match(Object context) {
        Component component = this.modelHolder.getComponent();
        return component instanceof PluginConfigurationPanel && ((PluginConfigurationPanel)component).getIdPanel() == context;
    }

    private static interface ModelHolder<T> {
        public T getModel();

        public Component getComponent();
    }
}

