/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.library;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.seamcat.model.factory.Model;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.plugin.CoverageRadiusConfiguration;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.presentation.WrapLayout;
import org.seamcat.presentation.builder.PanelBuilder;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.library.LibraryExportGroup;
import org.seamcat.presentation.library.LibraryImportExportDialog;

public class LibraryExportDialog
extends LibraryImportExportDialog {
    private final JPanel content = new JPanel(new WrapLayout());

    public LibraryExportDialog(JFrame owner) {
        super(owner, "Export Libraries", 800, 600);
        this.content.setSize(new Dimension(750, 600));
        this.content.add(PanelBuilder.panel().button("Select All", this, "select").button("Deselect All", this, "deselect").get());
        this.addGroup(this.library.getSystems());
        this.addGroup(this.library.getSpectrumEmissionMasks());
        this.addGroup(this.library.getReceiverBlockingMasks());
        this.addGroup(this.library.getReceivers());
        this.addGroup(this.library.getTransmitters());
        this.addGroup(this.library.getCDMALinkLevelData());
        this.addGroup(this.library.getPluginConfigurations(AntennaGainConfiguration.class));
        this.addGroup(this.library.getPluginConfigurations(PropagationModelConfiguration.class));
        this.addGroup(this.library.getPluginConfigurations(EventProcessingConfiguration.class));
        this.addGroup(this.library.getPluginConfigurations(CoverageRadiusConfiguration.class));
        this.addGroup(this.library.getInstalledJars());
        this.setLocationRelativeTo(owner);
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(this.content);
        this.getContentPane().add((Component)pane, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this, false), "South");
    }

    private void addGroup(List<? extends LibraryItem> group) {
        if (group != null && group.size() > 0) {
            LibraryExportGroup export = new LibraryExportGroup(group);
            String name = Model.getInstance().getLibrary().typeName(group.get(0));
            this.groups.add(export);
            this.content.add(new BorderPanel(export, name));
        }
    }
}

