/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.seamcat.interfaces.Dispatcher;
import org.seamcat.interfaces.DuplicateVisitor;
import org.seamcat.model.Library;
import org.seamcat.model.factory.Model;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.plugin.CoverageRadiusConfiguration;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.presentation.WrapLayout;
import org.seamcat.presentation.builder.PanelBuilder;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.library.LibraryImportExportDialog;
import org.seamcat.presentation.library.LibraryImportGroup;

public class LibraryImportDialog
extends LibraryImportExportDialog {
    private final JPanel content;

    public LibraryImportDialog(JFrame owner, Library imported) {
        super(owner, "Import Libraries", 800, 600);
        this.setLayout(new BorderLayout());
        this.content = new JPanel(new WrapLayout());
        this.content.setSize(new Dimension(750, 600));
        this.content.add(PanelBuilder.panel().button("Select All", this, "select").button("Deselect All", this, "deselect").get());
        this.addGroup(imported.getSystems(), this.library.getSystems());
        this.addGroup(imported.getSpectrumEmissionMasks(), this.library.getSpectrumEmissionMasks());
        this.addGroup(imported.getReceiverBlockingMasks(), this.library.getReceiverBlockingMasks());
        this.addGroup(imported.getReceivers(), this.library.getReceivers());
        this.addGroup(imported.getTransmitters(), this.library.getTransmitters());
        this.addGroup(imported.getCDMALinkLevelData(), this.library.getCDMALinkLevelData());
        this.addGroup(imported.getPluginConfigurations(AntennaGainConfiguration.class), this.library.getPluginConfigurations(AntennaGainConfiguration.class));
        this.addGroup(imported.getPluginConfigurations(PropagationModelConfiguration.class), this.library.getPluginConfigurations(PropagationModelConfiguration.class));
        this.addGroup(imported.getPluginConfigurations(EventProcessingConfiguration.class), this.library.getPluginConfigurations(EventProcessingConfiguration.class));
        this.addGroup(imported.getPluginConfigurations(CoverageRadiusConfiguration.class), this.library.getPluginConfigurations(CoverageRadiusConfiguration.class));
        this.addGroup(imported.getInstalledJars(), this.library.getInstalledJars());
        this.setLocationRelativeTo(owner);
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(this.content);
        this.getContentPane().add((Component)pane, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this, false), "South");
    }

    private void addGroup(List<? extends LibraryItem> imported, List<? extends LibraryItem> existing) {
        if (imported != null && imported.size() > 0) {
            LibraryImportGroup group = new LibraryImportGroup(imported, existing);
            String name = Model.getInstance().getLibrary().typeName(imported.get(0));
            this.groups.add(group);
            this.content.add(new BorderPanel(group, name));
        }
    }

    @Override
    public List<LibraryItem> findDuplicateNames() {
        ArrayList<LibraryItem> duplicates = new ArrayList<LibraryItem>();
        List<LibraryItem> selected = this.selectedItems();
        DuplicateVisitor visitor = new DuplicateVisitor(this.library);
        for (LibraryItem identifiable : selected) {
            if (!Dispatcher.dispatch(visitor, identifiable).booleanValue()) continue;
            duplicates.add(identifiable);
        }
        return duplicates;
    }
}

