/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.library;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.seamcat.interfaces.Dispatcher;
import org.seamcat.interfaces.DuplicateVisitor;
import org.seamcat.model.Library;
import org.seamcat.model.factory.Model;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.builder.AsActionListener;
import org.seamcat.presentation.builder.SelectableTablePanel;

public class LibraryImportExportDialog
extends EscapeDialog {
    protected final Library library;
    protected final ArrayList<SelectableTablePanel> groups;

    public LibraryImportExportDialog(JFrame owner, String title, int width, int height) {
        super((Frame)owner, true);
        this.setTitle(title);
        this.setSize(width, height);
        this.library = Model.getInstance().getLibrary();
        this.groups = new ArrayList();
    }

    public List<LibraryItem> findDuplicateNames() {
        ArrayList<LibraryItem> duplicates = new ArrayList<LibraryItem>();
        List<LibraryItem> selected = this.selectedItems();
        DuplicateVisitor visitor = new DuplicateVisitor(this.library);
        for (LibraryItem identifiable : selected) {
            if (!Dispatcher.dispatch(visitor, identifiable).booleanValue()) continue;
            duplicates.add(identifiable);
        }
        return duplicates;
    }

    public List<LibraryItem> selectedItems() {
        ArrayList<LibraryItem> result = new ArrayList<LibraryItem>();
        for (SelectableTablePanel group : this.groups) {
            result.addAll(group.selectedItems());
        }
        return result;
    }

    @AsActionListener(value="deselect")
    private void deSelectAll() {
        for (SelectableTablePanel group : this.groups) {
            group.setAll(false);
        }
    }

    @AsActionListener(value="select")
    private void selectAll() {
        for (SelectableTablePanel group : this.groups) {
            group.setAll(true);
        }
    }
}

