/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.jfree.util.Log;
import org.seamcat.cdma.CDMALinkLevelData;
import org.seamcat.commands.DisplayHelpNameCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.TextWidgetValueUpdatedEvent;
import org.seamcat.function.BitRateMappingImpl;
import org.seamcat.function.BlockingMaskImpl;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.function.EmissionMaskImpl;
import org.seamcat.function.IntermodulationRejectionMaskImpl;
import org.seamcat.model.Library;
import org.seamcat.model.MutableLibraryItem;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.Model;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.systems.generic.ReceiverModel;
import org.seamcat.model.systems.generic.TransmitterModel;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.CoverageRadius;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.FileDialogHelper;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.library.ChangeNotifier;
import org.seamcat.presentation.library.LibraryDetailPanel;
import org.seamcat.presentation.library.LibraryItemWrapper;
import org.seamcat.presentation.menu.ToolBar;
import org.seamcat.presentation.systems.Helper;
import org.seamcat.util.StringHelper;

public class LibraryItemListPanel<M extends LibraryItem>
extends EscapeDialog {
    private static final Logger LOG = Logger.getLogger(LibraryItemListPanel.class);
    private static final Set<Class<? extends LibraryItem>> addClasses = new HashSet<Class>(Arrays.asList(BlockingMask.class, EmissionMask.class, IntermodulationRejectionMask.class, BitRateMapping.class, CDMALLD.class, ReceiverModel.class, TransmitterModel.class, JarConfigurationModel.class));
    private static final Set<Class<? extends LibraryItem>> duplicateClasses = new HashSet<Class>(Arrays.asList(BlockingMask.class, EmissionMask.class, IntermodulationRejectionMask.class, BitRateMapping.class, CDMALLD.class, ReceiverModel.class, TransmitterModel.class, AntennaGain.class, CoverageRadius.class, PropagationModel.class, EventProcessing.class));
    private static final Set<Class<? extends LibraryItem>> restoreClasses = new HashSet<Class>(Arrays.asList(BlockingMask.class, EmissionMask.class, IntermodulationRejectionMask.class, BitRateMapping.class, CDMALLD.class, ReceiverModel.class, TransmitterModel.class, AntennaGain.class, CoverageRadius.class, PropagationModel.class, EventProcessing.class));
    private final JFrame dialog;
    private final int minimumSize;
    public int indexDeleted;
    private Class<M> clazz;
    private LibraryDetailPanel<M> detailPanel;
    private DefaultListModel listModel;
    private JList list;
    private JButton delete;
    private JButton duplicate;
    private JToolBar toolBar = new JToolBar();
    private JFrame ownerFrame;
    private ChangeNotifier notifier;

    public LibraryItemListPanel(JFrame owner, Class<M> clazz, String title, String helpURL, int width, int height, int minimumSize) {
        super((Frame)owner, true);
        Class<?> lafClass;
        this.setTitle(title);
        this.clazz = clazz;
        this.ownerFrame = owner;
        this.dialog = owner;
        this.minimumSize = minimumSize;
        this.toolBar.setFocusable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.notifier = new ChangeNotifier(){

            @Override
            public void changed() {
                LibraryItemListPanel.this.updateModel();
            }
        };
        this.setupToolbar(helpURL);
        this.list = new JList();
        this.list.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.list);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.toolBar, "North");
        leftPanel.add((Component)jScrollPane, "Center");
        leftPanel.add((Component)new NavigateButtonPanel(this, false){

            @Override
            public void btnOkActionPerformed() {
                super.btnOkActionPerformed();
                LibraryItemListPanel.this.closing();
                LibraryItemListPanel.this.destroy();
            }

            @Override
            public void btnCancelActionPerformed() {
                super.btnCancelActionPerformed();
                LibraryItemListPanel.this.destroy();
            }
        }, "South");
        final JSplitPane splitPane = new JSplitPane(1);
        splitPane.add(leftPanel);
        splitPane.add(new JPanel());
        splitPane.setDividerLocation(180);
        this.listModel = new DefaultListModel();
        this.list.setModel(this.listModel);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (LibraryItemListPanel.this.list.getModel().getSize() == 0) {
                    splitPane.setRightComponent(new JPanel());
                }
                if (!LibraryItemListPanel.this.listModel.isEmpty() && LibraryItemListPanel.this.list.getSelectedIndex() != -1) {
                    LibraryItemListPanel.this.updateModel();
                    Object model = ((LibraryItemWrapper)LibraryItemListPanel.this.listModel.get(LibraryItemListPanel.this.list.getSelectedIndex())).getItem();
                    LibraryItemListPanel.this.detailPanel = new LibraryDetailPanel(LibraryItemListPanel.this.ownerFrame, LibraryItemListPanel.this.clazz, new LibraryItemWrapper(LibraryItemListPanel.this.list.getSelectedIndex(), model), LibraryItemListPanel.this.notifier, true);
                    splitPane.setRightComponent(LibraryItemListPanel.this.detailPanel);
                }
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u007f') {
                    LibraryItemListPanel.this.handleDelete();
                }
            }
        });
        this.setModel(Model.getInstance().getLibrary().getGroup(clazz));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)splitPane, "Center");
        this.setSize(width, height);
        this.setLocationRelativeTo(owner);
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf != null && (lafClass = laf.getClass()) != null && lafClass.toString().contains("MetalLookAndFeel")) {
            this.setResizable(false);
            if (Log.isDebugEnabled()) {
                Log.debug("Metal LAF detected. Resizing of interfering link dialog disabled");
            }
        }
        EventBusFactory.getEventBus().subscribe(this);
    }

    @UIEventHandler
    public void handle(TextWidgetValueUpdatedEvent event) {
        if (this.detailPanel != null && this.detailPanel.match(event.getContext())) {
            this.updateModel();
        }
    }

    private void setupToolbar(String helpClass) {
        JButton button;
        if (addClasses.contains(this.clazz)) {
            button = ToolBar.button("SEAMCAT_ICON_ADD", "TOOLBAR_LIBRARY_ADD_TOOLTIP");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LibraryItemListPanel.this.handleAdd();
                }
            });
            this.toolBar.add(button);
        }
        if (duplicateClasses.contains(this.clazz)) {
            this.duplicate = ToolBar.button("SEAMCAT_ICON_DUPLICATE", "TOOLBAR_LIBRARY_DUPLICATE_TOOLTIP");
            this.duplicate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LibraryItemListPanel.this.handleDuplicate();
                }
            });
            this.toolBar.add(this.duplicate);
        }
        this.delete = ToolBar.button("SEAMCAT_ICON_DELETE_TRASH", "TOOLBAR_LIBRARY_DELETE_TOOLTIP");
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryItemListPanel.this.handleDelete();
            }
        });
        this.toolBar.add(this.delete);
        if (restoreClasses.contains(this.clazz)) {
            button = ToolBar.button("SEAMCAT_ICON_RESTORE_DEFAULTS", "TOOLBAR_LIBRARY_RESTORE_DEFAULTS_TOOLTIP");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DialogHelper.restoreLibrary(LibraryItemListPanel.this.dialog)) {
                        LibraryItemListPanel.this.resetToDefaults();
                    }
                }
            });
            this.toolBar.add(button);
        }
        this.toolBar.addSeparator();
        this.toolBar.add(ToolBar.button("SEAMCAT_ICON_HELP", "HELP_CONTENTS_MENU_ITEM_TEXT", new DisplayHelpNameCommand(helpClass)));
    }

    private void updateButton() {
        boolean someSelected = this.list.getSelectedValue() != null && this.list.getModel().getSize() > this.minimumSize;
        this.delete.setEnabled(someSelected);
        if (this.duplicate != null) {
            this.duplicate.setEnabled(someSelected);
        }
    }

    private void setModel(Collection<M> elements) {
        this.listModel.clear();
        for (LibraryItem model : elements) {
            this.listModel.addElement(new LibraryItemWrapper<LibraryItem>(this.listModel.size(), model));
        }
        this.list.setSelectedIndex(0);
        this.updateButton();
    }

    public void handleAdd() {
        block18: {
            if (this.clazz == EmissionMask.class) {
                this.add(new EmissionMaskImpl());
            } else if (this.clazz == BlockingMask.class) {
                this.add(new BlockingMaskImpl());
            } else if (this.clazz == IntermodulationRejectionMask.class) {
                this.add(new IntermodulationRejectionMaskImpl());
            } else if (this.clazz == BitRateMapping.class) {
                this.add(new BitRateMappingImpl(new DiscreteFunction(0.0), new DescriptionImpl("Bitrate Mapping", "")));
            } else if (this.clazz == JarConfigurationModel.class) {
                FileDialogHelper helper = new FileDialogHelper();
                if (helper.chooseJar(this).selectionMade()) {
                    File selectedJarFile = helper.getSelectedFile();
                    try {
                        if (selectedJarFile.exists() && selectedJarFile.canRead()) {
                            JarConfigurationModel model = new JarConfigurationModel(selectedJarFile);
                            if (!this.getModel().contains(model)) {
                                this.add(model);
                            }
                            break block18;
                        }
                        LOG.warn(String.format("File %s does not exist or cannot be read", selectedJarFile.getName()));
                    }
                    catch (RuntimeException e) {
                        DialogHelper.generalSeamcatError(e.getMessage());
                    }
                }
            } else if (this.clazz == CDMALLD.class) {
                this.add(new CDMALinkLevelData().getModel());
            } else {
                String title = "DEFAULT_TX";
                if (ReceiverModel.class.isAssignableFrom(this.clazz)) {
                    title = "DEFAULT_RX";
                }
                M model = ProxyHelper.newComposite(this.clazz, this.getDuplicatedName(title));
                this.add(model);
            }
        }
    }

    public void resetToDefaults() {
        this.detailPanel = null;
        List<M> defaults = Model.getDefaultsForType(this.clazz);
        this.setModel(defaults);
    }

    private void handleDuplicate() {
        LibraryItem clone;
        M model = this.detailPanel.getModel();
        if (model instanceof Configuration) {
            Configuration configuration = ((Configuration)model).copy();
            ((MutableLibraryItem)((Object)configuration)).setDescription(new DescriptionImpl(this.getDuplicatedName(model.description().name()), configuration.description().description()));
            clone = configuration;
        } else if (model instanceof BlockingMaskImpl) {
            BlockingMaskImpl current = (BlockingMaskImpl)model;
            BlockingMaskImpl mask = (BlockingMaskImpl)Factory.functionFactory().blockingMask(current.getFunction(), (Description)new DescriptionImpl(this.getDuplicatedName(current.description().name()), current.description().description()));
            clone = mask;
        } else if (model instanceof EmissionMaskImpl) {
            EmissionMaskImpl mask = ((EmissionMaskImpl)model).copy();
            mask.setDescription(new DescriptionImpl(this.getDuplicatedName(mask.description().name()), mask.description().description()));
            clone = mask;
        } else if (model instanceof IntermodulationRejectionMaskImpl) {
            IntermodulationRejectionMaskImpl current = (IntermodulationRejectionMaskImpl)model;
            IntermodulationRejectionMaskImpl mask = (IntermodulationRejectionMaskImpl)Factory.functionFactory().intermodulationRejectMask(current.getFunction(), new DescriptionImpl(this.getDuplicatedName(current.description().name()), current.description().description()));
            clone = mask;
        } else if (model instanceof BitRateMapping) {
            BitRateMapping bitRateMapping = (BitRateMapping)model;
            BitRateMapping copy = Factory.functionFactory().bitRateMapping(bitRateMapping.getFunction(), new DescriptionImpl(this.getDuplicatedName(model.description().name()), model.description().description()));
            clone = copy;
        } else if (model instanceof CDMALinkLevelData) {
            CDMALinkLevelData lld = new CDMALinkLevelData(((CDMALinkLevelData)model).getModel());
            lld.setSystem(this.getDuplicatedName(lld.getSystem()));
            clone = (LibraryItem)((Object)lld);
        } else {
            Description name = Helper.changeName(model.description(), this.getDuplicatedName(model.description().name()));
            clone = (LibraryItem)ProxyHelper.deepCloneComposite(this.clazz, model, name);
        }
        this.add(clone);
    }

    protected void add(M model) {
        this.listModel.addElement(new LibraryItemWrapper<M>(this.listModel.size(), model));
        this.list.setSelectedIndex(this.listModel.getSize() - 1);
        this.updateButton();
    }

    private void handleDelete() {
        LibraryItemWrapper model = (LibraryItemWrapper)this.list.getSelectedValue();
        this.indexDeleted = this.list.getSelectedIndex();
        if (model != null && this.confirmDelete(model.getItem())) {
            this.detailPanel = null;
            this.listModel.removeElement(model);
            if (this.list.getModel().getSize() == this.indexDeleted) {
                this.list.setSelectedIndex(this.indexDeleted - 1);
            } else {
                this.list.setSelectedIndex(this.indexDeleted);
            }
            this.updateButton();
        }
    }

    public boolean confirmDelete(M selected) {
        List<Configuration> instances;
        JarConfigurationModel toBeDeleted;
        if (selected instanceof JarConfigurationModel && (toBeDeleted = (JarConfigurationModel)selected).getPluginClasses() != null && !(instances = Model.getInstance().getLibrary().getConfigurationsForJar(toBeDeleted)).isEmpty()) {
            StringBuilder sb = new StringBuilder("To delete selected jar-file the following library configuration(s) will also be deleted:\n");
            for (Configuration instance : instances) {
                if (instance == null || instance.description() == null) continue;
                sb.append("* ").append(instance.description().name()).append("\n");
            }
            sb.append("\nProceed?");
            return 0 == JOptionPane.showConfirmDialog(MainWindow.getInstance(), sb.toString(), "Deleting configurations", 2, 2);
        }
        return true;
    }

    protected void updateModel() {
        if (this.detailPanel != null) {
            M model = this.detailPanel.getModel();
            int index = this.detailPanel.getIndex();
            if (index < this.listModel.size()) {
                this.listModel.setElementAt(new LibraryItemWrapper<M>(index, model), index);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LibraryItemListPanel.this.list.updateUI();
                    }
                });
            }
        }
    }

    void closing() {
        this.updateModel();
        Library library = Model.getInstance().getLibrary();
        library.writeAll(this.clazz, this.getModel());
        library.ensureConsistentLibrary();
    }

    void destroy() {
        EventBusFactory.getEventBus().unsubscribe(this);
    }

    public List<M> getModel() {
        ArrayList elements = new ArrayList();
        for (int i = 0; i < this.listModel.size(); ++i) {
            elements.add(((LibraryItemWrapper)this.listModel.get(i)).getItem());
        }
        return elements;
    }

    protected String getDuplicatedName(String original) {
        return StringHelper.getDuplicatedName(original, this.listModel);
    }
}

