/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.localenvironments;

import java.util.List;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.DoubleItem;
import org.seamcat.presentation.genericgui.panelbuilder.ChangeListener;
import org.seamcat.presentation.localenvironments.EnvironmentFormatter;

public interface AddIndoorLocalEnvironmentUI {
    public static final String groupName = "BEL";
    public static final boolean useBEL = false;
    public static final Distribution probExceeding = Factory.distributionFactory().getConstantDistribution(50.0);
    public static final String title = "Traditional buildings";
    public static final String defaultTitle = "Traditional buildings [50% traditional and 50% thermal efficient building]";
    public static final double traditionalBuildings = 50.0;
    public static final ChangeListener<AddIndoorLocalEnvironmentUI> change = new ChangeListener<AddIndoorLocalEnvironmentUI>(){

        @Override
        public void handle(AddIndoorLocalEnvironmentUI model, List<AbstractItem> items, AbstractItem changedItem) {
            for (AbstractItem item : items) {
                if (!(item instanceof DoubleItem) || !item.getLabel().startsWith(AddIndoorLocalEnvironmentUI.title)) continue;
                double trad = (Double)item.getValue();
                if (trad < 0.0) {
                    trad = 0.0;
                } else if (trad > 100.0) {
                    trad = 100.0;
                }
                item.setLabelText(EnvironmentFormatter.format(trad));
            }
        }
    };

    @Config(order=1, name="Probability", unit="%", toolTip="of indoor locations")
    public double probability();

    @Config(order=2, name="Wall Loss", unit="dB", invertedGroup="BEL")
    public double wallLoss();

    @Config(order=3, name="Std. Dev.", unit="dB", invertedGroup="BEL")
    public double stdDev();

    @Config(order=5, name="Use Recommendation ITU-R P.2109 for the prediction of building entry loss", defineGroup="BEL")
    public boolean useBEL();

    @Config(order=6, name="Probability of not exceeding the (nominal) building entry loss", group="BEL", unit="%", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "USER_DEFINED", "STAIR"})
    public Distribution probExceeding();

    @Config(order=7, name="Traditional buildings [50% traditional and 50% thermal efficient building]", unit="%", group="BEL")
    public double traditionalBuildings();
}

