/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.localenvironments;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.LabeledPairLayout;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.components.ScrollingBorderPanel;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;
import org.seamcat.presentation.localenvironments.OutdoorEarthToSpaceUI;
import org.seamcat.presentation.localenvironments.OutdoorGeneralUI;
import org.seamcat.presentation.localenvironments.OutdoorModel;
import org.seamcat.presentation.localenvironments.OutdoorSpecificUI;

public class OutdoorEnvironmentDialog
extends EscapeDialog {
    private JPanel detailHolder = new JPanel(new BorderLayout());
    private GenericPanelEditor detail;
    private JFrame owner;
    private final OutdoorModel model;
    private DefaultComboBoxModel<LocalEnvironment.OutdoorClutterMode> modes;
    private JCheckBox applyClutter = new JCheckBox("Apply clutter");

    OutdoorEnvironmentDialog(JFrame owner, OutdoorModel model) {
        super((Frame)owner, true);
        this.owner = owner;
        this.model = model;
        this.setTitle("Edit Outdoor Environment");
        this.setSize(800, 600);
        this.getContentPane().setLayout(new BorderLayout());
        this.updateDetail(model.getCurrentUI());
        JPanel panel = this.createPanel();
        this.getContentPane().add((Component)new ScrollingBorderPanel(panel, "Outdoor Local Environment"), "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this, false), "South");
    }

    private JPanel createPanel() {
        JPanel topPanel = new JPanel(new LabeledPairLayout());
        final JComboBox<LocalEnvironment.OutdoorClutterMode> comboBox = new JComboBox<LocalEnvironment.OutdoorClutterMode>();
        this.applyClutter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutdoorEnvironmentDialog.this.enableClutter(comboBox, OutdoorEnvironmentDialog.this.applyClutter.isSelected());
            }
        });
        this.applyClutter.setSelected(this.model.isApplyOutdoorClutter());
        this.enableClutter(comboBox, this.model.isApplyOutdoorClutter());
        topPanel.add((Component)this.applyClutter, "label");
        topPanel.add((Component)new JLabel(""), "field");
        topPanel.add((Component)new JLabel("Clutter Model (Rec. ITU-R P.2108-0)"), "label");
        topPanel.add(comboBox, "field");
        this.modes = new DefaultComboBoxModel();
        this.modes.addElement(LocalEnvironment.OutdoorClutterMode.SPECIFIC);
        this.modes.addElement(LocalEnvironment.OutdoorClutterMode.GENERAL);
        this.modes.addElement(LocalEnvironment.OutdoorClutterMode.EARTH_TO_SPACE);
        comboBox.setModel(this.modes);
        comboBox.setSelectedItem((Object)this.model.getMode());
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalEnvironment.OutdoorClutterMode mode = (LocalEnvironment.OutdoorClutterMode)((Object)OutdoorEnvironmentDialog.this.modes.getSelectedItem());
                OutdoorEnvironmentDialog.this.model.setMode(mode);
                OutdoorEnvironmentDialog.this.updateDetail(OutdoorEnvironmentDialog.this.model.getCurrentUI());
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)topPanel, "North");
        panel.add((Component)this.detailHolder, "Center");
        return panel;
    }

    private void enableClutter(JComboBox comboBox, boolean enable) {
        comboBox.setEnabled(enable);
        if (enable) {
            this.updateDetail(this.model.getCurrentUI());
        } else {
            this.updateDetail(null);
        }
    }

    private void updateDetail(Object currentUI) {
        this.detail = null;
        if (currentUI instanceof OutdoorSpecificUI) {
            this.detail = new GenericPanelEditor<OutdoorSpecificUI>(this.owner, OutdoorSpecificUI.class, (OutdoorSpecificUI)currentUI);
        } else if (currentUI instanceof OutdoorGeneralUI) {
            this.detail = new GenericPanelEditor<OutdoorGeneralUI>(this.owner, OutdoorGeneralUI.class, (OutdoorGeneralUI)currentUI);
        } else if (currentUI instanceof OutdoorEarthToSpaceUI) {
            this.detail = new GenericPanelEditor<OutdoorEarthToSpaceUI>(this.owner, OutdoorEarthToSpaceUI.class, (OutdoorEarthToSpaceUI)currentUI);
        }
        this.detailHolder.removeAll();
        if (this.detail != null) {
            this.detailHolder.add((Component)this.detail, "Center");
        }
        this.detailHolder.revalidate();
        this.detailHolder.repaint();
    }

    public OutdoorModel getModel() {
        this.model.setMode((LocalEnvironment.OutdoorClutterMode)((Object)this.modes.getSelectedItem()));
        this.model.setApplyOutdoorClutter(this.applyClutter.isSelected());
        if (this.detail != null) {
            Object detailModel = this.detail.getModel();
            if (detailModel instanceof OutdoorGeneralUI) {
                this.model.setGeneral((OutdoorGeneralUI)detailModel);
            } else if (detailModel instanceof OutdoorSpecificUI) {
                this.model.setSpecific((OutdoorSpecificUI)detailModel);
            } else {
                this.model.setEarthToSpace((OutdoorEarthToSpaceUI)detailModel);
            }
        }
        return this.model;
    }
}

