/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.seamcat.commands.CloseAllWorkspaceCommand;
import org.seamcat.commands.CloseApplicationCommand;
import org.seamcat.commands.CloseOthersWorkspaceCommand;
import org.seamcat.commands.CloseUnmodifiedWorkspaceCommand;
import org.seamcat.commands.CloseWorkspaceCommand;
import org.seamcat.commands.DisplayAboutCommand;
import org.seamcat.commands.DisplayCompareVectorCommand;
import org.seamcat.commands.DisplayConfigurationCommand;
import org.seamcat.commands.DisplayDistributionTestCommand;
import org.seamcat.commands.DisplayHelpCommand;
import org.seamcat.commands.DisplayLibraryCommand;
import org.seamcat.commands.DisplayPropagationTestCommand;
import org.seamcat.commands.DisplayReportErrorCommand;
import org.seamcat.commands.DisplayStatusBarCommand;
import org.seamcat.commands.DisplaySystemsLibraryCommand;
import org.seamcat.commands.DisplayTestCalculatorCommand;
import org.seamcat.commands.DisplayTestFunctionsCommand;
import org.seamcat.commands.DisplayVectorScatterCommand;
import org.seamcat.commands.DisplayWelcomeCommand;
import org.seamcat.commands.ExportLibraryCommand;
import org.seamcat.commands.ImportLibraryCommand;
import org.seamcat.commands.NewBatchCommand;
import org.seamcat.commands.NewWorkspaceCommand;
import org.seamcat.commands.OpenWorkspaceCommand;
import org.seamcat.commands.SaveAllWorkspacesCommand;
import org.seamcat.commands.SaveWorkspaceAsCommand;
import org.seamcat.commands.SaveWorkspaceCommand;
import org.seamcat.commands.ShowToolBarCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.SimulationCompleteEvent;
import org.seamcat.events.SimulationStartedEvent;
import org.seamcat.events.WorkspacesPaneEmptyEvent;
import org.seamcat.events.WorkspacesPaneNonEmptyEvent;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.systems.generic.ReceiverModel;
import org.seamcat.model.systems.generic.TransmitterModel;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.CoverageRadius;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.presentation.SeamcatIcons;
import org.seamcat.presentation.menu.HistoryItemsMenu;

public class Menus {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private static final int keyModifier = 192;
    private JMenuItem welcomeItem;
    private HistoryItemsMenu historyItemsMenu;
    private JMenuItem openWorkspace;
    private JMenuItem saveWorkspace;
    private JMenuItem saveWorkspaceAs;
    private JMenuItem saveAllWorkspaces;
    private JMenuItem closeWorkspace;
    private JMenuItem closeOthers;
    private JMenuItem closeAll;
    private JMenuItem closeUnmodified;
    private JMenuItem importLibrary;
    private JMenuItem exportLibrary;
    private JMenuItem configuration;
    private JMenuItem newBatch;

    public Menus() {
        EventBusFactory.getEventBus().subscribe(this);
    }

    public JMenuBar createMenus(JMenuBar menuBar) {
        this.createMenuFile(menuBar);
        this.createMenuView(menuBar);
        this.createMenuLibrary(menuBar);
        this.createMenuTools(menuBar);
        this.createHelpMenu(menuBar);
        return menuBar;
    }

    private void createMenuFile(JMenuBar menuBar) {
        JMenu menu = new JMenu();
        menu.setText(STRINGLIST.getString("FILE_MENU_TEXT"));
        menu.setMnemonic(70);
        this.createMenuItemNewWorkspace(menu);
        this.createMenuItemBatchOperation(menu);
        this.createMenuItemOpenWorkspace(menu);
        menu.addSeparator();
        this.createMenuItemSaveWorkspace(menu);
        this.createMenuItemSaveWorkspaceAs(menu);
        this.createMenuItemSaveAllWorkspaces(menu);
        menu.addSeparator();
        this.createMenuItemCloseWorkspace(menu);
        menu.addSeparator();
        this.createMenuItemImportLibrary(menu);
        this.createMenuItemExportLibrary(menu);
        menu.addSeparator();
        this.createMenuItemConfiguration(menu);
        menu.addSeparator();
        this.historyItemsMenu = new HistoryItemsMenu(menu);
        this.createMenuItemExit(menu);
        menuBar.add(menu);
    }

    private void createMenuView(JMenuBar menuBar) {
        JMenu menu = new JMenu(STRINGLIST.getString("VIEW_MENU_TEXT"));
        menu.setMnemonic(86);
        this.createMenuItemViewToolBar(menu);
        this.createMenuItemViewStatusBar(menu);
        menuBar.add(menu);
    }

    private void createMenuLibrary(JMenuBar menuBar) {
        JMenu menu = new JMenu(STRINGLIST.getString("LIBRARY_MENU_TEXT"));
        menu.setMnemonic(76);
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_SYSTEMS", null, "MENU_ITEM_TOOLTIP_LIBRARY_SYSTEMS", new DisplaySystemsLibraryCommand(), 83, 192, 83));
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_SEM", null, "MENU_ITEM_TOOLTIP_LIBRARY_SPECTRUM", new DisplayLibraryCommand(EmissionMask.class, "Spectrum emission mask library", "http://confluence.seamcat.org/display/SH/13.4.2+Spectrum+emission+mask+elements", 800, 500), 77, 192, 77));
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_RBM", null, "MENU_ITEM_TOOLTIP_LIBRARY_BLOCKING", new DisplayLibraryCommand(BlockingMask.class, "Receiver blocking mask library", "http://confluence.seamcat.org/display/SH/13.4.3+Receiver+blocking+mask+elements", 800, 500), 66, 192, 66));
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_IRM", null, "MENU_ITEM_TOOLTIP_LIBRARY_INTERMOD", new DisplayLibraryCommand(IntermodulationRejectionMask.class, "Intermodulation rejection mask library", "", 800, 500)));
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_RECEIVERS", null, "MENU_ITEM_TOOLTIP_LIBRARY_RECEIVERS", new DisplayLibraryCommand(ReceiverModel.class, "Receiver library", "http://confluence.seamcat.org/display/SH/13.4.4+Receiver+elements", 1300, 600), 82, 192, 82));
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_TRANSMITTERS", null, "MENU_ITEM_TOOLTIP_LIBRARY_TRANSMITTERS", new DisplayLibraryCommand(TransmitterModel.class, "Transmitter library", "http://confluence.seamcat.org/display/SH/13.4.5+Transmitter+elements", 1300, 600), 84, 192, 84));
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_BR", null, "MENU_ITEM_TOOLTIP_LIBRARY_BITRATE", new DisplayLibraryCommand(BitRateMapping.class, "Bitrate mapping (Link Level Performance) library", "", 800, 500)));
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_CDMA_LINK_LEVEL_DATA", null, "MENU_ITEM_TOOLTIP_LIBRARY_CDMA_LINK_LEVEL_DATA", new DisplayLibraryCommand(CDMALLD.class, "CDMA Link level data library", "http://confluence.seamcat.org/display/SH/13.4.6+CDMA+Link+level+data", 800, 500), 76, 192, 76));
        menu.addSeparator();
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_ANTENNAS", null, "MENU_ITEM_TOOLTIP_LIBRARY_ANTENNAS", new DisplayLibraryCommand(AntennaGain.class, "Antenna library", "http://confluence.seamcat.org/display/SH/13.5.1+Antenna+plugin+elements", 1000, 500), 65, 192, 65));
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_COVERAGE_RADIUS", null, "MENU_ITEM_TOOLTIP_COVERAGE_RADIUS", new DisplayLibraryCommand(CoverageRadius.class, "Coverage radius library", "http://confluence.seamcat.org/display/SH/13.5.2+Coverage+radius+plugin+elements", 800, 500), 67, 192, 67));
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_PROPAGATION_MODEL_PLUGINS", null, "MENU_ITEM_TOOLTIP_LIBRARY_PROPAGATION_MODEL_PLUGINS", new DisplayLibraryCommand(PropagationModel.class, "Propagation model library", "http://confluence.seamcat.org/display/SH/13.5.3+Propagation+model+plugin", 800, 500), 80, 192, 80));
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_EVENT_PROCESSING_PLUGINS", null, "MENU_ITEM_TOOLTIP_LIBRARY_EVENT_PROCESSING_PLUGINS", new DisplayLibraryCommand(EventProcessing.class, "Event processing library", "http://confluence.seamcat.org/display/SH/13.5.4+Event+Processing+Plugin", 800, 500), 69, 192, 69));
        menu.addSeparator();
        menu.add(this.item("MENU_ITEM_TEXT_LIBRARY_INSTALL_JARS", null, "MENU_ITEM_TOOLTIP_LIBRARY_INSTALL_JAR", new DisplayLibraryCommand(JarConfigurationModel.class, "Jar library", "http://confluence.seamcat.org/display/SH/2.23+Installing+plugins+in+SEAMCAT", 800, 500, 0), 74, 192, 74));
        menuBar.add(menu);
    }

    private void createMenuTools(JMenuBar menuBar) {
        JMenu menu = new JMenu();
        menu.setText(STRINGLIST.getString("TOOLS_MENU_TEXT"));
        menu.setMnemonic(84);
        this.createMenuTestDistributions(menu);
        this.createMenuTestPropagationModel(menu);
        this.createMenuTestFunctions(menu);
        menu.addSeparator();
        this.createMenuTestCalculator(menu);
        menu.addSeparator();
        this.createMenuVectors(menu);
        menuBar.add(menu);
    }

    private void createHelpMenu(JMenuBar menuBar) {
        JMenu menu = new JMenu();
        menu.setText(STRINGLIST.getString("HELP_MENU_TEXT"));
        menu.setMnemonic(72);
        this.createMenuItemHelp(menu);
        this.createMenuReportError(menu);
        this.createMenuAbout(menu);
        this.createMenuWelcome(menu);
        menuBar.add(menu);
    }

    private void createMenuVectors(JMenu menu) {
        JMenuItem item = this.item("TEST_COMPARE_VECTORS_MENU_ITEM_TEXT", "SEAMCAT_ICON_INTERFERENCE_CALCULATIONS", "TEST_COMPARE_VECTORS_MENU_ITEM_TOOLTIP", new DisplayCompareVectorCommand());
        menu.add(item);
        JMenuItem scatter = this.item("TEST_VECTOR_SCATTER_MENU_ITEM_TEXT", null, "TEST_VECTOR_SCATTER_MENU_ITEM_TOOLTIP", new DisplayVectorScatterCommand());
        menu.add(scatter);
    }

    private void createMenuItemBatchOperation(JMenu menu) {
        this.newBatch = this.item("MENU_ITEM_TEXT_NEW_BATCH_OPERATION", "SEAMCAT_ICON_NEW_BATCH", "MENU_ITEM_TOOLTIP_BATCH_OPERATION", new NewBatchCommand());
        menu.add(this.newBatch);
    }

    private void createMenuTestDistributions(JMenu menu) {
        JMenuItem item = this.item("TEST_DISTRIBUTIONS_MENU_ITEM_TEXT", "SEAMCAT_ICON_TEST_DISTRIBUTION", "TEST_DISTRIBUTIONS_MENU_ITEM_TOOLTIP", new DisplayDistributionTestCommand());
        item.setAccelerator(KeyStroke.getKeyStroke(68, 192));
        item.setMnemonic(68);
        menu.add(item);
    }

    private void createMenuTestPropagationModel(JMenu menu) {
        JMenuItem item = this.item("TEST_PROPAGATIONS_MENU_ITEM_TEXT", "SEAMCAT_ICON_TEST_PROPAGATION", "TEST_PROPAGATIONS_MENU_ITEM_TOOLTIP", new DisplayPropagationTestCommand());
        item.setAccelerator(KeyStroke.getKeyStroke(77, 192));
        item.setMnemonic(77);
        menu.add(item);
    }

    private void createMenuTestFunctions(JMenu menu) {
        JMenuItem item = this.item("TEST_FUNCTIONS_MENU_ITEM_TEXT", "SEAMCAT_ICON_TEST_UNWANTED", "TEST_FUNCTIONS_MENU_ITEM_TOOLTIP", new DisplayTestFunctionsCommand());
        item.setAccelerator(KeyStroke.getKeyStroke(85, 192));
        item.setMnemonic(85);
        menu.add(item);
    }

    private void createMenuTestCalculator(JMenu menu) {
        JMenuItem item = this.item("TEST_CALCULATOR_MENU_ITEM_TEXT", "SEAMCAT_ICON_CALCULATOR", "TEST_CALCULATOR_MENU_ITEM_TOOLTIP", new DisplayTestCalculatorCommand());
        item.setAccelerator(KeyStroke.getKeyStroke(67, 192));
        item.setMnemonic(67);
        menu.add(item);
    }

    private void createMenuItemHelp(JMenu menu) {
        menu.add(this.item("HELP_CONTENTS_MENU_ITEM_TEXT", "SEAMCAT_ICON_HELP", "HELP_CONTENTS_MENU_ITEM_TOOLTIP", new DisplayHelpCommand(), 112, 0, 72));
    }

    private void createMenuReportError(JMenu menu) {
        menu.add(this.item("SEND_ERROR_REPORT", "SEAMCAT_ICON_BUG_ERROR", "ERROR_REPORT_MENU_ITEM_TOOLTIP", new DisplayReportErrorCommand()));
    }

    private void createMenuAbout(JMenu menu) {
        menu.add(this.item("ABOUT", null, "ABOUT_SEAMCAT_MENU_ITEM_TOOLTIP", new DisplayAboutCommand()));
    }

    private void createMenuWelcome(JMenu menu) {
        this.welcomeItem = this.item("WELCOME", null, "WELCOME_MENU_ITEM_TOOLTIP", new DisplayWelcomeCommand());
        this.welcomeItem.setEnabled(true);
        menu.add(this.welcomeItem);
    }

    private void createMenuItemViewStatusBar(JMenu menu) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem();
        menuItem.addActionListener(Menus.action(new DisplayStatusBarCommand()));
        menuItem.setText(STRINGLIST.getString("MENU_ITEM_TEXT_VIEW_STATUS_BAR"));
        menuItem.setToolTipText(STRINGLIST.getString("MENU_ITEM_TOOLTIP_VIEW_STATUS_BAR"));
        menuItem.setMnemonic(83);
        menuItem.setSelected(true);
        menu.add(menuItem);
    }

    private void createMenuItemNewWorkspace(JMenu menu) {
        menu.add(this.item("MENU_ITEM_TEXT_NEW_WORKSPACE", "SEAMCAT_ICON_WORKSPACE_NEW", "MENU_ITEM_TOOLTIP_NEW_WORKSPACE", new NewWorkspaceCommand(), 78, 128, 78));
    }

    private void createMenuItemOpenWorkspace(JMenu menu) {
        this.openWorkspace = this.item("MENU_ITEM_TEXT_OPEN_WORKSPACE", "SEAMCAT_ICON_WORKSPACE_OPEN", "MENU_ITEM_TOOLTIP_OPEN_WORKSPACE", new OpenWorkspaceCommand(), 79, 2, 79);
        menu.add(this.openWorkspace);
    }

    private void createMenuItemSaveWorkspace(JMenu menu) {
        this.saveWorkspace = this.item("MENU_ITEM_TEXT_SAVE_WORKSPACE", "SEAMCAT_ICON_WORKSPACE_SAVE", "MENU_ITEM_TOOLTIP_SAVE_WORKSPACE", new SaveWorkspaceCommand(), 83, 2, 83);
        menu.add(this.saveWorkspace);
    }

    private void createMenuItemSaveWorkspaceAs(JMenu menu) {
        this.saveWorkspaceAs = this.item("MENU_ITEM_TEXT_SAVE_WORKSPACE_AS", "SEAMCAT_ICON_WORKSPACE_SAVEAS", "MENU_ITEM_TOOLTIP_SAVE_WORKSPACE_AS", new SaveWorkspaceAsCommand());
        menu.add(this.saveWorkspaceAs);
    }

    private void createMenuItemSaveAllWorkspaces(JMenu menu) {
        this.saveAllWorkspaces = this.item("MENU_ITEM_TEXT_SAVE_ALL_WORKSPACES", "SEAMCAT_ICON_WORKSPACE_SAVEALL", "MENU_ITEM_TOOLTIP_SAVE_ALL_WORKSPACES", new SaveAllWorkspacesCommand());
        menu.add(this.saveAllWorkspaces);
    }

    private void createMenuItemCloseWorkspace(JMenu menu) {
        this.closeWorkspace = this.item("MENU_ITEM_TEXT_CLOSE_WORKSPACE", "SEAMCAT_ICON_WORKSPACE_CLOSE", "MENU_ITEM_TOOLTIP_CLOSE_WORKSPACE", new CloseWorkspaceCommand(), 67, 2, 67);
        menu.add(this.closeWorkspace);
        this.closeOthers = this.item("MENU_ITEM_TEXT_CLOSE_OTHERS_WORKSPACE", null, "MENU_ITEM_TOOLTIP_CLOSE_OTHERS_WORKSPACE", new CloseOthersWorkspaceCommand());
        menu.add(this.closeOthers);
        this.closeAll = this.item("MENU_ITEM_TEXT_CLOSE_ALL_WORKSPACE", null, "MENU_ITEM_TOOLTIP_CLOSE_ALL_WORKSPACE", new CloseAllWorkspaceCommand(), 65, 2, 65);
        menu.add(this.closeAll);
        this.closeUnmodified = this.item("MENU_ITEM_TEXT_CLOSE_UNMODIFIED_WORKSPACE", null, "MENU_ITEM_TOOLTIP_CLOSE_UNMODIFIED_WORKSPACE", new CloseUnmodifiedWorkspaceCommand(), 85, 2, 85);
        menu.add(this.closeUnmodified);
    }

    private void createMenuItemImportLibrary(JMenu menu) {
        this.importLibrary = this.item("MENU_ITEM_TEXT_IMPORT_LIBRARY", "SEAMCAT_ICON_IMPORT_LIBRARY", "MENU_ITEM_TOOLTIP_IMPORT_LIBRARY", new ImportLibraryCommand(), 73, 192, 73);
        menu.add(this.importLibrary);
    }

    private void createMenuItemExportLibrary(JMenu menu) {
        this.exportLibrary = this.item("MENU_ITEM_TEXT_EXPORT_LIBRARY", "SEAMCAT_ICON_EXPORT_LIBRARY", "MENU_ITEM_TOOLTIP_EXPORT_LIBRARY", new ExportLibraryCommand(), 69, 192, 69);
        menu.add(this.exportLibrary);
    }

    private void createMenuItemConfiguration(JMenu menu) {
        this.configuration = this.item("MENU_ITEM_TEXT_CONFIGURATION", "SEAMCAT_ICON_CONFIGURATION", "MENU_ITEM_TOOLTIP_CONFIGURATION", new DisplayConfigurationCommand(), 71, 2, 71);
        menu.add(this.configuration);
    }

    private void createMenuItemExit(JMenu menu) {
        menu.add(this.item("MENU_ITEM_TEXT_EXIT", "SEAMCAT_ICON_EXIT", "MENU_ITEM_TOOLTIP_EXIT", new CloseApplicationCommand(), 88, 2, 88));
    }

    private void createMenuItemViewToolBar(JMenu menu) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem();
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e.getSource();
                EventBusFactory.getEventBus().publish(new ShowToolBarCommand(menuItem.isSelected()));
            }
        });
        menuItem.setText(STRINGLIST.getString("MENU_ITEM_TEXT_VIEW_TOOL_BAR"));
        menuItem.setToolTipText(STRINGLIST.getString("MENU_ITEM_TOOLTIP_VIEW_TOOL_BAR"));
        menuItem.setMnemonic(84);
        menuItem.setSelected(true);
        menu.add(menuItem);
    }

    private JMenuItem item(String text, String icon, String tooltip, Object command) {
        JMenuItem item = new JMenuItem();
        item.setText(STRINGLIST.getString(text));
        if (command != null) {
            item.addActionListener(Menus.action(command));
        }
        if (icon != null) {
            item.setIcon(SeamcatIcons.getImageIcon(icon));
        }
        if (tooltip != null) {
            item.setToolTipText(STRINGLIST.getString(tooltip));
        }
        return item;
    }

    private JMenuItem item(String text, String icon, String toolTip, Object command, Integer key, Integer inputEvent, Integer keyEvent) {
        JMenuItem item = this.item(text, icon, toolTip, command);
        item.setAccelerator(KeyStroke.getKeyStroke(key, (int)inputEvent));
        item.setMnemonic(keyEvent);
        return item;
    }

    private void enable(boolean enable) {
        this.saveWorkspace.setEnabled(enable);
        this.saveWorkspaceAs.setEnabled(enable);
        this.saveAllWorkspaces.setEnabled(enable);
        this.closeWorkspace.setEnabled(enable);
    }

    @UIEventHandler
    public void handleEmptyRoot(WorkspacesPaneEmptyEvent event) {
        this.welcomeItem.setEnabled(true);
    }

    @UIEventHandler
    public void handleNonEmptyRoot(WorkspacesPaneNonEmptyEvent event) {
        this.welcomeItem.setEnabled(false);
    }

    @UIEventHandler
    public void handleSimulationComplete(SimulationCompleteEvent event) {
        if (this.saveWorkspace == null) {
            return;
        }
        this.enable(true);
    }

    @UIEventHandler
    public void handleSimulationStarted(SimulationStartedEvent event) {
        this.enable(false);
    }

    public static ActionListener action(final Object commandInstance) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventBusFactory.getEventBus().publish(commandInstance);
            }
        };
    }
}

