/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.multiple;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.seamcat.calculator.CalculatorInputField;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.model.InterferenceLinkElement;
import org.seamcat.model.Workspace;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.generic.RelativeLocationUI;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.systems.cdma.SystemModelCDMADownLink;
import org.seamcat.model.systems.cdma.SystemModelCDMAUpLink;
import org.seamcat.model.systems.generic.SystemModelGeneric;
import org.seamcat.model.systems.imt2020downlink.ui.SystemModelIMT2020DownLink;
import org.seamcat.model.systems.imt2020downlink.ui.SystemModelIMT2020DownLinkMicro;
import org.seamcat.model.systems.imt2020uplink.ui.SystemModelIMT2020UpLink;
import org.seamcat.model.systems.imt2020uplink.ui.SystemModelIMT2020UpLinkMicro;
import org.seamcat.model.systems.ofdma.SystemModelOFDMADownLink;
import org.seamcat.model.systems.ofdma.SystemModelOFDMAUpLink;
import org.seamcat.model.workspace.CorrelationSettingsUI;
import org.seamcat.model.workspace.InterferenceLinkPathUI;
import org.seamcat.model.workspace.InterferenceLinkUI;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.multiple.MultipleInterferersPreviewPanel;
import org.seamcat.presentation.systems.CellularPosition;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class GenerateMultipleInterferersDialog
extends EscapeDialog {
    private static final Logger LOG = Logger.getLogger(GenerateMultipleInterferersDialog.class);
    private int numberOfGeneratedLinks;
    private static ResourceBundle resources = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private List<InterferenceLinkElement> added;
    private Workspace workspace;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JComponent separator1;
    private JLabel label1;
    private JComboBox interferingLinkSelection;
    private JLabel label2;
    private JPanel panel1;
    private JPanel panel2;
    private JLabel label3;
    private CalculatorInputField positionX;
    private JLabel statusLabel;
    private JLabel label4;
    private CalculatorInputField positionY;
    private JComponent separator3;
    private JRadioButton positionRelativeWT;
    private JRadioButton positionRelativeVR;
    private JComponent separator2;
    private JLabel informationTextLabel;
    private JTabbedPane layoutTabs;
    private JPanel panel3;
    private JLabel label5;
    private JSpinner circularTiers;
    private JLabel label6;
    private JSpinner circularFirstTier;
    private JLabel label7;
    private CalculatorInputField circularRadius;
    private JLabel label8;
    private JLabel label9;
    private CalculatorInputField displacementAngle;
    private JLabel label11;
    private JLabel label10;
    private CalculatorInputField angleOffset;
    private JLabel label12;
    private JPanel panel4;
    private JLabel label14;
    private JPanel panel6;
    private JRadioButton hexagon3GPP_tiers_one;
    private JRadioButton hexagon3GPP_tiers_two;
    private JLabel label15;
    private CalculatorInputField hexagonal3GPPIntersiteDistance;
    private JLabel label16;
    private JLabel label13;
    private MultipleInterferersPreviewPanel multipleInterferersPreviewPanel;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private JButton resetButton;

    public GenerateMultipleInterferersDialog(Frame owner) {
        super(owner);
        this.initComponents();
        this.updateGUI();
        this.registerWindowListeners();
        this.registerHelp();
    }

    private void registerWindowListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.repaint();
            }
        });
    }

    private void registerHelp() {
        KeyStroke stroke = KeyStroke.getKeyStroke(112, 0);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeamcatHelpResolver.showHelp(this);
            }
        }, stroke, 2);
    }

    private void helpButtonActionPerformed() {
        SeamcatHelpResolver.showHelp(this);
    }

    private void interferingLinkSelectionActionPerformed() {
        int index = this.interferingLinkSelection.getSelectedIndex();
        this.setSelectedInterferer(this.workspace.getInterferenceLinkUIs().get(index));
    }

    private void setSelectedInterferer(InterferenceLinkElement link) {
        if (link != null) {
            CorrelationSettingsUI location = link.getSettings().path().correlationSettings();
            this.positionX.setValue(location.deltaX().trial());
            this.positionY.setValue(location.deltaY().trial());
            this.positionX.setEnabled(true);
            this.positionY.setEnabled(true);
            this.updateGUI();
        }
    }

    public void setModel(Workspace workspace) {
        this.workspace = workspace;
        Object victim = workspace.getVictimSystem().getUI();
        List<InterferenceLinkElement> links = workspace.getInterferenceLinkUIs();
        this.added = null;
        this.multipleInterferersPreviewPanel.reset();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (InterferenceLinkElement i : links) {
            model.addElement(i.getName());
        }
        this.interferingLinkSelection.setModel(model);
        this.positionX.setValue(0.0);
        this.positionY.setValue(0.0);
        this.positionX.setEnabled(false);
        this.positionY.setEnabled(false);
        this.interferingLinkSelection.setSelectedItem(model.getElementAt(0));
        if (!(victim instanceof SystemModelGeneric)) {
            if (victim instanceof SystemModelCDMAUpLink || victim instanceof SystemModelOFDMAUpLink) {
                this.multipleInterferersPreviewPanel.setDmaVictim(true, true, this.getInterCellDistance((SystemModel)victim));
            } else if (victim instanceof SystemModelCDMADownLink || victim instanceof SystemModelOFDMADownLink) {
                this.multipleInterferersPreviewPanel.setDmaVictim(true, false, this.getInterCellDistance((SystemModel)victim));
            } else if (victim instanceof SystemModelIMT2020DownLink || victim instanceof SystemModelIMT2020DownLinkMicro) {
                this.multipleInterferersPreviewPanel.setDmaVictim(true, true, this.getInterCellDistance((SystemModel)victim));
            }
        } else {
            SystemModelGeneric genVictim = (SystemModelGeneric)victim;
            if (genVictim.path().relativeLocation().useCorrelatedDistance()) {
                RelativeLocationUI pos = genVictim.path().relativeLocation();
                this.multipleInterferersPreviewPanel.addVictimReceiver("VR", pos.deltaX().trial(), pos.deltaY().trial());
            }
        }
        this.updateGUI();
        this.setVisible(true);
    }

    private double getInterCellDistance(SystemModel systemModel) {
        CellularPosition position = null;
        double interCellDistance = 0.0;
        if (systemModel instanceof SystemModelCDMAUpLink) {
            position = ((SystemModelCDMAUpLink)systemModel).positioning().position();
        } else if (systemModel instanceof SystemModelCDMADownLink) {
            position = ((SystemModelCDMADownLink)systemModel).positioning().position();
        } else if (systemModel instanceof SystemModelOFDMAUpLink) {
            position = ((SystemModelOFDMAUpLink)systemModel).positioning().position();
        } else if (systemModel instanceof SystemModelOFDMADownLink) {
            position = ((SystemModelOFDMADownLink)systemModel).positioning().position();
        }
        if (position != null) {
            interCellDistance = !position.sectorType().equals((Object)HybridSystemPlugin.SectorSetup.TriSector3GPP) ? position.cellRadius() * Math.sqrt(3.0) : position.cellRadius() * 3.0;
        } else {
            double cellRadius = 0.0;
            HybridSystemPlugin.SectorSetup sectorSetup = null;
            if (systemModel instanceof SystemModelIMT2020DownLink) {
                cellRadius = ((SystemModelIMT2020DownLink)systemModel).positioning().position().cellRadius();
                sectorSetup = ((SystemModelIMT2020DownLink)systemModel).positioning().position().sectorType();
                interCellDistance = sectorSetup.equals((Object)HybridSystemPlugin.SectorSetup.TriSector3GPP) ? cellRadius * 3.0 : cellRadius * Math.sqrt(3.0);
            } else if (systemModel instanceof SystemModelIMT2020DownLinkMicro) {
                interCellDistance = ((SystemModelIMT2020DownLinkMicro)systemModel).positioning().microBS().clusterRadius() * 2.0;
            } else if (systemModel instanceof SystemModelIMT2020UpLinkMicro) {
                interCellDistance = ((SystemModelIMT2020UpLinkMicro)systemModel).positioning().microBS().clusterRadius() * 2.0;
            } else if (systemModel instanceof SystemModelIMT2020UpLink) {
                cellRadius = ((SystemModelIMT2020UpLink)systemModel).positioning().position().cellRadius();
                sectorSetup = ((SystemModelIMT2020UpLink)systemModel).positioning().position().sectorType();
                interCellDistance = sectorSetup.equals((Object)HybridSystemPlugin.SectorSetup.TriSector3GPP) ? cellRadius * 3.0 : cellRadius * Math.sqrt(3.0);
            }
        }
        return interCellDistance;
    }

    private void updateGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GenerateMultipleInterferersDialog.this.interferingLinkSelection.getSelectedItem() != null) {
                    GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setPlotGenerated(true);
                } else {
                    GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setPlotGenerated(false);
                }
                if (GenerateMultipleInterferersDialog.this.layoutTabs.getSelectedIndex() == 0) {
                    GenerateMultipleInterferersDialog.this.numberOfGeneratedLinks = GenerateMultipleInterferersDialog.this.calculateNumberOfGeneratedLinksInTier((Integer)GenerateMultipleInterferersDialog.this.circularFirstTier.getValue(), (Integer)GenerateMultipleInterferersDialog.this.circularTiers.getValue());
                    GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setLayoutType(MultipleInterferersPreviewPanel.LayoutType.Circular);
                    GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setIntersiteDistance(GenerateMultipleInterferersDialog.this.circularRadius.getValueAsDouble());
                    GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setNumberOfTiers((Integer)GenerateMultipleInterferersDialog.this.circularTiers.getValue());
                    GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setSizeOfFirstTier((Integer)GenerateMultipleInterferersDialog.this.circularFirstTier.getValue());
                    GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setDisplacementAngle(GenerateMultipleInterferersDialog.this.displacementAngle.getValueAsDouble());
                    GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setOffsetAngle(GenerateMultipleInterferersDialog.this.angleOffset.getValueAsDouble());
                } else if (GenerateMultipleInterferersDialog.this.layoutTabs.getSelectedIndex() == 1) {
                    GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setLayoutType(MultipleInterferersPreviewPanel.LayoutType.Hexagon3GPP);
                    GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setIntersiteDistance(GenerateMultipleInterferersDialog.this.hexagonal3GPPIntersiteDistance.getValueAsDouble());
                    if (GenerateMultipleInterferersDialog.this.hexagon3GPP_tiers_one.isSelected()) {
                        GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setNumberOfTiers(1);
                        GenerateMultipleInterferersDialog.this.numberOfGeneratedLinks = 6;
                    } else {
                        GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setNumberOfTiers(2);
                        GenerateMultipleInterferersDialog.this.numberOfGeneratedLinks = 18;
                    }
                }
                GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setCenterX(GenerateMultipleInterferersDialog.this.positionX.getValueAsDouble());
                GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setCenterY(GenerateMultipleInterferersDialog.this.positionY.getValueAsDouble());
                GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.repaint();
                GenerateMultipleInterferersDialog.this.statusLabel.setText("The current configuration will generate " + GenerateMultipleInterferersDialog.this.numberOfGeneratedLinks + " new Interfering Links");
            }
        });
    }

    private void genericInputFieldActionPerformed() {
        this.updateGUI();
    }

    private void cancelButtonActionPerformed() {
        this.multipleInterferersPreviewPanel.setPlotGenerated(false);
        this.setVisible(false);
    }

    public List<InterferenceLinkElement> getAdded() {
        return this.added;
    }

    private void okButtonActionPerformed() {
        this.added = new ArrayList<InterferenceLinkElement>();
        this.generateLinks();
    }

    private void generateLinks() {
        try {
            InterferenceLinkElement[] links = null;
            int index = this.interferingLinkSelection.getSelectedIndex();
            InterferenceLinkElement orig = this.workspace.getInterferenceLinkUIs().get(index);
            Object interferingSystem = this.workspace.getSystemPlugin(orig.getInterferingSystemId()).getUI();
            if (!(interferingSystem instanceof SystemModelGeneric) || this.workspace.getVictimSystem() instanceof SystemModelGeneric) {
                // empty if block
            }
            this.setXY(orig, this.positionX.getValueAsDouble(), this.positionY.getValueAsDouble());
            if (this.layoutTabs.getSelectedIndex() == 0) {
                this.numberOfGeneratedLinks = this.calculateNumberOfGeneratedLinksInTier((Integer)this.circularFirstTier.getValue(), (Integer)this.circularTiers.getValue());
                double radius = this.circularRadius.getValueAsDouble();
                double offset = this.angleOffset.getValueAsDouble();
                double displacement = this.displacementAngle.getValueAsDouble();
                int sizeOfFirst = (Integer)this.circularFirstTier.getValue();
                int numberOfTiers = (Integer)this.circularTiers.getValue();
                links = new InterferenceLinkElement[this.numberOfGeneratedLinks];
                this.generateCircularLayout(links, orig, 1, numberOfTiers, displacement, offset, sizeOfFirst, radius);
            } else if (this.layoutTabs.getSelectedIndex() == 1) {
                double d = this.hexagonal3GPPIntersiteDistance.getValueAsDouble();
                this.numberOfGeneratedLinks = this.hexagon3GPP_tiers_one.isSelected() ? 6 : 18;
                links = new InterferenceLinkElement[this.numberOfGeneratedLinks];
                this.generate3GPPLayout(links, orig, d);
            }
            if (links != null) {
                Collections.addAll(this.added, links);
                links = null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenerateMultipleInterferersDialog.this.multipleInterferersPreviewPanel.setPlotGenerated(false);
                    GenerateMultipleInterferersDialog.this.setVisible(false);
                    GenerateMultipleInterferersDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
        }
        catch (Exception e) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(this, resources.getString("MULTI_GENERATION_ERROR_MESSAGE"), "Error Generating Links", 0);
            LOG.error("Error generating multiple interfering links", e);
        }
    }

    private void setRelativeLocation(InterferenceLinkElement orig, CorrelationSettingsUI rel) {
        InterferenceLinkUI ilProto = Factory.prototype(InterferenceLinkUI.class);
        InterferenceLinkPathUI prototype = Factory.prototype(InterferenceLinkPathUI.class);
        Factory.when(prototype.correlationSettings()).thenReturn(rel);
        Factory.when(prototype.propagationModel()).thenReturn(orig.getSettings().path().propagationModel());
        Factory.when(ilProto.path()).thenReturn(Factory.build(prototype));
        orig.setSettings(Factory.build(ilProto));
    }

    private void setMode(InterferenceLinkElement orig, CorrelationMode mode) {
        CorrelationSettingsUI prototype = Factory.prototype(CorrelationSettingsUI.class, orig.getSettings().path().correlationSettings());
        Factory.when(prototype.mode()).thenReturn(mode);
        this.setRelativeLocation(orig, Factory.build(prototype));
    }

    private void generate3GPPLayout(InterferenceLinkElement[] links, InterferenceLinkElement orig, double D) {
        int id;
        double x = this.positionX.getValueAsDouble();
        double y = this.positionY.getValueAsDouble();
        links[id = 0] = this.generateInteferenceLink(orig, x + 1.5 * D / Math.sqrt(3.0), y + D / 2.0, id++);
        links[id] = this.generateInteferenceLink(orig, x, y + D, id++);
        links[id] = this.generateInteferenceLink(orig, x - 1.5 * D / Math.sqrt(3.0), y + D / 2.0, id++);
        links[id] = this.generateInteferenceLink(orig, x - 1.5 * D / Math.sqrt(3.0), y - D / 2.0, id++);
        links[id] = this.generateInteferenceLink(orig, x, y - D, id++);
        links[id] = this.generateInteferenceLink(orig, x + 1.5 * D / Math.sqrt(3.0), y - D / 2.0, id++);
        if (links.length > 6) {
            links[id] = this.generateInteferenceLink(orig, x + 3.0 * D / Math.sqrt(3.0), y, id++);
            links[id] = this.generateInteferenceLink(orig, x + 3.0 * D / Math.sqrt(3.0), y + D, id++);
            links[id] = this.generateInteferenceLink(orig, x + 1.5 * D / Math.sqrt(3.0), y + 1.5 * D, id++);
            links[id] = this.generateInteferenceLink(orig, x, y + 2.0 * D, id++);
            links[id] = this.generateInteferenceLink(orig, x - 1.5 * D / Math.sqrt(3.0), y + 1.5 * D, id++);
            links[id] = this.generateInteferenceLink(orig, x - 3.0 * D / Math.sqrt(3.0), y + D, id++);
            links[id] = this.generateInteferenceLink(orig, x - 3.0 * D / Math.sqrt(3.0), y, id++);
            links[id] = this.generateInteferenceLink(orig, x - 3.0 * D / Math.sqrt(3.0), y - D, id++);
            links[id] = this.generateInteferenceLink(orig, x - 1.5 * D / Math.sqrt(3.0), y - 1.5 * D, id++);
            links[id] = this.generateInteferenceLink(orig, x, y - 2.0 * D, id++);
            links[id] = this.generateInteferenceLink(orig, x + 1.5 * D / Math.sqrt(3.0), y - 1.5 * D, id++);
            links[id] = this.generateInteferenceLink(orig, x + 3.0 * D / Math.sqrt(3.0), y - D, id++);
        }
    }

    private InterferenceLinkElement generateInteferenceLink(InterferenceLinkElement orig, double x, double y, int id) {
        InterferenceLinkUI settings = ProxyHelper.deepCloneComposite(InterferenceLinkUI.class, orig.getSettings());
        InterferenceLinkElement clone = new InterferenceLinkElement(orig.getInterferingSystemId(), "", settings);
        this.setXY(clone, x, y);
        return clone;
    }

    private void setXY(InterferenceLinkElement link, double x, double y) {
        CorrelationSettingsUI prototype = Factory.prototype(CorrelationSettingsUI.class, link.getSettings().path().correlationSettings());
        Factory.when(prototype.deltaX()).thenReturn(Factory.distributionFactory().getConstantDistribution(x));
        Factory.when(prototype.deltaY()).thenReturn(Factory.distributionFactory().getConstantDistribution(y));
        this.setRelativeLocation(link, Factory.build(prototype));
    }

    private void generateCircularLayout(InterferenceLinkElement[] links, InterferenceLinkElement orig, int tierid, int numberOfTiers, double displacementAngle, double offsetAngle, int numberOfSitesInFirstTier, double radius) {
        if (tierid > numberOfTiers) {
            return;
        }
        double angleFromCenter = displacementAngle / (double)tierid;
        int numberOfSitesInThisTier = tierid * numberOfSitesInFirstTier;
        int cellsInnerRows = this.calculateNumberOfGeneratedLinksInTier(numberOfSitesInFirstTier, tierid - 1);
        for (int i = 0; i < numberOfSitesInThisTier; ++i) {
            int cellid = cellsInnerRows + i;
            double angle = (double)i * angleFromCenter + offsetAngle;
            Point2D point = new Point2D(Mathematics.cosD(angle), Mathematics.sinD(angle)).scale(radius * (double)tierid).add(this.relativeLocation(orig));
            if (links[cellid] != null) continue;
            links[cellid] = this.generateInteferenceLink(orig, point.getX(), point.getY(), cellid);
        }
        this.generateCircularLayout(links, orig, tierid + 1, numberOfTiers, displacementAngle, offsetAngle, numberOfSitesInFirstTier, radius);
    }

    private Point2D relativeLocation(InterferenceLinkElement element) {
        CorrelationSettingsUI ui = element.getSettings().path().correlationSettings();
        return new Point2D(ui.deltaX().trial(), ui.deltaY().trial());
    }

    private void circularFirstTierStateChanged() {
        int sizeOfFirst = (Integer)this.circularFirstTier.getValue();
        this.displacementAngle.setValue(Mathematics.round(360.0 / (double)sizeOfFirst));
        this.angleOffset.setValue(Mathematics.round(this.displacementAngle.getValueAsDouble() / 2.0));
        this.updateGUI();
    }

    private int calculateNumberOfGeneratedLinksInTier(int numberOfSitesInFirstTier, int tier) {
        if (tier == 0) {
            return 0;
        }
        return numberOfSitesInFirstTier * tier + this.calculateNumberOfGeneratedLinksInTier(numberOfSitesInFirstTier, tier - 1);
    }

    private void positionRelativeWTActionPerformed() {
        this.multipleInterferersPreviewPanel.setGenerateRelativeToVictim(this.positionRelativeVR.isSelected());
    }

    private void positionRelativeVRActionPerformed() {
        this.multipleInterferersPreviewPanel.setGenerateRelativeToVictim(this.positionRelativeVR.isSelected());
    }

    private void resetButtonActionPerformed(ActionEvent e) {
        this.circularTiers.setValue(1);
        this.circularFirstTier.setValue(6);
        this.circularRadius.setValue(0.433);
        this.displacementAngle.setValue(60.0);
        this.angleOffset.setValue(30.0);
        this.hexagon3GPP_tiers_two.setSelected(true);
        this.hexagonal3GPPIntersiteDistance.setValue(0.433);
        this.updateGUI();
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("org.seamcat.presentation.localization");
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.separator1 = compFactory.createSeparator(bundle.getString("GenerateMultipleInterferersDialog.separator1.text"));
        this.label1 = new JLabel();
        this.interferingLinkSelection = new JComboBox();
        this.label2 = new JLabel();
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.label3 = new JLabel();
        this.positionX = new CalculatorInputField();
        this.statusLabel = new JLabel();
        this.label4 = new JLabel();
        this.positionY = new CalculatorInputField();
        this.separator3 = compFactory.createSeparator(bundle.getString("GenerateMultipleInterferersDialog.separator3.text"));
        this.positionRelativeWT = new JRadioButton();
        this.positionRelativeVR = new JRadioButton();
        this.separator2 = compFactory.createSeparator(bundle.getString("GenerateMultipleInterferersDialog.separator2.text"));
        this.informationTextLabel = new JLabel();
        this.layoutTabs = new JTabbedPane();
        this.panel3 = new JPanel();
        this.label5 = new JLabel();
        this.circularTiers = new JSpinner();
        this.label6 = new JLabel();
        this.circularFirstTier = new JSpinner();
        this.label7 = new JLabel();
        this.circularRadius = new CalculatorInputField();
        this.label8 = new JLabel();
        this.label9 = new JLabel();
        this.displacementAngle = new CalculatorInputField();
        this.label11 = new JLabel();
        this.label10 = new JLabel();
        this.angleOffset = new CalculatorInputField();
        this.label12 = new JLabel();
        this.panel4 = new JPanel();
        this.label14 = new JLabel();
        this.panel6 = new JPanel();
        this.hexagon3GPP_tiers_one = new JRadioButton();
        this.hexagon3GPP_tiers_two = new JRadioButton();
        this.label15 = new JLabel();
        this.hexagonal3GPPIntersiteDistance = new CalculatorInputField();
        this.label16 = new JLabel();
        this.label13 = new JLabel();
        this.multipleInterferersPreviewPanel = new MultipleInterferersPreviewPanel();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.resetButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setModal(true);
        this.setTitle(bundle.getString("GenerateMultipleInterferersDialog.this.title"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(Borders.DIALOG_BORDER);
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setBorder(new TitledBorder(bundle.getString("GenerateMultipleInterferersDialog.contentPanel.border")));
        this.contentPanel.setLayout(new FormLayout("default, $lcgap, 110dlu, $lcgap, default, $lcgap, default:grow", "4*(default, $lgap), [23dlu,pref], $lgap, default, $lgap, default:grow, $lgap, default"));
        this.contentPanel.add((Component)this.separator1, cc.xywh(1, 1, 7, 1));
        this.label1.setText(bundle.getString("GenerateMultipleInterferersDialog.label1.text"));
        this.label1.setLabelFor(this.interferingLinkSelection);
        this.contentPanel.add((Component)this.label1, cc.xy(1, 3));
        this.interferingLinkSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.interferingLinkSelectionActionPerformed();
            }
        });
        this.contentPanel.add((Component)this.interferingLinkSelection, cc.xywh(3, 3, 5, 1));
        this.label2.setText(bundle.getString("GenerateMultipleInterferersDialog.label2.text"));
        this.label2.setVerticalAlignment(1);
        this.contentPanel.add((Component)this.label2, cc.xywh(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.panel1.setLayout(new FormLayout("default:grow", "default"));
        this.panel2.setLayout(new FormLayout("default, right:default, default:grow", "4*(default, $lgap), default"));
        this.label3.setText(bundle.getString("GenerateMultipleInterferersDialog.label3.text"));
        this.label3.setLabelFor(this.positionX);
        this.panel2.add((Component)this.label3, cc.xy(1, 1));
        this.positionX.setFocusLostBehavior(0);
        this.positionX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.positionX.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.panel2.add((Component)this.positionX, cc.xy(2, 1));
        this.panel2.add((Component)this.statusLabel, cc.xywh(3, 1, 1, 3, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.label4.setText(bundle.getString("GenerateMultipleInterferersDialog.label4.text"));
        this.label4.setLabelFor(this.positionY);
        this.panel2.add((Component)this.label4, cc.xy(1, 3));
        this.positionY.setFocusLostBehavior(0);
        this.positionY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.positionY.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.panel2.add((Component)this.positionY, cc.xy(2, 3));
        this.panel2.add((Component)this.separator3, cc.xywh(1, 5, 3, 1));
        this.positionRelativeWT.setText(bundle.getString("GenerateMultipleInterferersDialog.positionRelativeWT.text"));
        this.positionRelativeWT.setSelected(true);
        this.positionRelativeWT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.positionRelativeWTActionPerformed();
            }
        });
        this.panel2.add((Component)this.positionRelativeWT, cc.xywh(2, 7, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.positionRelativeVR.setText(bundle.getString("GenerateMultipleInterferersDialog.positionRelativeVR.text"));
        this.positionRelativeVR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.positionRelativeVRActionPerformed();
            }
        });
        this.panel2.add((Component)this.positionRelativeVR, cc.xywh(2, 9, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.panel1.add((Component)this.panel2, cc.xy(1, 1));
        this.contentPanel.add((Component)this.panel1, cc.xywh(3, 5, 5, 1));
        this.contentPanel.add((Component)this.separator2, cc.xywh(1, 7, 7, 1));
        this.informationTextLabel.setText(bundle.getString("GenerateMultipleInterferersDialog.informationTextLabel.text"));
        this.contentPanel.add((Component)this.informationTextLabel, cc.xywh(1, 9, 7, 1, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.layoutTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.panel3.setLayout(new FormLayout("default:grow, 2*($lcgap, default)", "6*(default, $lgap), default"));
        this.label5.setText(bundle.getString("GenerateMultipleInterferersDialog.label5.text"));
        this.panel3.add((Component)this.label5, cc.xy(1, 1));
        this.circularTiers.setModel(new SpinnerNumberModel(1, 1, 10, 1));
        this.circularTiers.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.circularTiers.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.panel3.add((Component)this.circularTiers, cc.xy(3, 1));
        this.label6.setText(bundle.getString("GenerateMultipleInterferersDialog.label6.text"));
        this.panel3.add((Component)this.label6, cc.xy(1, 3));
        this.circularFirstTier.setModel(new SpinnerNumberModel(6, 1, 100, 1));
        this.circularFirstTier.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
                GenerateMultipleInterferersDialog.this.circularFirstTierStateChanged();
            }
        });
        this.circularFirstTier.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.panel3.add((Component)this.circularFirstTier, cc.xy(3, 3));
        this.label7.setText(bundle.getString("GenerateMultipleInterferersDialog.label7.text"));
        this.panel3.add((Component)this.label7, cc.xy(1, 5));
        this.circularRadius.setText(bundle.getString("GenerateMultipleInterferersDialog.circularRadius.text"));
        this.circularRadius.setAllowNegatives(false);
        this.circularRadius.setFocusLostBehavior(0);
        this.circularRadius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.circularRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.panel3.add((Component)this.circularRadius, cc.xy(3, 5));
        this.label8.setText(bundle.getString("GenerateMultipleInterferersDialog.label8.text"));
        this.panel3.add((Component)this.label8, cc.xy(5, 5));
        this.label9.setText(bundle.getString("GenerateMultipleInterferersDialog.label9.text"));
        this.panel3.add((Component)this.label9, cc.xy(1, 7));
        this.displacementAngle.setText(bundle.getString("GenerateMultipleInterferersDialog.displacementAngle.text"));
        this.displacementAngle.setToolTipText(bundle.getString("GenerateMultipleInterferersDialog.displacementAngle.toolTipText"));
        this.displacementAngle.setFocusLostBehavior(0);
        this.displacementAngle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.displacementAngle.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.panel3.add((Component)this.displacementAngle, cc.xy(3, 7));
        this.label11.setText(bundle.getString("GenerateMultipleInterferersDialog.label11.text"));
        this.panel3.add((Component)this.label11, cc.xy(5, 7));
        this.label10.setText(bundle.getString("GenerateMultipleInterferersDialog.label10.text"));
        this.panel3.add((Component)this.label10, cc.xy(1, 9));
        this.angleOffset.setText(bundle.getString("GenerateMultipleInterferersDialog.angleOffset.text"));
        this.angleOffset.setToolTipText(bundle.getString("GenerateMultipleInterferersDialog.angleOffset.toolTipText"));
        this.angleOffset.setFocusLostBehavior(0);
        this.angleOffset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.angleOffset.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.panel3.add((Component)this.angleOffset, cc.xy(3, 9));
        this.label12.setText(bundle.getString("GenerateMultipleInterferersDialog.label12.text"));
        this.panel3.add((Component)this.label12, cc.xy(5, 9));
        this.layoutTabs.addTab(bundle.getString("GenerateMultipleInterferersDialog.panel3.tab.title"), this.panel3);
        this.panel4.setLayout(new FormLayout("default, $lcgap, right:89dlu, $lcgap, default", "3*(default, $lgap), default"));
        this.label14.setText(bundle.getString("GenerateMultipleInterferersDialog.label14.text"));
        this.panel4.add((Component)this.label14, cc.xy(1, 1));
        this.panel6.setLayout(new FormLayout("default:grow", "default, $lgap, default"));
        this.hexagon3GPP_tiers_one.setText(bundle.getString("GenerateMultipleInterferersDialog.hexagon3GPP_tiers_one.text"));
        this.hexagon3GPP_tiers_one.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.panel6.add((Component)this.hexagon3GPP_tiers_one, cc.xy(1, 1));
        this.hexagon3GPP_tiers_two.setText(bundle.getString("GenerateMultipleInterferersDialog.hexagon3GPP_tiers_two.text"));
        this.hexagon3GPP_tiers_two.setSelected(true);
        this.hexagon3GPP_tiers_two.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.panel6.add((Component)this.hexagon3GPP_tiers_two, cc.xy(1, 3));
        this.panel4.add((Component)this.panel6, cc.xywh(3, 1, 3, 1));
        this.label15.setText(bundle.getString("GenerateMultipleInterferersDialog.label15.text"));
        this.panel4.add((Component)this.label15, cc.xy(1, 3));
        this.hexagonal3GPPIntersiteDistance.setText(bundle.getString("GenerateMultipleInterferersDialog.hexagonal3GPPIntersiteDistance.text"));
        this.hexagonal3GPPIntersiteDistance.setAllowNegatives(false);
        this.hexagonal3GPPIntersiteDistance.setFocusLostBehavior(3);
        this.hexagonal3GPPIntersiteDistance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.hexagonal3GPPIntersiteDistance.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GenerateMultipleInterferersDialog.this.genericInputFieldActionPerformed();
            }
        });
        this.panel4.add((Component)this.hexagonal3GPPIntersiteDistance, cc.xy(3, 3));
        this.label16.setText(bundle.getString("GenerateMultipleInterferersDialog.label16.text"));
        this.panel4.add((Component)this.label16, cc.xy(5, 3));
        this.layoutTabs.addTab(bundle.getString("GenerateMultipleInterferersDialog.panel4.tab.title"), this.panel4);
        this.contentPanel.add((Component)this.layoutTabs, cc.xywh(1, 11, 4, 4));
        this.label13.setText(bundle.getString("GenerateMultipleInterferersDialog.label13.text"));
        this.label13.setFont(new Font("Dialog", 0, 18));
        this.contentPanel.add((Component)this.label13, cc.xywh(7, 11, 1, 1, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.contentPanel.add((Component)this.multipleInterferersPreviewPanel, cc.xywh(7, 13, 1, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.buttonBar.setLayout(new FormLayout("$lcgap, default, $glue, 2*($button, $rgap), $button, $lcgap, default", "pref"));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.okButtonActionPerformed();
            }
        });
        this.buttonBar.add((Component)this.okButton, cc.xy(4, 1));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.cancelButtonActionPerformed();
            }
        });
        this.buttonBar.add((Component)this.cancelButton, cc.xy(6, 1));
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.helpButtonActionPerformed();
            }
        });
        this.buttonBar.add((Component)this.helpButton, cc.xy(8, 1));
        this.resetButton.setText(bundle.getString("GenerateMultipleInterferersDialog.resetButton"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateMultipleInterferersDialog.this.resetButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.resetButton, cc.xy(10, 1));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(1000, 700);
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.positionRelativeWT);
        buttonGroup2.add(this.positionRelativeVR);
        ButtonGroup hexagonal3GPPNumberOfTiers = new ButtonGroup();
        hexagonal3GPPNumberOfTiers.add(this.hexagon3GPP_tiers_one);
        hexagonal3GPPNumberOfTiers.add(this.hexagon3GPP_tiers_two);
    }

    public int getSelectedIndex() {
        return this.interferingLinkSelection.getSelectedIndex();
    }
}

