/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.multiple;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;

public class MultipleInterferersPreviewPanel
extends JPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private static final Logger LOG = Logger.getLogger(MultipleInterferersPreviewPanel.class);
    private LayoutType layoutType;
    private double intersiteDistance;
    private int numberOfTiers;
    private double displacementAngle;
    private double offsetAngle;
    private int sizeOfFirstTier;
    private double centerX;
    private double centerY;
    private int width;
    private int height;
    private double scaleFactor;
    private double translateX;
    private double translateY;
    private boolean plottingGenerated;
    private Map<String, Point2D> victimReceivers = new HashMap<String, Point2D>();
    private Map<String, Point2D> interferingTransmitters = new HashMap<String, Point2D>();
    private int selectedItemZoomFactor = 0;
    private boolean victimIsDma;
    private double victimInterSiteDistance;
    private boolean victimIsUplink;
    private boolean generateRelativeToVictim = false;
    private Point2D vrCenter;
    private static final Color GREY = new Color(10, 10, 10, 25);
    private static final long serialVersionUID = 1L;
    private final Image it = this.getImage("/org/seamcat/presentation/resources/it.png");
    private final Image wt = this.getImage("/org/seamcat/presentation/resources/wt.png");
    private final Image vr = this.getImage("/org/seamcat/presentation/resources/vr.png");
    private boolean forcePaint = false;
    private static final int MAX_POINTS_GRID_X = 250;
    private static final int MAX_POINTS_GRID_Y = 100;

    private Image getImage(String file) {
        byte[] bytes = null;
        try {
            InputStream iStream = this.getClass().getResourceAsStream(file);
            bytes = new byte[iStream.available()];
            iStream.read(bytes);
            iStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ImageIcon(bytes).getImage();
    }

    @Override
    public void repaint() {
        this.forcePaint = true;
        super.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.forcePaint) {
            this.forcePaint = false;
            super.paintComponent(g);
            Graphics2D gr = (Graphics2D)g;
            gr.setBackground(Color.WHITE);
            this.prepare(gr);
            this.drawCoordinateSystem(gr);
            this.drawLegend(gr);
            this.drawExistingElements(gr);
            if (this.isPlottingGenerated()) {
                this.drawGeneratedElements(gr);
            }
        }
    }

    private void drawGeneratedElements(Graphics2D gr) {
        gr.setColor(Color.RED);
        if (this.layoutType == LayoutType.Circular) {
            this.drawCircularElements(gr);
        } else if (this.layoutType == LayoutType.Hexagon3GPP) {
            double x = this.getCenterX();
            double y = -this.getCenterY();
            double D = this.getIntersiteDistance();
            if (this.generateRelativeToVictim && this.vrCenter != null) {
                x = this.vrCenter.getX() + this.getCenterX();
                y = -this.vrCenter.getY() - this.getCenterY();
            }
            this.draw3GPPLayoutElements(gr, x, y, D, true);
        }
    }

    private void draw3GPPLayoutElements(Graphics2D gr, double x, double y, double D, boolean animate) {
        this.drawImage(gr, this.it, x + 1.5 * D / Math.sqrt(3.0), y + D / 2.0);
        this.drawImage(gr, this.it, x, y + D);
        this.drawImage(gr, this.it, x - 1.5 * D / Math.sqrt(3.0), y + D / 2.0);
        this.drawImage(gr, this.it, x - 1.5 * D / Math.sqrt(3.0), y - D / 2.0);
        this.drawImage(gr, this.it, x, y - D);
        this.drawImage(gr, this.it, x + 1.5 * D / Math.sqrt(3.0), y - D / 2.0);
        if (this.getNumberOfTiers() > 1) {
            this.drawImage(gr, this.it, x + 3.0 * D / Math.sqrt(3.0), y);
            this.drawImage(gr, this.it, x + 3.0 * D / Math.sqrt(3.0), y + D);
            this.drawImage(gr, this.it, x + 1.5 * D / Math.sqrt(3.0), y + 1.5 * D);
            this.drawImage(gr, this.it, x, y + 2.0 * D);
            this.drawImage(gr, this.it, x - 1.5 * D / Math.sqrt(3.0), y + 1.5 * D);
            this.drawImage(gr, this.it, x - 3.0 * D / Math.sqrt(3.0), y + D);
            this.drawImage(gr, this.it, x - 3.0 * D / Math.sqrt(3.0), y);
            this.drawImage(gr, this.it, x - 3.0 * D / Math.sqrt(3.0), y - D);
            this.drawImage(gr, this.it, x - 1.5 * D / Math.sqrt(3.0), y - 1.5 * D);
            this.drawImage(gr, this.it, x, y - 2.0 * D);
            this.drawImage(gr, this.it, x + 1.5 * D / Math.sqrt(3.0), y - 1.5 * D);
            this.drawImage(gr, this.it, x + 3.0 * D / Math.sqrt(3.0), y - D);
        }
    }

    private void drawCircularElements(Graphics2D gr) {
        this.drawRecursiveTiers(gr, 1);
    }

    private void drawRecursiveTiers(Graphics2D gr, int tierid) {
        if (tierid > this.getNumberOfTiers()) {
            return;
        }
        double angleFromCenter = this.getDisplacementAngle() / (double)tierid;
        int numberOfSitesInThisTier = tierid * this.getSizeOfFirstTier();
        double drawCenterX = this.getCenterX();
        double drawCenterY = -this.getCenterY();
        if (this.generateRelativeToVictim && this.vrCenter != null) {
            drawCenterX = this.vrCenter.getX() + this.getCenterX();
            drawCenterY = -this.vrCenter.getY() - this.getCenterY();
        }
        for (int i = 0; i < numberOfSitesInThisTier; ++i) {
            double x = drawCenterX + Mathematics.cosD((double)i * angleFromCenter + this.getOffsetAngle()) * this.getIntersiteDistance() * (double)tierid;
            double y = drawCenterY - Mathematics.sinD((double)i * angleFromCenter + this.getOffsetAngle()) * this.getIntersiteDistance() * (double)tierid;
            this.drawImage(gr, this.it, x, y);
        }
        this.drawRecursiveTiers(gr, tierid + 1);
    }

    private void drawExistingElements(Graphics2D gr) {
        gr.setColor(Color.BLUE);
        if (this.victimIsDma) {
            if (!this.victimIsUplink) {
                gr.setColor(Color.GREEN);
            }
            this.draw3GPPLayoutElements(gr, 0.0, 0.0, this.victimInterSiteDistance, false);
        } else {
            this.drawImage(gr, this.wt, this.translateX, this.translateY, false, true);
            if (!this.victimReceivers.isEmpty()) {
                gr.setColor(Color.GREEN);
                for (String name : this.victimReceivers.keySet()) {
                    Point2D point = this.victimReceivers.get(name);
                    double x = point.getX() * this.scaleFactor;
                    double y = -point.getY() * this.scaleFactor;
                    this.drawImage(gr, this.vr, x += this.translateX, y += this.translateY, false, true);
                }
            }
        }
        gr.setColor(Color.RED);
        double drawCenterX = this.getCenterX();
        double drawCenterY = -this.getCenterY();
        if (this.generateRelativeToVictim && this.vrCenter != null) {
            drawCenterX = this.vrCenter.getX() + this.getCenterX();
            drawCenterY = -this.vrCenter.getY() - this.getCenterY();
        }
        double x = drawCenterX * this.scaleFactor;
        double y = drawCenterY * this.scaleFactor;
        this.drawImage(gr, this.it, x += this.translateX, y += this.translateY, false, true);
    }

    private void drawLegend(Graphics2D gr) {
        gr.setColor(Color.BLACK);
        double unitLen = this.scaleFactor * this.getIntersiteDistance();
        int unitXPos = (int)((double)(this.width / 2) - (double)(this.width / 2) / unitLen * unitLen);
        gr.drawLine(unitXPos, this.height / 20, unitXPos + (int)unitLen, this.height / 20);
        gr.drawLine(unitXPos + (int)unitLen, this.height / 20 - 5, unitXPos + (int)unitLen, this.height / 20 + 5);
        gr.drawLine(unitXPos, this.height / 20 - 5, unitXPos, this.height / 20 + 5);
        gr.drawString("D = " + Mathematics.round(this.getIntersiteDistance()) + " km", unitXPos + 30, this.height / 20 + 20);
        int legendYText = this.height - 25;
        int legendYImage = legendYText - 8;
        int legendSpace = 5;
        int legendX = 25;
        FontMetrics metrics = gr.getFontMetrics();
        String itLabel = STRINGLIST.getString("MULTIPLE_LABEL_ILT");
        String wtLabel = STRINGLIST.getString("MULTIPLE_LABEL_VLT");
        String vrLabel = STRINGLIST.getString("MULTIPLE_LABEL_VLR");
        gr.drawString(STRINGLIST.getString("MULTIPLE_LABEL_ILT"), legendX, legendYText);
        this.drawImage(gr, this.it, legendX += metrics.stringWidth(itLabel) + 5, legendYImage, false, false);
        gr.drawString(STRINGLIST.getString("MULTIPLE_LABEL_VLT"), legendX += this.it.getWidth(null) + 10, legendYText);
        this.drawImage(gr, this.wt, legendX += metrics.stringWidth(wtLabel) + 5, legendYImage, false, false);
        gr.drawString(STRINGLIST.getString("MULTIPLE_LABEL_VLR"), legendX += this.wt.getWidth(null) + 10, legendYText);
        this.drawImage(gr, this.vr, legendX += metrics.stringWidth(vrLabel) + 5, legendYImage, false, false);
    }

    private void drawCoordinateSystem(Graphics2D gr) {
        gr.setColor(Color.BLACK);
        int xCenter = this.width / 2;
        int yCenter = this.height / 2;
        gr.drawLine(xCenter, 0, xCenter, this.height);
        gr.drawLine(0, yCenter, this.width, yCenter);
        int gridPixels = 3;
        int gridLen = 2;
        boolean gridSpace = true;
        double displacePixels = this.scaleFactor * this.getIntersiteDistance();
        int yNegative = yCenter - 3;
        int yPositive = yCenter + 3;
        double xFactor = -1.0;
        if ((double)xCenter / displacePixels > 250.0) {
            xFactor = (double)xCenter / displacePixels / 250.0;
        }
        int skippedX = 0;
        double nextXdisplace = displacePixels;
        for (double xDisplace = displacePixels; xDisplace < (double)xCenter; xDisplace += displacePixels) {
            if (xFactor != -1.0) {
                if (xDisplace < nextXdisplace) {
                    ++skippedX;
                    continue;
                }
                nextXdisplace = xDisplace + xFactor * displacePixels;
            }
            int xNegative = (int)((double)xCenter - xDisplace);
            int xPositive = (int)((double)xCenter + xDisplace);
            gr.setColor(GREY);
            int z = 4;
            for (int y = 0; y < this.height; y += z) {
                int yLen = y + 2;
                gr.drawLine(xNegative, y, xNegative, yLen);
                gr.drawLine(xPositive, y, xPositive, yLen);
            }
            gr.setColor(Color.BLACK);
            gr.drawLine(xNegative, yNegative, xNegative, yPositive);
            gr.drawLine(xPositive, yNegative, xPositive, yPositive);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Skipped %d X points", skippedX));
        }
        int xNegative = xCenter - 3;
        int xPositive = xCenter + 3;
        double yFactor = -1.0;
        if ((double)yCenter / displacePixels > 100.0) {
            yFactor = (double)yCenter / displacePixels / 100.0;
        }
        int skippedY = 0;
        double nextYdisplace = displacePixels;
        for (double yDisplace = displacePixels; yDisplace < (double)yCenter; yDisplace += displacePixels) {
            if (yFactor != -1.0) {
                if (yDisplace < nextYdisplace) {
                    ++skippedY;
                    continue;
                }
                nextYdisplace = yDisplace + yFactor * displacePixels;
            }
            yNegative = (int)((double)yCenter - yDisplace);
            yPositive = (int)((double)yCenter + yDisplace);
            gr.setColor(GREY);
            int z = 4;
            for (int x = 0; x < this.width; x += z) {
                int xLen = x + 2;
                gr.drawLine(x, yNegative, xLen, yNegative);
                gr.drawLine(x, yPositive, xLen, yPositive);
            }
            gr.setColor(Color.BLACK);
            gr.drawLine(xNegative, yNegative, xPositive, yNegative);
            gr.drawLine(xNegative, yPositive, xPositive, yPositive);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Skipped %d Y points", skippedY));
        }
    }

    private void prepare(Graphics2D gr) {
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dim = this.getSize();
        this.height = (int)dim.getHeight();
        this.width = (int)dim.getWidth();
        double distance = Math.sqrt(this.centerX * this.centerX + this.centerY * this.centerY);
        double vrDist = 0.0;
        for (Point2D p : this.victimReceivers.values()) {
            vrDist = Math.max(Mathematics.distance(new Point2D(0.0, 0.0), new Point2D(p.getX(), p.getY())), vrDist);
        }
        double d = Math.max(1.5 * (double)(this.getNumberOfTiers() + 2) * this.getIntersiteDistance(), 2.0 * vrDist);
        double scaleFactorH = (double)this.height / (d + 2.0 * distance);
        double scaleFactorW = (double)this.width / (d + 2.0 * distance);
        this.scaleFactor = Math.min(scaleFactorH, scaleFactorW);
        this.translateX = this.width / 2;
        this.translateY = this.height / 2;
        gr.clearRect(0, 0, this.width, this.height);
    }

    private void drawImage(Graphics2D gr, Image i, double x, double y) {
        this.drawImage(gr, i, x, y, true, true);
    }

    private void drawImage(Graphics2D gr, Image i, double x, double y, boolean scaleTranslate, boolean center) {
        if (scaleTranslate) {
            x *= this.scaleFactor;
            y *= this.scaleFactor;
            x += this.translateX;
            y += this.translateY;
        }
        if (center) {
            x -= (double)(i.getWidth(null) / 2);
            y -= (double)(i.getHeight(null) / 2);
        }
        gr.drawImage(i, (int)x, (int)y, null);
    }

    public void addVictimReceiver(String name, double x, double y) {
        this.victimReceivers.put(name, new Point2D(x, y));
        this.vrCenter = new Point2D(x, y);
    }

    public void addInterferingTransmitter(String name, double x, double y) {
        this.interferingTransmitters.put(name, new Point2D(x, y));
    }

    public void reset() {
        this.victimReceivers.clear();
        this.interferingTransmitters.clear();
    }

    public LayoutType getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(LayoutType layoutType) {
        this.layoutType = layoutType;
        this.forcePaint = true;
    }

    public double getIntersiteDistance() {
        return this.intersiteDistance;
    }

    public void setIntersiteDistance(double intersiteDistance) {
        this.intersiteDistance = intersiteDistance;
        this.forcePaint = true;
    }

    public int getNumberOfTiers() {
        return this.numberOfTiers;
    }

    public void setNumberOfTiers(int numberOfTiers) {
        this.numberOfTiers = numberOfTiers;
        this.forcePaint = true;
    }

    public double getDisplacementAngle() {
        return this.displacementAngle;
    }

    public void setDisplacementAngle(double displacementAngle) {
        this.displacementAngle = displacementAngle;
        this.forcePaint = true;
    }

    public double getOffsetAngle() {
        return this.offsetAngle;
    }

    public void setOffsetAngle(double offsetAngle) {
        this.offsetAngle = offsetAngle;
        this.forcePaint = true;
    }

    public int getSizeOfFirstTier() {
        return this.sizeOfFirstTier;
    }

    public void setSizeOfFirstTier(int sizeOfFirstTier) {
        this.sizeOfFirstTier = sizeOfFirstTier;
        this.forcePaint = true;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = centerX;
        this.forcePaint = true;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double centerY) {
        this.centerY = centerY;
        this.forcePaint = true;
    }

    public boolean isPlottingGenerated() {
        return this.plottingGenerated;
    }

    public void setPlotGenerated(boolean plottingGenerated) {
        this.plottingGenerated = plottingGenerated;
    }

    public void setDmaVictim(boolean isDma, boolean isUplink, double interCellDistance) {
        this.victimIsDma = isDma;
        if (isDma) {
            this.victimIsUplink = isUplink;
            this.victimInterSiteDistance = interCellDistance;
        }
        this.forcePaint = true;
    }

    public void setGenerateRelativeToVictim(boolean generateRelativeToVictim) {
        this.generateRelativeToVictim = generateRelativeToVictim;
        this.forcePaint = true;
    }

    public static enum LayoutType {
        Circular,
        Hexagon3GPP;

    }
}

