/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.propagationtest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.seamcat.events.TextWidgetValueUpdatedEvent;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.presentation.components.ScrollingBorderPanel;
import org.seamcat.presentation.eventprocessing.PluginConfigurationPanel;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;
import org.seamcat.presentation.localenvironments.LocalEnvironmentsTxRxModel;
import org.seamcat.presentation.localenvironments.LocalEnvironmentsTxRxPanel;
import org.seamcat.presentation.propagationtest.LinkResultConfiguration;
import org.seamcat.presentation.propagationtest.PropagationTestModel;

public class PropagationTestDetailPanel
extends JPanel {
    private final PluginConfigurationPanel pm;
    private PropagationTestModel model;
    private final GenericPanelEditor<LinkResultConfiguration> link;
    private final LocalEnvironmentsTxRxPanel localEnvironmentsPanel;

    public PropagationTestDetailPanel(JFrame owner, PropagationTestModel model) {
        super(new BorderLayout());
        this.model = model;
        this.pm = new PluginConfigurationPanel(owner, model.getPropagationModel(), false, PropagationModelConfiguration.class);
        this.add((Component)new ScrollingBorderPanel(this.pm, "Propagation Model"), "Center");
        JPanel east = new JPanel(new GridLayout(2, 1));
        this.link = new GenericPanelEditor<LinkResultConfiguration>(owner, LinkResultConfiguration.class, model.getLinkResultConfiguration());
        east.add(new ScrollingBorderPanel(this.link, "Link configuration", "<html><b>Note:</b> Not all Propagation Models use all of the configured link parameters</html>"));
        this.localEnvironmentsPanel = new LocalEnvironmentsTxRxPanel(owner, new LocalEnvironmentsTxRxModel(model.getLocalEnvironments().receiverEnvironments(), model.getLocalEnvironments().transmitterEnvironments()));
        east.add(new ScrollingBorderPanel(this.localEnvironmentsPanel, "Local Environments"));
        this.add((Component)east, "East");
    }

    private void updateModel() {
        this.model.setPropagationModelConfiguration((PropagationModelConfiguration)this.pm.getModel());
        this.model.setLinkResultConfiguration(this.link.getModel());
        this.model.setLocalEnvironments(this.localEnvironmentsPanel.getModel());
    }

    public PropagationTestModel getModel() {
        this.updateModel();
        return this.model;
    }

    public GenericPanelEditor<LinkResultConfiguration> getLink() {
        return this.link;
    }

    public boolean matchEvent(TextWidgetValueUpdatedEvent event) {
        return event.getContext() == this.pm.getIdPanel();
    }
}

