/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.propagationtest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.seamcat.presentation.propagationtest.AddRemovePanel;
import org.seamcat.presentation.propagationtest.PropagationTestModel;

public class PropagationTestSelectionPanel
extends JPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private JList list;
    private DefaultListModel listModel;
    private AddRemovePanel propagationTestAddRemovePanel;

    public PropagationTestSelectionPanel(final SelectedModel selectedModel) {
        this.setLayout(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.list.setBorder(BorderFactory.createEmptyBorder());
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int index;
                if (!event.getValueIsAdjusting() && (index = PropagationTestSelectionPanel.this.list.getSelectedIndex()) != -1) {
                    selectedModel.selected((PropagationTestModel)PropagationTestSelectionPanel.this.listModel.get(index));
                }
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    PropagationTestSelectionPanel.this.removeSelectedItem();
                }
            }
        });
        this.propagationTestAddRemovePanel = new AddRemovePanel();
        this.propagationTestAddRemovePanel.setLabelText(STRINGLIST.getString("LBL_ADD_REMOVE"));
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.propagationTestAddRemovePanel, "North");
    }

    public void addModel(PropagationTestModel model) {
        this.listModel.addElement(model);
        this.list.setSelectedIndex(this.listModel.getSize() - 1);
    }

    public void refreshFromModel() {
        this.list.updateUI();
        this.revalidate();
        this.repaint();
    }

    public void removeSelectedItem() {
        int index = this.list.getSelectedIndex();
        int size = this.listModel.getSize();
        if (index >= 0 && size > 1) {
            this.listModel.remove(index);
            if (index < this.listModel.getSize()) {
                this.list.setSelectedIndex(index);
            } else {
                this.list.setSelectedIndex(index - 1);
            }
        }
    }

    public PropagationTestModel getSelected() {
        return (PropagationTestModel)this.list.getSelectedValue();
    }

    public void addAddRemoveListener(AddRemovePanel.AddRemoveListener addRemoveListener) {
        this.propagationTestAddRemovePanel.addAddRemoveListener(addRemoveListener);
    }

    public List<PropagationTestModel> getModels() {
        Object[] models = new PropagationTestModel[this.listModel.size()];
        this.listModel.copyInto(models);
        return Arrays.asList(models);
    }

    public static interface SelectedModel {
        public void selected(PropagationTestModel var1);
    }
}

