/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.propagationtest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.jfree.data.xy.XYSeries;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.presentation.display.DensitySeries;
import org.seamcat.presentation.display.VectorHelper;

public class VectorHolder {
    private String title;
    private double average;
    private double standardDeviation;
    private double variance;
    private double median;
    private double[] data;
    private double[] indexedData;
    private String sortedTitle;
    private double min;
    private double max;
    private double minAxis;
    private double maxAxis;
    private XYSeries vectorDataSeries;
    private XYSeries cumulativeDataSeries;
    private int[] cumulativeEventNumber;
    public int binCount;
    private String unit;
    private DensitySeries densityDataSeries;
    private boolean signalIsConstant;
    private boolean initialized = false;

    public double getAverage() {
        return this.average;
    }

    public void setAverage(double average) {
        this.average = average;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public double getMedian() {
        return this.median;
    }

    public void setMedian(double median) {
        this.median = median;
    }

    public double[] getData() {
        return this.data;
    }

    public void setData(double[] data) {
        this.data = data;
    }

    public double[] getSortedDistributions() {
        return this.indexedData;
    }

    public void setIndexedData(double[] sortedDistributions) {
        this.indexedData = sortedDistributions;
    }

    public double[] getDisplayRange() {
        double[] range = new double[2];
        if (this.indexedData != null) {
            range[0] = this.indexedData[0];
            range[1] = this.indexedData[this.indexedData.length - 1];
        } else {
            range[0] = 0.0;
            range[1] = this.displaySize();
        }
        return range;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.vectorDataSeries != null) {
            this.vectorDataSeries.setKey((Comparable)((Object)title));
        }
        if (this.cumulativeDataSeries != null) {
            this.cumulativeDataSeries.setKey((Comparable)((Object)title));
        }
        if (this.densityDataSeries != null) {
            this.densityDataSeries.comparableKey = title;
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMinAxis() {
        return this.minAxis;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setMinAxis(double minAxis) {
        this.minAxis = minAxis;
    }

    public double getMax() {
        return this.max;
    }

    public double getMaxAxis() {
        return this.maxAxis;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMaxAxis(double maxAxis) {
        this.maxAxis = maxAxis;
    }

    public Iterable<Point2D> displayData() {
        double maxSize = 20000.0;
        final int size = this.displaySize();
        final double prob = (double)this.data.length > 20000.0 ? 20000.0 / (double)this.data.length : 1.0;
        return new Iterable<Point2D>(){

            @Override
            public Iterator<Point2D> iterator() {
                return new Iterator<Point2D>(){
                    private Random random = new Random();
                    private int pointer = 0;
                    private int valueCounter = 0;

                    @Override
                    public boolean hasNext() {
                        if (this.valueCounter == size) {
                            return false;
                        }
                        if (prob < 1.0) {
                            while (!this.skipToNext(size - this.valueCounter)) {
                            }
                        }
                        ++this.valueCounter;
                        return true;
                    }

                    private boolean skipToNext(int remaining) {
                        if ((double)(VectorHolder.this.data.length - this.pointer) * prob >= (double)remaining && this.random.nextDouble() >= prob) {
                            ++this.pointer;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public Point2D next() {
                        Point2D point;
                        double value = VectorHolder.this.data[this.pointer];
                        if (VectorHolder.this.indexedData != null) {
                            double rX = VectorHolder.this.indexedData[this.pointer];
                            point = new Point2D(rX, value);
                            ++this.pointer;
                        } else {
                            point = new Point2D(this.pointer, value);
                            ++this.pointer;
                        }
                        return point;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public int displaySize() {
        if (this.data.length > 20000) {
            return 20000;
        }
        return this.data.length;
    }

    public XYSeries getVectorDataSeries() {
        return this.vectorDataSeries;
    }

    public XYSeries getCumulativeDataSeries() {
        return this.cumulativeDataSeries;
    }

    public int[] getCumulativeEventNumber() {
        return this.cumulativeEventNumber;
    }

    public DensitySeries getDensityDataSeries() {
        return this.densityDataSeries;
    }

    public String toString() {
        return this.title;
    }

    public void setSortedTitle(String sortedTitle) {
        this.sortedTitle = sortedTitle;
    }

    public String getSortedTitle() {
        return this.sortedTitle;
    }

    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        VectorHelper.setPropagationStatistics(this);
        this.signalIsConstant = Mathematics.equals(0.0, this.standardDeviation, 1.0E-4);
        this.setXYSeries();
        this.setCumulativeSeries();
        this.setDensityDataSet();
        this.initialized = true;
    }

    private void setXYSeries() {
        this.vectorDataSeries = new XYSeries((Comparable)((Object)this.getTitle()));
        for (Point2D point : this.displayData()) {
            this.vectorDataSeries.add(point.getX(), point.getY());
        }
    }

    private void setCumulativeSeries() {
        Iterable<Point2D> iterator = this.displayData();
        this.cumulativeDataSeries = new XYSeries((Comparable)((Object)this.getTitle()));
        int size = this.displaySize();
        if (size > 0) {
            if (this.signalIsConstant) {
                double value = iterator.iterator().next().getY();
                this.cumulativeDataSeries.add(0.0, value);
                this.cumulativeDataSeries.add(1.0, value);
                this.cumulativeEventNumber = new int[2];
                this.cumulativeEventNumber[0] = 0;
                this.cumulativeEventNumber[1] = 0;
            } else {
                ArrayList<Point2D> points = new ArrayList<Point2D>();
                for (Point2D value : iterator) {
                    points.add(value);
                }
                this.cumulativeEventNumber = new int[size];
                Collections.sort(points, Point2D.Y_COMPARATOR);
                for (int j = 0; j < size; ++j) {
                    this.cumulativeDataSeries.add(((Point2D)points.get(j)).getY(), (double)j / (double)size);
                    this.cumulativeEventNumber[j] = (int)((Point2D)points.get(j)).getX();
                }
            }
        }
    }

    private void setDensityDataSet() {
        if (!this.signalIsConstant) {
            double[] data = this.getData();
            this.densityDataSeries = new DensitySeries();
            this.densityDataSeries.bin = (int)Math.sqrt(data.length);
            this.densityDataSeries.comparableKey = this.getTitle();
        }
    }

    public boolean isConstant() {
        return this.signalIsConstant;
    }
}

