/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.report;

import java.util.List;
import org.seamcat.presentation.report.ReportNode;
import org.seamcat.presentation.report.ReportValue;
import org.seamcat.tabulardataio.TabularDataSaver;

public class ExcelReportGenerator {
    public static void generate(TabularDataSaver saver, List<ReportNode> report) {
        for (ReportNode section : report) {
            saver.addSheet(section.getTitle());
            for (ReportValue value : section.getValues()) {
                saver.addRow(value.getName(), value.getValue(), value.getUnit());
            }
            for (ReportNode group : section.getNodes()) {
                ExcelReportGenerator.addNode(saver, group);
            }
        }
    }

    private static void addNode(TabularDataSaver saver, ReportNode group) {
        saver.addRow(group.getTitle());
        for (ReportNode subNode : group.getNodes()) {
            ExcelReportGenerator.addNode(saver, subNode);
        }
        for (ReportValue value : group.getValues()) {
            saver.addRow(value.getName(), value.getValue(), value.getUnit());
        }
    }
}

