/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.report;

import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.seamcat.presentation.report.ReportNode;
import org.seamcat.presentation.report.ReportValue;

public class HTMLReportGenerator {
    public static final String header = "<html>\n<style>\nbody {font-family: \"Comic Sans MS\"; }\ntd {font-size: 16; white-space: nowrap;}\n</style>\n<head><title>SEAMCAT Simulation Report</title></head>\n<body><table width='100%' style='background-color:#6699CC'>\n<tr><td><font color='#FFFFFF' size=16'><b>SEAMCAT</b> <sup>&#174;</sup> Simulation Report<br/></font></td></tr>\n</table></body>";
    public static final String footer = "</html>";

    public static void generate(FileWriter writer, List<ReportNode> report) {
        try {
            writer.write(header);
            writer.write("<br><br>\n\n");
            writer.write("<table width=\"100%\">\n");
            for (ReportNode section : report) {
                HTMLReportGenerator.writeHRow(writer, section.getTitle(), "", "", "");
                for (ReportValue value : section.getValues()) {
                    HTMLReportGenerator.writeRow(writer, "", value.getName(), "" + value.getValue(), value.getUnit());
                }
                for (ReportNode node : section.getNodes()) {
                    HTMLReportGenerator.writeNode(writer, node);
                }
            }
            writer.write(footer);
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeNode(FileWriter writer, ReportNode node) throws IOException {
        HTMLReportGenerator.writeRow(writer, node.getTitle(), "", "", "");
        for (ReportNode subNode : node.getNodes()) {
            HTMLReportGenerator.writeNode(writer, subNode);
        }
        for (ReportValue value : node.getValues()) {
            HTMLReportGenerator.writeRow(writer, "", value.getName(), "" + value.getValue(), value.getUnit());
        }
    }

    private static void writeHRow(FileWriter writer, String col1, String col2, String col3, String col4) throws IOException {
        writer.write("<tr><th>" + col1 + "</th><td>" + col2 + "</td><td>" + col3 + "</td><td>" + col4 + "</td></tr>\n");
    }

    private static void writeRow(FileWriter writer, String col1, String col2, String col3, String col4) throws IOException {
        writer.write("<tr><td>" + col1 + "</td><td>" + col2 + "</td><td>" + col3 + "</td><td>" + col4 + "</td></tr>\n");
    }
}

