/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.report;

import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.seamcat.presentation.report.ReportNode;
import org.seamcat.presentation.report.ReportValue;

public class XMLReportGenerator {
    public static final String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<report>";
    private static final String INDENT = "   ";

    public static void generate(FileWriter writer, List<ReportNode> report) {
        try {
            writer.write(header);
            for (ReportNode section : report) {
                writer.write("<section title=\"" + section.getTitle() + "\">\n");
                for (ReportValue value : section.getValues()) {
                    XMLReportGenerator.writeValue(value, writer, INDENT);
                }
                for (ReportNode node : section.getNodes()) {
                    XMLReportGenerator.writeNode(1, writer, node);
                }
                writer.write("</section>\n");
            }
            writer.write("</report>");
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeNode(int indent, FileWriter writer, ReportNode node) throws IOException {
        String in = XMLReportGenerator.in(indent);
        writer.write(in + "<node title=\"" + node.getTitle() + "\">\n");
        for (ReportNode subNode : node.getNodes()) {
            XMLReportGenerator.writeNode(indent + 1, writer, subNode);
        }
        for (ReportValue value : node.getValues()) {
            XMLReportGenerator.writeValue(value, writer, in + INDENT);
        }
        writer.write(in + "</node>\n");
    }

    private static void writeValue(ReportValue value, FileWriter writer, String indent) throws IOException {
        String unit = "";
        if (!value.getUnit().isEmpty()) {
            unit = " unit=\"" + value.getUnit() + "\"";
        }
        writer.write(indent + "<value name=\"" + value.getName().replace("<", "&lt;") + "\" value=\"" + value.getValue() + "\"" + unit + "/>\n");
    }

    private static String in(int indent) {
        StringBuilder sb = new StringBuilder();
        while (indent > 0) {
            sb.append(INDENT);
            --indent;
        }
        return sb.toString();
    }
}

