/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.outline;

import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.events.MemoryStatusUpdatedEvent;
import org.seamcat.presentation.components.AbstractStatusPanel;
import org.seamcat.presentation.simulationview.outline.OutlinePanel;

public class SimulationStatusPanel
extends AbstractStatusPanel {
    public SimulationStatusPanel() {
        EventBusFactory.getEventBus().subscribe(this);
    }

    public SimulationStatusPanel(int eventsToBeCalculated, int currentProgress) {
        if (eventsToBeCalculated < OutlinePanel.maxProgressSteps) {
            this.initialize(eventsToBeCalculated);
            this.set(currentProgress);
        } else {
            this.initialize(OutlinePanel.maxProgressSteps - 1);
            int current = currentProgress / (eventsToBeCalculated / OutlinePanel.maxProgressSteps);
            this.set(current);
        }
    }

    public void destroy() {
        EventBusFactory.getEventBus().unsubscribe(this);
    }

    public void startingEventGeneration(int eventsToBeCalculated) {
        if (eventsToBeCalculated < OutlinePanel.maxProgressSteps) {
            this.initialize(eventsToBeCalculated);
        } else {
            this.initialize(OutlinePanel.maxProgressSteps - 1);
        }
    }

    public void eventGenerationCompleted() {
        this.finished();
    }

    @UIEventHandler
    public void handleMemoryStatusRefresh(MemoryStatusUpdatedEvent event) {
        this.memoryUsage.setMaximum(event.getMemoryMax());
        this.memoryUsage.setValue(event.getMemoryUsageValue());
        this.memoryUsageLabel.setText(event.getMemoryStatusLabel());
    }
}

