/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.outline;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.seamcat.events.RSSEvent;
import org.seamcat.model.Scenario;
import org.seamcat.model.engines.VectorDefinitions;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.optional.InterferenceNames;
import org.seamcat.presentation.SeamcatIcons;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public class SimulationSummaryPanel
extends JPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private static final String unitdBm = " dBm";
    private JLabel blockingMedianValue;
    private JLabel blockingMeanDBmValue;
    private JLabel blockingStdDValue;
    private JLabel dRSSMedianValue;
    private JLabel dRSSMeanDBmValue;
    private JLabel dRSSStdDValue;
    private JLabel unwantedEmissionMedianValue;
    private JLabel unwantedEmissionMeanDBmValue;
    private JLabel unwantedEmissionStdDValue;
    private boolean victimGeneric = false;

    public SimulationSummaryPanel(Scenario scenario) {
        super(new GridLayout(1, 2));
        SystemPlugin victim = scenario.getVictim().getSystemPlugin();
        this.victimGeneric = victim instanceof GenericSystemPlugin;
        JPanel description = new JPanel();
        JPanel numbers = new JPanel();
        this.add(description);
        this.add(numbers);
        if (this.victimGeneric) {
            description.setLayout(new GridLayout(4, 1));
            numbers.setLayout(new GridLayout(4, 3));
        } else {
            description.setLayout(new GridLayout(3, 1));
            numbers.setLayout(new GridLayout(3, 3));
        }
        JLabel lbMeanDBm = new JLabel("<html><b>Mean</b></html>", 4);
        JLabel lbMedian = new JLabel("<html><b>Median</b></html>", 4);
        JLabel lbStddev = new JLabel("<html><b> StdDev</b></html>", 4);
        if (victim instanceof InterferenceNames) {
            JLabel title = new JLabel("<html><b>" + ((InterferenceNames)((Object)victim)).title() + "</b></html>");
            String information = ((InterferenceNames)((Object)victim)).information();
            if (information == null || information.isEmpty()) {
                description.add(title);
            } else {
                JPanel titlePanel = new JPanel(new FlowLayout(0));
                titlePanel.add(title);
                JLabel info = new JLabel(SeamcatIcons.getImageIcon("SEAMCAT_ICON_INFORMATION", 0));
                info.setToolTipText(information);
                titlePanel.add(info);
                description.add(titlePanel);
            }
        } else {
            description.add(Box.createGlue());
        }
        numbers.add(lbMeanDBm);
        numbers.add(lbMedian);
        numbers.add(lbStddev);
        if (this.victimGeneric) {
            this.dRSSMedianValue = new JLabel("0.0 dBm", 4);
            this.dRSSMeanDBmValue = new JLabel("0.0 dBm", 4);
            this.dRSSStdDValue = new JLabel("0.0", 4);
            description.add(new JLabel(STRINGLIST.getString("SIMULATION_STATUS_DRSS")));
            numbers.add(this.dRSSMeanDBmValue);
            numbers.add(this.dRSSMedianValue);
            numbers.add(this.dRSSStdDValue);
        }
        this.unwantedEmissionMedianValue = new JLabel("0.0 dBm", 4);
        this.unwantedEmissionMeanDBmValue = new JLabel("0.0 dBm", 4);
        this.unwantedEmissionStdDValue = new JLabel("0.0", 4);
        this.blockingMedianValue = new JLabel("0.0 dBm", 4);
        this.blockingMeanDBmValue = new JLabel("0.0 dBm", 4);
        this.blockingStdDValue = new JLabel("0.0", 4);
        String u = VectorDefinitions.IRSSU;
        String b = VectorDefinitions.IRSSB;
        if (victim instanceof InterferenceNames) {
            InterferenceNames names = (InterferenceNames)((Object)victim);
            u = names.unwantedName();
            b = names.blockingName();
        }
        description.add(new JLabel(u));
        numbers.add(this.unwantedEmissionMeanDBmValue);
        numbers.add(this.unwantedEmissionMedianValue);
        numbers.add(this.unwantedEmissionStdDValue);
        description.add(new JLabel(b));
        numbers.add(this.blockingMeanDBmValue);
        numbers.add(this.blockingMedianValue);
        numbers.add(this.blockingStdDValue);
    }

    public void handle(RSSEvent event) {
        if (this.victimGeneric) {
            this.dRSSMedianValue.setText(event.getRss().getMedian());
            this.dRSSMeanDBmValue.setText(event.getRss().getMean());
            this.dRSSStdDValue.setText(event.getRss().getStdDev());
        }
        this.unwantedEmissionMedianValue.setText(event.getIrssU().getMedian());
        this.unwantedEmissionMeanDBmValue.setText(event.getIrssU().getMean());
        this.unwantedEmissionStdDValue.setText(event.getIrssU().getStdDev());
        this.blockingMedianValue.setText(event.getIrssB().getMedian());
        this.blockingMeanDBmValue.setText(event.getIrssB().getMean());
        this.blockingStdDValue.setText(event.getIrssB().getStdDev());
    }
}

