/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.outline;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.presentation.display.SignalChartFactory;
import org.seamcat.presentation.layout.VerticalSubPanelLayoutManager;

public class VectorPanel
extends JPanel {
    private ChartPanel vectorChart;
    private String unit;
    private String mtitle;
    private String xTitle;
    private String yTitle;
    private XYSeriesCollection collection;
    private int numberOfEvents;
    private float[][] pattern = new float[][]{{10.0f}, {10.0f, 10.0f}, {10.0f, 10.0f, 2.0f, 10.0f}, {1.0f, 20.0f}};

    public VectorPanel(String xTitle, String yTitle, int numberOfEvents) {
        this.numberOfEvents = numberOfEvents;
        this.setLayout(new BorderLayout());
        this.xTitle = xTitle;
        this.yTitle = yTitle;
    }

    public void show(String title, String unit) {
        this.unit = unit;
        this.mtitle = title;
        this.createCharts();
        JPanel right = new JPanel();
        right.setLayout(new VerticalSubPanelLayoutManager());
        this.add((Component)right, "East");
    }

    public void appendValue(int eventNumber, Double value) {
        if (this.collection.getSeriesCount() > 0) {
            XYSeries series = (XYSeries)this.collection.getSeries().get(0);
            series.add((double)eventNumber, (Number)value);
            this.vectorChart.getChart().getXYPlot().setDataset(this.collection);
        }
    }

    public void addStatistics(double mean, double stdDev) {
        XYSeriesCollection collection = new XYSeriesCollection();
        collection.addSeries(this.create("mean - std. dev", mean - stdDev));
        collection.addSeries(this.create("mean", mean));
        collection.addSeries(this.create("mean + std. dev", mean + stdDev));
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        renderer.setSeriesPaint(0, Color.BLACK);
        renderer.setSeriesPaint(1, Color.GREEN);
        renderer.setSeriesPaint(2, Color.BLACK);
        renderer.setSeriesStroke(0, this.getOdynStroke(1.0f, 1));
        renderer.setSeriesStroke(1, this.getOdynStroke(2.0f, 0));
        renderer.setSeriesStroke(2, this.getOdynStroke(1.0f, 1));
        this.vectorChart.getChart().getXYPlot().setRenderer(1, renderer);
        this.vectorChart.getChart().getXYPlot().setDataset(1, collection);
    }

    public Stroke[] strokes(float width) {
        Stroke[] strokes = new Stroke[]{new BasicStroke(width, 0, 0, 10.0f), new BasicStroke(width, 0, 0, 10.0f, this.pattern[1], 0.0f)};
        return strokes;
    }

    public Stroke getOdynStroke(float width, int type) {
        return this.strokes(width)[type];
    }

    private XYSeries create(String title, double value) {
        XYSeries series = new XYSeries((Comparable)((Object)title));
        series.add(0.0, value);
        series.add((double)this.numberOfEvents, value);
        return series;
    }

    private void createCharts() {
        this.removeAll();
        this.collection = new XYSeriesCollection();
        this.collection.addSeries(new XYSeries((Comparable)((Object)"samples")));
        JFreeChart scatter = ChartFactory.createScatterPlot(this.mtitle, this.xTitle, this.yTitle, this.collection);
        XYItemRenderer renderer = scatter.getXYPlot().getRenderer(0);
        Ellipse2D.Double shape = new Ellipse2D.Double(0.0, 0.0, 4.0, 4.0);
        renderer.setBaseShape(shape);
        renderer.setBasePaint(Color.red);
        renderer.setSeriesShape(0, shape);
        this.vectorChart = new ChartPanel(scatter);
        SignalChartFactory.applyStyles(this.vectorChart, this.getFont(), true);
        this.add((Component)this.vectorChart, "Center");
        this.setUpGraphLabels();
        this.setVisible(true);
    }

    private void setUpGraphLabels() {
        this.vectorChart.getChart().setTitle(this.mtitle);
        this.vectorChart.getChart().getXYPlot().getRangeAxis().setLabel(this.unit);
        this.vectorChart.getChart().getXYPlot().getDomainAxis().setLabel("Event samples out of " + this.numberOfEvents);
    }

    public void reset() {
        this.vectorChart.getChart().getXYPlot().setDataset(null);
    }
}

