/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.replay;

import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.seamcat.model.Scenario;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.LocalEnvironmentResult;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.presentation.LabeledPairLayout;
import org.seamcat.simulation.generic.CognitiveRadio;
import org.seamcat.simulation.result.SensingLinkResult;

public class EventResultPanel
extends JPanel {
    private static NumberFormat nf = new DecimalFormat("0.0000");

    public EventResultPanel(EventResult eventResult, Scenario scenario) {
        super(new LabeledPairLayout());
        EventResultPanel jPanel = this;
        List<Victim> vLinks = eventResult.getVictimResult().getVictims();
        this.space(jPanel);
        this.printLinks("Victim system link", jPanel, vLinks);
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            this.space(jPanel);
            for (InterferenceLinkResult iLink : eventResult.getInterferenceLinkResult(link)) {
                this.addRow(jPanel, "*** Interference link result ***", "");
                this.linkResult(jPanel, iLink);
                this.addRow(jPanel, "iRSS unwanted", nf.format(iLink.getRiRSSUnwantedValue()));
                this.addRow(jPanel, "iRSS blocking", nf.format(iLink.getRiRSSBlockingValue()));
            }
            List<LinkResult> specialLinks = eventResult.getInterferenceLinkResult(link).get(0).getInterferingSystemResult().getLinkResults(CognitiveRadio.SENSING_LINK);
            if (specialLinks == null || specialLinks.isEmpty() || !(specialLinks.get(0) instanceof SensingLinkResult)) continue;
            this.addRow(jPanel, "Sensing link", "");
            this.linkResult(jPanel, specialLinks.get(0));
        }
    }

    private void space(JPanel jPanel) {
        this.addRow(jPanel, "", "");
    }

    private void printLinks(String single, JPanel jPanel, List<Victim> list) {
        if (list.size() == 0) {
            return;
        }
        if (list.size() > 1) {
            this.addRow(jPanel, single + "s", "");
        } else {
            this.addRow(jPanel, single, "");
        }
        for (int i = 0; i < list.size(); ++i) {
            LinkResult link = list.get(i).getLinkResult();
            this.linkResult(jPanel, link);
            if (i + 1 >= list.size()) continue;
            this.addRow(jPanel, "---", "---");
        }
    }

    private void addRow(JPanel panel, String label, String value) {
        panel.add((Component)new JLabel("<html><b>" + label + "</b></html>"), "label");
        panel.add((Component)new JLabel(value), "field");
    }

    private void linkResult(JPanel panel, LinkResult linkResult) {
        this.addRow(panel, "Receiver antenna", "");
        this.antenna(panel, linkResult.rxAntenna());
        this.addRow(panel, "Transmitter antenna", "");
        this.antenna(panel, linkResult.txAntenna());
        this.addRow(panel, "Link results", "");
        this.addRow(panel, "frequency", nf.format(linkResult.getFrequency()));
        this.addRow(panel, "tx rx angle", nf.format(linkResult.getTxRxAngle()));
        this.addRow(panel, "tx power", nf.format(linkResult.getTxPower()));
        this.addRow(panel, "rx tx distance", nf.format(linkResult.getTxRxDistance()));
        if (linkResult instanceof InterferenceLinkResult) {
            InterferenceLinkResult ilink = (InterferenceLinkResult)linkResult;
            this.addRow(panel, "iRSS unwanted", nf.format(ilink.getRiRSSUnwantedValue()));
            this.addRow(panel, "iRSS blocking", nf.format(ilink.getRiRSSBlockingValue()));
            this.addRow(panel, "blocking attenuation", nf.format(ilink.getBlockingAttenuation()));
        }
        for (Map.Entry<UniqueValueDef, Double> entry : linkResult.getDoubleValues().entrySet()) {
            this.addRow(panel, entry.getKey().name(), nf.format(entry.getValue()));
        }
    }

    private void antenna(JPanel panel, AntennaResult antennaResult) {
        this.point(panel, "position", antennaResult.getPosition());
        this.addRow(panel, "height", "" + antennaResult.getHeight());
        this.addRow(panel, "elevation", "" + antennaResult.getElevation());
        this.addRow(panel, "azimuth", "" + antennaResult.getAzimuth());
        this.addRow(panel, "elevation compensation", "" + antennaResult.getElevationCompensation());
        this.addRow(panel, "tilt", "" + antennaResult.getTilt());
        this.localEnv(panel, "local environment", antennaResult.getLocalEnvironment());
        this.addRow(panel, "gain", nf.format(antennaResult.getGain()));
    }

    private void point(JPanel panel, String name, Point2D point) {
        this.addRow(panel, name, "(" + nf.format(point.getX()) + ", " + nf.format(point.getY()) + ")");
    }

    private void localEnv(JPanel panel, String name, LocalEnvironmentResult le) {
        this.addRow(panel, name, "(" + (Object)((Object)le.getEnvironment()) + " wallLoss=" + nf.format(le.getWallLoss()) + " std.dev=" + nf.format(le.getWallLossStdDev()) + ")");
    }
}

