/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.replay;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.simulationview.replay.EventResultPanel;
import org.seamcat.presentation.simulationview.replay.SingleEventSimulationResult;

public class SingleEventPanel
extends JPanel {
    private static final int maxLines = 1000;

    public SingleEventPanel(SingleEventSimulationResult result, JTabbedPane pane) {
        super(new BorderLayout());
        EventResultPanel panel = new EventResultPanel(result.getEventResult(), result.getScenario());
        JSplitPane jPanel = new JSplitPane(1);
        jPanel.setDividerLocation(700);
        jPanel.add(new BorderPanel(new JScrollPane(panel), "Event Result"));
        JTextArea textArea = new JTextArea(20, 30);
        JPanel debugTracePanel = new JPanel(new BorderLayout());
        debugTracePanel.add((Component)new JLabel("<html>Showing log trace of file<br><b>" + result.getLogFile().getAbsolutePath() + "</b></html>"), "North");
        debugTracePanel.add((Component)new JScrollPane(textArea), "Center");
        jPanel.add(new BorderPanel(debugTracePanel, "Log Trace"));
        this.add((Component)jPanel, "Center");
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(result.getLogFile()));
            for (int i = 0; null != (line = reader.readLine()) && i < 1000; ++i) {
                textArea.append(line + "\n");
            }
            if (line != null) {
                textArea.append("...\n");
                textArea.append("See log file for full trace");
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

