/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.results;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.seamcat.model.Scenario;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.presentation.components.ScrollingBorderPanel;
import org.seamcat.presentation.simulationview.results.SelectionsCallback;

public class EventResultControlPanel
extends JPanel {
    private final JCheckBox[] checks;
    private SelectionsCallback cb;
    private final boolean[] isChecked;

    public EventResultControlPanel(Scenario scenario, EventResult result, SelectionsCallback cb) {
        super(new BorderLayout());
        this.checks = new JCheckBox[scenario.getInterferenceLinks().size() + 1];
        this.cb = cb;
        this.isChecked = new boolean[this.checks.length];
        int idx = 0;
        this.checks[idx] = new JCheckBox("Victim system (" + scenario.getVictim().getName() + ")");
        this.checks[idx].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventResultControlPanel.this.changed();
            }
        });
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            this.checks[++idx] = new JCheckBox("Link " + idx + " (" + link.getInterferer().getName() + ")");
            this.checks[idx].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventResultControlPanel.this.changed();
                }
            });
        }
        JPanel buttons = new JPanel(new FlowLayout(0));
        buttons.add(new JLabel("<html><b>Enable Victim/Interferer points"));
        for (JCheckBox check : this.checks) {
            check.setSelected(true);
            buttons.add(check);
        }
        this.add(new ScrollingBorderPanel(buttons, "System Selection"));
    }

    private void changed() {
        for (int i = 0; i < this.checks.length; ++i) {
            this.isChecked[i] = this.checks[i].isSelected();
        }
        this.cb.enablementChanged(this.isChecked);
    }
}

