/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.results;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.Scenario;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.presentation.simulationview.results.LinkResultPlot;

public class EventResultPlotData {
    private Map<Integer, List<LinkResultPlot>> linkResultMap = new LinkedHashMap<Integer, List<LinkResultPlot>>();
    private Map<Integer, List<InterferenceLinkResult>> interferenceLinkResultMap = new LinkedHashMap<Integer, List<InterferenceLinkResult>>();

    EventResultPlotData(Scenario scenario, EventResult model) {
        VictimResultCollector result = model.getVictimResult();
        this.linkResultMap.put(0, new ArrayList());
        for (Victim victim : result.getVictims()) {
            this.linkResultMap.get(0).add(new LinkResultPlot(scenario.getVictim().getSystemPlugin().getUI().description().name(), victim, Color.BLUE, Color.GREEN));
        }
        int idx = 1;
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            InterfererResultCollector iCollector = model.getInterferingSystemResult(link);
            this.linkResultMap.put(idx, new ArrayList());
            for (Interferer interferer : iCollector.getInterferingElements()) {
                this.linkResultMap.get(idx).add(new LinkResultPlot(idx, interferer, iCollector.getLink(), Color.ORANGE, Color.RED));
            }
            List<InterferenceLinkResult> iLinks = model.getInterferenceLinkResult(link);
            for (InterferenceLinkResult iLink : iLinks) {
                this.append(idx, iLink);
                this.append(0, iLink);
            }
            ++idx;
        }
    }

    Map<Integer, List<LinkResultPlot>> getLinkResultMap() {
        return this.linkResultMap;
    }

    private void append(int idx, InterferenceLinkResult result) {
        List<InterferenceLinkResult> list = this.interferenceLinkResultMap.get(idx);
        if (list == null) {
            list = new ArrayList<InterferenceLinkResult>();
            this.interferenceLinkResultMap.put(idx, list);
        }
        list.add(result);
    }

    public List<LinkResultPlot> getAdjacentLinks(LinkResultPlot selected) {
        ArrayList<LinkResultPlot> result = new ArrayList<LinkResultPlot>();
        List<LinkResultPlot> systemLinks = this.linkResultMap.get(selected.getIdx());
        if (selected.isRxSelected()) {
            for (LinkResultPlot systemLink : systemLinks) {
                if (!systemLink.isSameRx(selected)) continue;
                result.add(systemLink);
            }
        } else {
            for (LinkResultPlot systemLink : systemLinks) {
                if (!systemLink.isSameTx(selected)) continue;
                result.add(systemLink);
            }
        }
        return result;
    }

    public List<InterferenceLinkResult> getRelevantInterferenceLinks(LinkResultPlot selected) {
        ArrayList<InterferenceLinkResult> result;
        block4: {
            List<InterferenceLinkResult> links;
            block3: {
                result = new ArrayList<InterferenceLinkResult>();
                links = this.interferenceLinkResultMap.get(selected.getIdx());
                if (selected.getIdx() != 0) break block3;
                if (!selected.isRxSelected()) break block4;
                for (InterferenceLinkResult link : links) {
                    if (!link.getVictim().isSameRx(selected.getSystemLink())) continue;
                    result.add(link);
                }
                break block4;
            }
            if (selected.isTxSelected()) {
                for (InterferenceLinkResult link : links) {
                    if (!link.getInterferer().isSameTx(selected.getSystemLink())) continue;
                    result.add(link);
                }
            }
        }
        return result;
    }
}

