/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.results;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import org.seamcat.model.Scenario;
import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.engines.SingleEvent;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.Polygon2D;
import org.seamcat.model.geometry.PolygonUtil;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.antenna.HorizontalVerticalInput;
import org.seamcat.model.plugin.system.ContexedSystemPlugin;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.presentation.simulationview.results.BoundingBox;
import org.seamcat.presentation.simulationview.results.DetailPanel;
import org.seamcat.presentation.simulationview.results.EventResultPlotData;
import org.seamcat.presentation.simulationview.results.LinkResultPlot;
import org.seamcat.presentation.simulationview.results.SecondPointSelection;
import org.seamcat.presentation.simulationview.results.SelectionsCallback;
import org.seamcat.simulation.result.ConsistencyCheckContextImpl;

public class ScenarioEventResultPlot
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static DecimalFormat format = new DecimalFormat("#.###");
    private boolean[] isChecked;
    private DetailPanel detailPanel;
    private double width;
    private double height;
    private Animator animator;
    private int focusShiftX = 0;
    private int focusShiftY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private Color patternColor = new Color(240, 193, 193);
    private boolean plotHelp = true;
    private boolean plotLegend = true;
    private boolean plotScale = true;
    private double scaleFactor;
    private int selectedItemZoomFactor = 0;
    private double zoomFactor = 1.0;
    protected PropertySetter prop;
    private EventResultPlotData data;
    private Scenario scenario;
    private EventResult model;
    private BoundingBox box = new BoundingBox();
    private Map<Point2D, LinkResultPlot> proximityMap = new HashMap<Point2D, LinkResultPlot>();
    private LinkResultPlot selected;
    private boolean onlyLinkSelected = false;
    private SecondPointSelection linkSelected;
    private SelectionsCallback cb = new SelectionsCallback(){

        @Override
        public void enablementChanged(boolean[] isChecked) {
            ScenarioEventResultPlot.access$102(ScenarioEventResultPlot.this, isChecked);
            ScenarioEventResultPlot.this.repaint();
        }
    };

    public ScenarioEventResultPlot(EventResultPlotData data, Scenario scenario, EventResult model) {
        this.data = data;
        this.scenario = scenario;
        this.model = model;
        this.isChecked = new boolean[1 + scenario.getInterferenceLinks().size()];
        for (int i = 0; i < this.isChecked.length; ++i) {
            this.isChecked[i] = true;
        }
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            Bounds coverage = new ConsistencyCheckContextImpl(link).getCoverage();
            this.box.maxX = Math.max(coverage.getMax(), this.box.maxX);
            this.box.minX = -this.box.maxX;
            this.box.maxY = Math.max(coverage.getMax(), this.box.maxY);
            this.box.minY = -this.box.maxY;
        }
        this.width = Math.max(this.box.maxX - this.box.minX, 1.5) * 1.2;
        this.height = Math.max(this.box.maxY - this.box.minY, 1.5) * 1.2;
        this.prop = new PropertySetter((Object)this, "selectedItemZoomFactor", 0, 4);
        super.addMouseListener(this);
        super.addMouseMotionListener(this);
        super.addMouseWheelListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setModelSizes(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                ScenarioEventResultPlot.this.setModelSizes(true);
            }
        });
    }

    protected void setDetailPanel(DetailPanel detailPanel) {
        this.detailPanel = detailPanel;
    }

    public void setSelectedItemZoomFactor(int selectedItemZoomFactor) {
        this.selectedItemZoomFactor = selectedItemZoomFactor;
        this.repaint();
    }

    public int getSelectedItemZoomFactor() {
        return this.selectedItemZoomFactor;
    }

    public void setFocusShiftX(int _focusShiftX) {
        this.focusShiftX += _focusShiftX;
    }

    public void setFocusShiftY(int _focusShiftY) {
        this.focusShiftY += _focusShiftY;
    }

    public void adjustZoom(double adjustment) {
        double adjust = adjustment / 100.0;
        this.zoomFactor += adjust;
        if (this.zoomFactor < 0.0) {
            this.zoomFactor = 0.0;
        }
    }

    public EventResult getModel() {
        return this.model;
    }

    public int getFocusShiftX() {
        return this.focusShiftX;
    }

    public int getFocusShiftY() {
        return this.focusShiftY;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    @Override
    public void paintComponent(Graphics _gr) {
        super.paintComponent(_gr);
        Graphics2D gr = (Graphics2D)_gr;
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gr.setBackground(Color.WHITE);
        this.setScaleFactor();
        Dimension dim = this.getSize();
        double intercellDistance = 1.0;
        gr.clearRect(0, 0, (int)dim.getWidth(), (int)dim.getHeight());
        if (this.plotScale) {
            gr.drawLine((int)dim.getWidth() / 20, (int)dim.getHeight() / 20, (int)(dim.getWidth() / 20.0 + this.scaleFactor * intercellDistance), (int)dim.getHeight() / 20);
            gr.drawLine((int)(dim.getWidth() / 20.0 + this.scaleFactor * intercellDistance), (int)dim.getHeight() / 20 - 5, (int)(dim.getWidth() / 20.0 + this.scaleFactor * intercellDistance), (int)dim.getHeight() / 20 + 5);
            gr.drawLine((int)dim.getWidth() / 20, (int)dim.getHeight() / 20 - 5, (int)dim.getWidth() / 20, (int)dim.getHeight() / 20 + 5);
            gr.drawString("D = " + Mathematics.round(intercellDistance) + " km", (int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() / 20.0) + 20);
        }
        if (this.plotLegend) {
            int line = 1;
            gr.setColor(Color.GREEN);
            gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() / 20.0 + 14.0 + (double)(line * gr.getFont().getSize()) * 1.5), 4, 4);
            gr.drawString(" = Victim System Tx", (int)(dim.getWidth() / 20.0) + 35, (int)(dim.getHeight() / 20.0 + 20.0 + (double)(line * gr.getFont().getSize()) * 1.5));
            gr.setColor(Color.BLUE);
            gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() / 20.0 + 14.0 + (double)(++line * gr.getFont().getSize()) * 1.5), 4, 4);
            gr.drawString(" = Victim Link Rx", (int)(dim.getWidth() / 20.0) + 35, (int)(dim.getHeight() / 20.0 + 20.0 + (double)(line * gr.getFont().getSize()) * 1.5));
            gr.setColor(Color.RED);
            gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() / 20.0 + 14.0 + (double)(++line * gr.getFont().getSize()) * 1.5), 4, 4);
            gr.drawString(" = Interfering Link Tx", (int)(dim.getWidth() / 20.0) + 35, (int)(dim.getHeight() / 20.0 + 20.0 + (double)(line * gr.getFont().getSize()) * 1.5));
            gr.setColor(Color.ORANGE);
            gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() / 20.0 + 14.0 + (double)(++line * gr.getFont().getSize()) * 1.5), 4, 4);
            gr.drawString(" = Interfering System Rx", (int)(dim.getWidth() / 20.0) + 35, (int)(dim.getHeight() / 20.0 + 20.0 + (double)(line * gr.getFont().getSize()) * 1.5));
        }
        if (this.plotHelp) {
            gr.setColor(Color.BLUE);
            boolean textOffset = false;
            gr.drawString("Click on element to see details", (int)(dim.getWidth() / 20.0) + 38, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset - 6.0 + (double)(5 * gr.getFont().getSize()) * 1.5)));
            gr.drawString("Zoom using mousewheel or slider", (int)(dim.getWidth() / 20.0) + 38, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset - 6.0 + (double)(4 * gr.getFont().getSize()) * 1.5)));
            gr.drawString("Grab and drag to recenter", (int)(dim.getWidth() / 20.0) + 38, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset - 6.0 + (double)(3 * gr.getFont().getSize()) * 1.5)));
            gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset + (double)(3 * gr.getFont().getSize()) * 1.5)), 4, 4);
            gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset + (double)(4 * gr.getFont().getSize()) * 1.5)), 4, 4);
            gr.fillOval((int)(dim.getWidth() / 20.0) + 30, (int)(dim.getHeight() - (dim.getHeight() / 20.0 + (double)textOffset + (double)(5 * gr.getFont().getSize()) * 1.5)), 4, 4);
        }
        gr.translate((int)(dim.getWidth() / 2.0), (int)(dim.getHeight() / 2.0));
        if (this.isChecked[0]) {
            this.drawSystemOutline(gr, Point2D.ORIGIN, this.scenario.getVictim());
        }
        int idx = 1;
        for (InterferenceLink link : this.scenario.getInterferenceLinks()) {
            if (this.isChecked[idx]) {
                InterfererResultCollector iCollector = this.model.getInterferingSystemResult(link);
                List<Point2D> centers = iCollector.getScatterPoints(SingleEvent.SYSTEM_CENTER);
                for (Point2D center : centers) {
                    this.drawSystemOutline(gr, center, link.getInterferer());
                }
            }
            ++idx;
        }
        this.proximityMap.clear();
        for (int i = 0; i < this.isChecked.length; ++i) {
            if (!this.isChecked[i]) continue;
            for (LinkResultPlot plot : this.data.getLinkResultMap().get(i)) {
                this.drawLink(gr, plot);
            }
        }
        if (this.onlyLinkSelected) {
            gr.setColor(Color.BLACK);
            LinkResult systemLink = this.linkSelected.getIfSystemLink();
            if (systemLink != null) {
                this.drawSystemLine(gr, systemLink);
            } else {
                this.drawLine(gr, this.linkSelected.getRxP(), this.linkSelected.getTxP());
            }
        }
    }

    private void setModelSizes(boolean panelInitialized) {
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        ArrayList<Point2D> allPoints = new ArrayList<Point2D>(PolygonUtil.allPoints(this.scenario.getVictim().getSystemSpaces()));
        for (InterferenceLink link : this.scenario.getInterferenceLinks()) {
            allPoints.addAll(PolygonUtil.allPoints(link.getInterferer().getSystemSpaces()));
        }
        for (Point2D point : allPoints) {
            minX = Math.min(minX, point.getX());
            maxX = Math.max(maxX, point.getX());
            minY = Math.min(minY, point.getY());
            maxY = Math.max(maxY, point.getY());
        }
        Bounds x = new Bounds(minX, maxX, true);
        Bounds y = new Bounds(minY, maxY, true);
        double rangeX = Math.abs(x.getMax() - x.getMin());
        double rangeY = Math.abs(y.getMax() - y.getMin());
        this.width = rangeX * 1.2;
        this.height = rangeY * 1.2;
        if (panelInitialized) {
            this.setScaleFactor();
            this.focusShiftX = (int)(-this.scaleFactor * (x.getMax() + x.getMin()) / 2.0);
            this.focusShiftY = (int)(this.scaleFactor * (y.getMax() + y.getMin()) / 2.0);
        }
    }

    private void setScaleFactor() {
        Dimension dim = this.getSize();
        double scaleFactorH = dim.getHeight() / this.height;
        double scaleFactorW = dim.getWidth() / this.width;
        this.scaleFactor = Math.min(scaleFactorH, scaleFactorW);
        this.scaleFactor *= this.zoomFactor;
    }

    private void drawSystemOutline(Graphics2D gr, Point2D center, ContexedSystemPlugin plugin) {
        SystemSpaces spaces = plugin.getSystemSpaces();
        if (spaces == null) {
            return;
        }
        for (Space space : spaces.getAllSpaces()) {
            Polygon2D polygon = space.getSpace();
            if (polygon.getVertices().size() <= 1) continue;
            this.drawPolygon(gr, polygon, center);
        }
    }

    private void drawPolygon(Graphics2D gr, Polygon2D polygon, Point2D offset) {
        List<Point2D> vertices = polygon.getVertices();
        int[] x = new int[vertices.size()];
        int[] y = new int[vertices.size()];
        for (int i = 0; i < vertices.size(); ++i) {
            Point2D vertex = vertices.get(i);
            Point2D e = this.convert(offset.add(vertex));
            x[i] = (int)e.getX();
            y[i] = (int)e.getY();
        }
        gr.setColor(Color.BLACK);
        gr.drawPolygon(x, y, x.length);
    }

    private void drawLink(Graphics2D gr, LinkResultPlot plot) {
        LinkResult result = plot.getLinkResult();
        Point2D drawRx = this.convert(result.rxAntenna().getPosition());
        if (result.getValue(InterferenceSimulationEngine.RX_NOT_SIMULATED) == null) {
            this.proximityMap.put(drawRx, plot);
            this.drawPoint(gr, drawRx, plot.getRxColor(), plot.isRxSelected());
        }
        Point2D drawTx = this.convert(result.txAntenna().getPosition());
        if (result.getValue(InterferenceSimulationEngine.TX_NOT_SIMULATED) == null) {
            this.proximityMap.put(drawTx, plot);
            this.drawPoint(gr, drawTx, plot.getTxColor(), plot.isTxSelected());
        }
        if (!this.onlyLinkSelected && (plot.isRxSelected() || plot.isTxSelected())) {
            gr.setColor(Color.BLACK);
            this.drawSystemLine(gr, result);
            for (LinkResultPlot pl : this.getGroup(plot)) {
                this.drawSystemLine(gr, pl.getLinkResult());
            }
            this.drawILinks(gr, this.data.getRelevantInterferenceLinks(plot));
        }
    }

    private void drawSystemLine(Graphics2D gr, LinkResult link) {
        Point2D drawA = this.convert(link.txAntenna().getPosition());
        Point2D drawB = this.convert(link.rxAntenna().getPosition());
        if (link.getValue(InterferenceSimulationEngine.SYSTEM_LINK_TYPE) == "Secondary Link") {
            Graphics2D g2d = (Graphics2D)gr.create();
            BasicStroke dashed = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
            g2d.setStroke(dashed);
            g2d.drawLine((int)drawA.getX(), (int)drawA.getY(), (int)drawB.getX(), (int)drawB.getY());
            g2d.dispose();
        } else {
            gr.drawLine((int)drawA.getX(), (int)drawA.getY(), (int)drawB.getX(), (int)drawB.getY());
        }
    }

    private void drawLine(Graphics2D gr, Point2D a, Point2D b) {
        Point2D drawA = this.convert(a);
        Point2D drawB = this.convert(b);
        gr.drawLine((int)drawA.getX(), (int)drawA.getY(), (int)drawB.getX(), (int)drawB.getY());
    }

    private void drawILinks(Graphics2D gr, List<InterferenceLinkResult> iLinks) {
        for (InterferenceLinkResult iLink : iLinks) {
            this.drawLine(gr, iLink.getInterferingSystemLink().txAntenna().getPosition(), iLink.getVictimSystemLink().rxAntenna().getPosition());
        }
    }

    private void drawPoint(Graphics2D gr, Point2D draw, Color color, boolean isSelected) {
        gr.setColor(color);
        this.draw(gr, draw, isSelected);
    }

    private void draw(Graphics2D gr, Point2D draw, boolean isSelected) {
        if (isSelected) {
            gr.fillOval((int)draw.getX() - (5 + this.selectedItemZoomFactor), (int)draw.getY() - (5 + this.selectedItemZoomFactor), 10 + this.selectedItemZoomFactor * 2, 10 + this.selectedItemZoomFactor * 2);
        } else {
            gr.fillOval((int)draw.getX() - 3, (int)draw.getY() - 3, 6, 6);
        }
    }

    private Point2D convert(Point2D point) {
        double userX = point.getX();
        double userY = -point.getY();
        userX *= this.scaleFactor;
        userY *= this.scaleFactor;
        return new Point2D(userX += (double)this.focusShiftX, userY += (double)this.focusShiftY);
    }

    private void drawHorizontal(boolean main, Graphics2D gr, HorizontalVerticalInput input, double radius, double extX, double extY) {
        OptionalValue<Function> horizontal = input.horizontal();
        if (horizontal.isRelevant()) {
            ArrayList<Point2D> points = new ArrayList<Point2D>(horizontal.getValue().getPoints());
            double antennadirection = 0.0;
            double antennaAzimuth = 0.0;
            Collections.sort(points, Point2D.Y_COMPARATOR);
            double min = ((Point2D)points.get(0)).getY();
            double max = ((Point2D)points.get(points.size() - 1)).getY();
            Collections.sort(points, Point2D.X_COMPARATOR);
            double diff = Math.abs(max - min);
            int[] xPatternPoints = new int[points.size()];
            int[] yPatternPoints = new int[points.size()];
            gr.setColor(Color.RED);
            for (int z = 0; z < points.size(); ++z) {
                Point2D po1 = (Point2D)points.get(z);
                double distFactor = radius * (radius - radius / diff * Math.abs(po1.getY())) / radius;
                int p1 = (int)(Mathematics.cosD(((Point2D)points.get(z)).getX() + antennaAzimuth + antennadirection) * distFactor + extX);
                int p2 = (int)(-(Mathematics.sinD(((Point2D)points.get(z)).getX() + antennaAzimuth + antennadirection) * distFactor) + extY);
                xPatternPoints[z] = p1;
                yPatternPoints[z] = p2;
            }
            if (main) {
                gr.setPaint(new RadialGradientPaint(new Point2D.Double(extX, extY), new Float(radius).floatValue(), new float[]{0.0f, 1.0f}, new Color[]{Color.RED, this.patternColor.brighter()}, MultipleGradientPaint.CycleMethod.NO_CYCLE));
                gr.fillPolygon(xPatternPoints, yPatternPoints, xPatternPoints.length);
                gr.setColor(Color.RED);
                gr.drawPolygon(xPatternPoints, yPatternPoints, xPatternPoints.length);
            } else {
                gr.setColor(this.patternColor);
                gr.fillPolygon(xPatternPoints, yPatternPoints, xPatternPoints.length);
                gr.setColor(Color.RED);
                gr.drawPolygon(xPatternPoints, yPatternPoints, xPatternPoints.length);
            }
        }
    }

    public void resetView() {
        PropertySetter.createAnimator(2000, (Object)this, "focusShiftX", this.getFocusShiftX(), 0).start();
        PropertySetter.createAnimator(2000, (Object)this, "focusShiftY", this.getFocusShiftY(), 0).start();
        PropertySetter.createAnimator(2000, (Object)this, "zoomFactor", this.getZoomFactor(), 1.0).start();
    }

    private LinkResultPlot getPointAtCoordinate(Point2D p) {
        for (Map.Entry<Point2D, LinkResultPlot> entry : this.proximityMap.entrySet()) {
            if (!this.isClose(p, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private boolean isClose(Point2D p, Point2D p2) {
        return Mathematics.distance(p, p2) < 3.0;
    }

    private List<LinkResultPlot> getGroup(LinkResultPlot selected) {
        if (selected == null) {
            return Collections.emptyList();
        }
        return this.data.getAdjacentLinks(selected);
    }

    private void addValue(StringBuilder sb, VectorDef def, double value) {
        this.addValue(sb, def.name(), def.unit(), value);
    }

    private void addValue(StringBuilder sb, String name, String unit, double value) {
        sb.append("<li>");
        sb.append(name);
        sb.append(": ");
        sb.append(format.format(value));
        if (unit != null && !unit.isEmpty()) {
            sb.append(" ");
            sb.append(unit);
        }
        sb.append("</li>");
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Dimension dim = this.getSize();
        double w = dim.getWidth() / 2.0;
        double h = dim.getHeight() / 2.0;
        Point2D screenPoint = new Point2D((double)e.getX() - w, (double)e.getY() - h);
        LinkResultPlot newSelection = this.getPointAtCoordinate(screenPoint);
        if (newSelection != null) {
            LinkResult linkResult = newSelection.getLinkResult();
            if (linkResult.getValue(InterferenceSimulationEngine.RX_NOT_SIMULATED) == null && this.isClose(screenPoint, this.convert(linkResult.rxAntenna().getPosition()))) {
                newSelection.rxSelected();
            }
            if (linkResult.getValue(InterferenceSimulationEngine.TX_NOT_SIMULATED) == null && this.isClose(screenPoint, this.convert(linkResult.txAntenna().getPosition()))) {
                newSelection.txSelected();
            }
        }
        if (this.detailPanel != null) {
            this.detailPanel.showConnectingPoints(newSelection, true);
        }
        this.multiConnect();
        this.select(newSelection);
    }

    public void select(LinkResultPlot selected) {
        if (this.selected != null && this.selected != selected) {
            this.selected.deSelect();
        }
        if (this.animator != null) {
            this.animator.cancel();
            this.animator = null;
        }
        this.selected = selected;
        if (selected != null) {
            // empty if block
        }
        this.repaint();
    }

    public void singleSelect(SecondPointSelection secondSelect) {
        this.onlyLinkSelected = true;
        this.linkSelected = secondSelect;
        this.select(this.selected);
    }

    public void multiConnect() {
        this.onlyLinkSelected = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX() - this.offsetX;
        int y = e.getY() - this.offsetY;
        this.setFocusShiftX(x);
        this.setFocusShiftY(y);
        this.repaint();
        this.offsetX = e.getX();
        this.offsetY = e.getY();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.offsetX = e.getX();
        this.offsetY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollType() == 0) {
            this.adjustZoom(e.getUnitsToScroll());
            this.repaint();
        }
    }

    public SelectionsCallback getCallback() {
        return this.cb;
    }

    static /* synthetic */ boolean[] access$102(ScenarioEventResultPlot x0, boolean[] x1) {
        x0.isChecked = x1;
        return x1;
    }
}

