/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.simulationview.results;

import java.util.List;
import java.util.Map;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.IntegerResultType;
import org.seamcat.model.types.result.LongResultType;
import org.seamcat.model.types.result.StringResultType;

public class SecondPointSelection {
    private String pointName;
    private final Point2D txP;
    private final Point2D rxP;
    private LinkResult linkResult;
    private InterferenceLinkResult iLink;

    public SecondPointSelection(String pointName, LinkResult link, Point2D txP, Point2D rxP) {
        this.pointName = pointName;
        this.txP = txP;
        this.rxP = rxP;
        this.linkResult = link;
    }

    public SecondPointSelection(String pointName, InterferenceLinkResult link, Point2D txP, Point2D rxP) {
        this.pointName = pointName;
        this.txP = txP;
        this.rxP = rxP;
        this.iLink = link;
    }

    public LinkResult getIfSystemLink() {
        return this.linkResult;
    }

    public Point2D getTxP() {
        return this.txP;
    }

    public Point2D getRxP() {
        return this.rxP;
    }

    public void writeValues(List<Object> values) {
        values.add(new StringResultType(Factory.results().single("Tx->Rx", "Path"), this.txP + " -> " + this.rxP));
        if (this.linkResult != null) {
            values.add(new DoubleResultType(Factory.results().single("Distance", "km"), this.linkResult.getTxRxDistance()));
            this.addAntenna("Tx", values, this.linkResult.txAntenna());
            this.addAntenna("Rx", values, this.linkResult.rxAntenna());
            this.addLinkResults(values, this.linkResult);
        } else {
            values.add(new DoubleResultType(Factory.results().single("Distance", "km"), this.iLink.getTxRxDistance()));
            this.addAntenna("Tx", values, this.iLink.txAntenna());
            this.addAntenna("Rx", values, this.iLink.rxAntenna());
            this.addLinkResults(values, this.iLink);
            Interferer interferer = this.iLink.getInterferer();
            values.add(new DoubleResultType(Factory.results().single("Minimum coupling loss", "dB"), interferer.getMinimumCouplingLoss()));
        }
    }

    private void addAntenna(String prefix, List<Object> values, AntennaResult a) {
        values.add(new DoubleResultType(Factory.results().single(prefix + " Antenna height", "m"), a.getHeight()));
        values.add(new DoubleResultType(Factory.results().single(prefix + " Azimuth angle", "degree"), a.getAzimuth()));
        values.add(new DoubleResultType(Factory.results().single(prefix + " Azimuth compensation", "degree"), a.getAzimuthCompensation()));
        values.add(new DoubleResultType(Factory.results().single(prefix + " Elevation angle", "degree"), a.getElevation()));
        values.add(new DoubleResultType(Factory.results().single(prefix + " Elevation compensation", "degree"), a.getElevationCompensation()));
        values.add(new DoubleResultType(Factory.results().single(prefix + " Tilt angle", "degree"), a.getTilt()));
        values.add(new DoubleResultType(Factory.results().single(prefix + " Panel Offset Azimuth", "degree"), a.getRandomPanelOffsetAzimuth()));
        values.add(new DoubleResultType(Factory.results().single(prefix + " Panel Offset Elevation", "degree"), a.getRandomPanelOffsetElevation()));
        values.add(new DoubleResultType(Factory.results().single(prefix + " Gain", "dBi"), a.getGain()));
    }

    private void addLinkResults(List<Object> values, LinkResult link) {
        for (Map.Entry<UniqueValueDef, Double> entry : link.getDoubleValues().entrySet()) {
            values.add(new DoubleResultType(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<UniqueValueDef, Number> entry : link.getIntValues().entrySet()) {
            values.add(new IntegerResultType(entry.getKey(), (Integer)entry.getValue()));
        }
        for (Map.Entry<UniqueValueDef, Number> entry : link.getLongValues().entrySet()) {
            values.add(new LongResultType(entry.getKey(), (Long)entry.getValue()));
        }
        for (Map.Entry<UniqueValueDef, Object> entry : link.getStringValues().entrySet()) {
            values.add(new StringResultType(entry.getKey(), (String)entry.getValue()));
        }
    }

    public String toString() {
        return this.pointName;
    }
}

