/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.components.ScrollingBorderPanel;
import org.seamcat.presentation.systems.CellularPosition;
import org.seamcat.presentation.systems.CellularPositionHolder;
import org.seamcat.presentation.systems.DMAPositioningSystemPanel;
import org.seamcat.presentation.systems.ReferenceCellSelectionPanel;
import org.seamcat.presentation.systems.SystemLayoutPanel;

public class CellularPositionPanel
extends JPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private final ReferenceCellSelectionPanel referenceCellSelectionPanel;
    private final DMAPositioningSystemPanel systemPanel;
    private final SystemLayoutPanel systemLayoutPanel;

    public CellularPositionPanel(boolean ofdma, CellularPosition model) {
        super(new BorderLayout());
        JSplitPane leftSplit = new JSplitPane(0);
        JSplitPane container = new JSplitPane(1);
        Refresher refresher = new Refresher();
        this.systemPanel = new DMAPositioningSystemPanel(refresher);
        boolean entireEnable = true;
        if (ofdma) {
            entireEnable = false;
        }
        this.systemLayoutPanel = new SystemLayoutPanel(entireEnable, refresher);
        this.referenceCellSelectionPanel = new ReferenceCellSelectionPanel();
        CellularPositionHolder uiModel = new CellularPositionHolder();
        uiModel.setCellularPosition(model);
        this.systemPanel.setModel(uiModel);
        this.systemLayoutPanel.setModel(uiModel);
        this.referenceCellSelectionPanel.setModel(uiModel);
        leftSplit.add(new ScrollingBorderPanel(this.systemPanel, "System", "System help", "http://confluence.seamcat.org/display/SH/7.5.1+System"));
        leftSplit.setDividerLocation(250);
        leftSplit.add(new ScrollingBorderPanel(this.systemLayoutPanel, "System Layout - reference cell selection", "System layout help", "http://confluence.seamcat.org/pages/viewpage.action?pageId=1409483", STRINGLIST.getString("CDMA_REFERENCE_NOTE")));
        container.add(leftSplit);
        container.setDividerLocation(390);
        container.add(new BorderPanel(this.referenceCellSelectionPanel, "System Layout preview", "System layout preview help", "http://confluence.seamcat.org/display/SH/7.5.3+System+layout+preview"));
        this.add((Component)container, "Center");
        this.refreshFromModel();
    }

    private void updateModel() {
        this.systemPanel.updateModel();
        this.systemLayoutPanel.updateModel();
    }

    public CellularPosition getModel() {
        this.updateModel();
        return this.systemPanel.getModel().getCellularPosition();
    }

    private void refreshFromModel() {
        this.systemPanel.refreshFromModel();
        this.systemLayoutPanel.refreshFromModel();
        this.referenceCellSelectionPanel.refreshFromModel();
    }

    public class Refresher {
        void refresh() {
            CellularPositionPanel.this.refreshFromModel();
        }
    }
}

