/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.presentation.systems.CellUI;
import org.seamcat.presentation.systems.CellularPosition;
import org.seamcat.presentation.systems.CellularPositionHolder;
import org.seamcat.simulation.cellular.GridPositionCalculator;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class ReferenceCellSelector
extends JPanel
implements MouseMotionListener,
MouseListener {
    private CellularPositionHolder model;
    private double center_translateX;
    private double center_translateY;
    private Color defaultCellColor = Color.BLUE;
    private CellUI mouseOverCell;
    private List<CellUI> mouseOverCells = new ArrayList<CellUI>();
    private Color mouseOverColor = new Color(107, 232, 57);
    private boolean plotCenterCross = false;
    private boolean plotWrapAround = true;
    private double scaleFactor;
    private Color outsideNetworkColor = new Color(145, 145, 145);
    private Color selectedCellColor = new Color(255, 53, 53);
    private Color activeClusterBackgroundColor = new Color(125, 183, 255);
    private Stroke activeClusterStroke = new BasicStroke(2.0f);
    private Color textColor = Color.BLACK;
    private Stroke wrapAroundStroke = new BasicStroke(1.0f);
    private double translateX;
    private double translateY;
    private Map<Polygon, CellUI> centerSystem = new HashMap<Polygon, CellUI>();
    private Map<CellUI, CellUI[]> sectorCellMap = new HashMap<CellUI, CellUI[]>();
    private int centerTranslateX;
    int centerTranslateY;
    private CellUI[][] cells;

    public ReferenceCellSelector() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.model == null || this.mouseOverCell == null || this.cells == null) {
            return;
        }
        for (int i = 0; i < this.cells.length; ++i) {
            for (int k = 0; k < this.cells[i].length; ++k) {
                CellUI c = this.cells[i][k];
                if (c != this.mouseOverCell) continue;
                CellularPosition prototype = Factory.prototype(CellularPosition.class, this.model.getCellularPosition());
                Factory.when(prototype.referenceCellId()).thenReturn(i);
                Factory.when(prototype.referenceSector()).thenReturn(k);
                this.model.setCellularPosition(Factory.build(prototype));
                this.repaint();
                return;
            }
        }
    }

    private CellUI overCell(int x, int y) {
        for (Map.Entry<Polygon, CellUI> entry : this.centerSystem.entrySet()) {
            if (!entry.getKey().contains(x, y)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.model == null) {
            return;
        }
        this.mouseOverCell = this.overCell(e.getX() - this.centerTranslateX, e.getY() - this.centerTranslateY);
        if (this.mouseOverCell != null) {
            this.mouseOverCells = Arrays.asList((Object[])this.sectorCellMap.get(this.mouseOverCell));
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static double getInterCellDistance(HybridSystemPlugin.SectorSetup setup, double radius) {
        double interCellDistance = 0.0;
        interCellDistance = setup != HybridSystemPlugin.SectorSetup.TriSector3GPP ? radius * Mathematics.SQRT3 : radius * 3.0;
        return interCellDistance;
    }

    public static double getInterCellDistance(CellularPosition model) {
        return ReferenceCellSelector.getInterCellDistance(model.sectorType(), model.cellRadius());
    }

    @Override
    public void paintComponent(Graphics _gr) {
        double scaleFactorW;
        double scaleFactorH;
        super.paintComponent(_gr);
        Graphics2D gr = (Graphics2D)_gr;
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gr.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        Dimension dim = this.getSize();
        this.centerSystem.clear();
        if (this.model == null) {
            this.model = new CellularPositionHolder();
        }
        double dist = ReferenceCellSelector.getInterCellDistance(this.model.getCellularPosition());
        if (this.plotWrapAround) {
            scaleFactorH = dim.getHeight() / (15.0 * dist);
            scaleFactorW = dim.getWidth() / (6.0 * dist);
        } else {
            scaleFactorH = dim.getHeight() / (6.0 * dist);
            scaleFactorW = dim.getWidth() / (6.0 * dist);
        }
        this.scaleFactor = Math.min(scaleFactorH, scaleFactorW);
        this.translateX = dim.getWidth() / 2.0;
        this.translateY = dim.getHeight() / 2.0;
        this.center_translateX = dim.getWidth() / 2.0;
        this.center_translateY = dim.getHeight() / 2.0;
        HybridSystemPlugin.SystemLayout layout = this.model.getCellularPosition().layout();
        double radius = this.scaleFactor * this.model.getCellularPosition().cellRadius();
        double angle = 60.0;
        double d = 0.0;
        d = this.model.getCellularPosition().sectorType().equals((Object)HybridSystemPlugin.SectorSetup.TriSector3GPP) ? radius * 3.0 : radius * Mathematics.SQRT3;
        int systemsToPlot = 1;
        if (this.plotWrapAround) {
            systemsToPlot = 7;
        }
        if (this.plotCenterCross) {
            gr.setColor(Color.BLACK);
            gr.drawLine(0, (int)this.center_translateY, (int)dim.getWidth(), (int)this.center_translateY);
            gr.drawLine((int)this.center_translateX, 0, (int)this.center_translateX, (int)dim.getHeight());
        }
        gr.translate((int)this.translateX, (int)this.translateY);
        this.centerTranslateX = (int)this.translateX;
        this.centerTranslateY = (int)this.translateY;
        CellUI selectedCell = this.cells[this.model.getCellularPosition().referenceCellId()][this.model.getCellularPosition().referenceSector()];
        List<Object> selected = Arrays.asList((Object[])this.sectorCellMap.get(selectedCell));
        Color cellColor = this.defaultCellColor;
        if (!this.model.getCellularPosition().sectorType().equals((Object)HybridSystemPlugin.SectorSetup.TriSector3GPP)) {
            for (int systemID = systemsToPlot - 1; systemID >= 0; --systemID) {
                this.translateX = 0.0;
                this.translateY = 0.0;
                cellColor = this.defaultCellColor;
                switch (systemID) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (layout == HybridSystemPlugin.SystemLayout.RightHandSideOfNetworkEdge) {
                            cellColor = this.outsideNetworkColor;
                        }
                        this.translateX += 4.5 * d / Mathematics.SQRT3;
                        this.translateY -= -3.5 * d;
                        break;
                    }
                    case 2: {
                        if (layout == HybridSystemPlugin.SystemLayout.RightHandSideOfNetworkEdge) {
                            cellColor = this.outsideNetworkColor;
                        }
                        this.translateX += 3.0 * d / Mathematics.SQRT3 * 2.0 + 1.5 * d / Mathematics.SQRT3;
                        this.translateY -= d / 2.0;
                        break;
                    }
                    case 3: {
                        if (layout == HybridSystemPlugin.SystemLayout.RightHandSideOfNetworkEdge) {
                            cellColor = this.outsideNetworkColor;
                        }
                        this.translateX += 3.0 * d / Mathematics.SQRT3;
                        this.translateY -= 4.0 * d;
                        break;
                    }
                    case 4: {
                        if (layout == HybridSystemPlugin.SystemLayout.LeftHandSideOfNetworkEdge) {
                            cellColor = this.outsideNetworkColor;
                        }
                        this.translateX += -1.5 * d / Mathematics.SQRT3 + -3.0 * d / Mathematics.SQRT3;
                        this.translateY -= 2.0 * d + 1.5 * d;
                        break;
                    }
                    case 5: {
                        if (layout == HybridSystemPlugin.SystemLayout.LeftHandSideOfNetworkEdge) {
                            cellColor = this.outsideNetworkColor;
                        }
                        this.translateX += -1.5 * d / Mathematics.SQRT3 + -3.0 * d / Mathematics.SQRT3 * 2.0;
                        this.translateY -= -d / 2.0;
                        break;
                    }
                    case 6: {
                        if (layout == HybridSystemPlugin.SystemLayout.LeftHandSideOfNetworkEdge) {
                            cellColor = this.outsideNetworkColor;
                        }
                        this.translateX += -3.0 * d / Mathematics.SQRT3;
                        this.translateY -= -4.0 * d;
                    }
                }
                if (this.cells == null) continue;
                for (int i = 0; i < this.cells.length; ++i) {
                    for (int k = 0; k < this.cells[i].length; ++k) {
                        int zz;
                        int[] yP;
                        int j;
                        double cellX = this.cells[i][k].getPosition().getX();
                        double cellY = this.cells[i][k].getPosition().getY() * -1.0;
                        cellX *= this.scaleFactor;
                        cellY *= this.scaleFactor;
                        cellX += this.translateX;
                        cellY += this.translateY;
                        int[] xPoints = new int[6];
                        int[] yPoints = new int[6];
                        for (j = 0; j < 6; ++j) {
                            xPoints[j] = (int)(Mathematics.cosD((double)j * angle) * radius + cellX);
                            yPoints[j] = (int)(Mathematics.sinD((double)j * angle) * radius + cellY);
                        }
                        gr.setColor(cellColor);
                        if (systemID == 0) {
                            gr.setStroke(this.activeClusterStroke);
                            if (this.model.getCellularPosition().sectorType() == HybridSystemPlugin.SectorSetup.TriSector3GPP2) {
                                if (k == 0) {
                                    int[] x1 = new int[4];
                                    int[] y1 = new int[4];
                                    x1[0] = xPoints[0];
                                    x1[1] = xPoints[1];
                                    x1[2] = xPoints[2];
                                    x1[3] = (int)cellX;
                                    y1[0] = yPoints[0];
                                    y1[1] = yPoints[1];
                                    y1[2] = yPoints[2];
                                    y1[3] = (int)cellY;
                                    this.centerSystem.put(new Polygon(x1, y1, x1.length), this.cells[i][2]);
                                    x1 = new int[4];
                                    y1 = new int[4];
                                    x1[0] = xPoints[2];
                                    x1[1] = xPoints[3];
                                    x1[2] = xPoints[4];
                                    x1[3] = (int)cellX;
                                    y1[0] = yPoints[2];
                                    y1[1] = yPoints[3];
                                    y1[2] = yPoints[4];
                                    y1[3] = (int)cellY;
                                    this.centerSystem.put(new Polygon(x1, y1, x1.length), this.cells[i][1]);
                                    x1 = new int[4];
                                    y1 = new int[4];
                                    x1[0] = xPoints[4];
                                    x1[1] = xPoints[5];
                                    x1[2] = xPoints[0];
                                    x1[3] = (int)cellX;
                                    y1[0] = yPoints[4];
                                    y1[1] = yPoints[5];
                                    y1[2] = yPoints[0];
                                    y1[3] = (int)cellY;
                                    this.centerSystem.put(new Polygon(x1, y1, x1.length), this.cells[i][0]);
                                }
                            } else {
                                this.centerSystem.put(new Polygon(xPoints, yPoints, xPoints.length), this.cells[i][k]);
                            }
                        } else {
                            gr.setStroke(this.wrapAroundStroke);
                        }
                        for (j = 0; j < 6; ++j) {
                            gr.drawLine(xPoints[j], yPoints[j], (int)(Mathematics.cosD((double)(j + 1) * angle) * radius + cellX), (int)(Mathematics.sinD((double)(j + 1) * angle) * radius + cellY));
                            if (this.model.getCellularPosition().sectorType().equals((Object)HybridSystemPlugin.SectorSetup.SingleSector) || j % 2 != 0) continue;
                            gr.drawLine((int)(Mathematics.cosD((double)j * angle) * radius + cellX), (int)(Mathematics.sinD((double)j * angle) * radius + cellY), (int)cellX, (int)cellY);
                        }
                        if (systemID == 0 && k == 0 && this.plotWrapAround) {
                            gr.setColor(this.activeClusterBackgroundColor);
                            gr.fillPolygon(xPoints, yPoints, xPoints.length);
                        }
                        if (systemID == 0 && this.mouseOverCells.contains(this.cells[i][k])) {
                            gr.setColor(this.mouseOverColor);
                            if (!this.model.getCellularPosition().sectorType().equals((Object)HybridSystemPlugin.SectorSetup.SingleSector)) {
                                int[] xP = new int[4];
                                yP = new int[4];
                                xP[0] = (int)cellX;
                                yP[0] = (int)cellY;
                                switch (k) {
                                    case 2: {
                                        for (zz = 0; zz < 3; ++zz) {
                                            xP[zz + 1] = xPoints[zz];
                                            yP[zz + 1] = yPoints[zz];
                                        }
                                        break;
                                    }
                                    case 1: {
                                        for (zz = 2; zz < 5; ++zz) {
                                            xP[zz - 1] = xPoints[zz];
                                            yP[zz - 1] = yPoints[zz];
                                        }
                                        break;
                                    }
                                    case 0: {
                                        for (zz = 4; zz < 6; ++zz) {
                                            xP[zz - 3] = xPoints[zz];
                                            yP[zz - 3] = yPoints[zz];
                                        }
                                        xP[3] = xPoints[0];
                                        yP[3] = yPoints[0];
                                    }
                                }
                                gr.fillPolygon(xP, yP, xP.length);
                            } else {
                                gr.fillPolygon(xPoints, yPoints, xPoints.length);
                            }
                        }
                        if (systemID == 0 && selected.contains(this.cells[i][k])) {
                            gr.setColor(this.selectedCellColor);
                            if (!this.model.getCellularPosition().sectorType().equals((Object)HybridSystemPlugin.SectorSetup.SingleSector)) {
                                int[] xP = new int[4];
                                yP = new int[4];
                                xP[0] = (int)cellX;
                                yP[0] = (int)cellY;
                                switch (k) {
                                    case 2: {
                                        for (zz = 0; zz < 3; ++zz) {
                                            xP[zz + 1] = xPoints[zz];
                                            yP[zz + 1] = yPoints[zz];
                                        }
                                        break;
                                    }
                                    case 1: {
                                        for (zz = 2; zz < 5; ++zz) {
                                            xP[zz - 1] = xPoints[zz];
                                            yP[zz - 1] = yPoints[zz];
                                        }
                                        break;
                                    }
                                    case 0: {
                                        for (zz = 4; zz < 6; ++zz) {
                                            xP[zz - 3] = xPoints[zz];
                                            yP[zz - 3] = yPoints[zz];
                                        }
                                        xP[3] = xPoints[0];
                                        yP[3] = yPoints[0];
                                    }
                                }
                                gr.fillPolygon(xP, yP, xP.length);
                            } else {
                                gr.fillPolygon(xPoints, yPoints, xPoints.length);
                            }
                        }
                        gr.setColor(this.textColor);
                        if (systemID != 0 || this.plotWrapAround) continue;
                        gr.drawString("#" + i, (int)cellX, (int)cellY - 1);
                    }
                }
            }
        } else {
            for (int systemID = systemsToPlot - 1; systemID >= 0; --systemID) {
                this.translateX = 0.0;
                this.translateY = 0.0;
                cellColor = this.defaultCellColor;
                switch (systemID) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (layout == HybridSystemPlugin.SystemLayout.RightHandSideOfNetworkEdge) {
                            cellColor = this.outsideNetworkColor;
                        }
                        this.translateX += 3.5 * d;
                        this.translateY -= 3.0 * d * Mathematics.SQRT3 / 2.0;
                        break;
                    }
                    case 2: {
                        if (layout == HybridSystemPlugin.SystemLayout.LeftHandSideOfNetworkEdge) {
                            cellColor = this.outsideNetworkColor;
                        }
                        this.translateX += -d / 2.0;
                        this.translateY -= 5.0 * d * Mathematics.SQRT3 / 2.0;
                        break;
                    }
                    case 3: {
                        if (layout == HybridSystemPlugin.SystemLayout.LeftHandSideOfNetworkEdge) {
                            cellColor = this.outsideNetworkColor;
                        }
                        this.translateX -= 4.0 * d;
                        this.translateY -= d * Mathematics.SQRT3;
                        break;
                    }
                    case 4: {
                        if (layout == HybridSystemPlugin.SystemLayout.LeftHandSideOfNetworkEdge) {
                            cellColor = this.outsideNetworkColor;
                        }
                        this.translateX -= 3.5 * d;
                        this.translateY += d * 3.0 * Mathematics.SQRT3 / 2.0;
                        break;
                    }
                    case 5: {
                        if (layout == HybridSystemPlugin.SystemLayout.RightHandSideOfNetworkEdge) {
                            cellColor = this.outsideNetworkColor;
                        }
                        this.translateX += d / 2.0;
                        this.translateY += 5.0 * d * Mathematics.SQRT3 / 2.0;
                        break;
                    }
                    case 6: {
                        if (layout == HybridSystemPlugin.SystemLayout.RightHandSideOfNetworkEdge) {
                            cellColor = this.outsideNetworkColor;
                        }
                        this.translateX += 4.0 * d;
                        this.translateY += d * Mathematics.SQRT3;
                    }
                }
                if (this.cells == null) continue;
                double[] shiftX = new double[]{radius, -radius * Mathematics.cosD(angle), -radius * Mathematics.cosD(angle)};
                double[] shiftY = new double[]{0.0, -radius * Mathematics.sinD(angle), radius * Mathematics.sinD(angle)};
                for (int i = 0; i < this.cells.length; ++i) {
                    for (int k = 0; k < this.cells[i].length; ++k) {
                        int j;
                        double cellX = this.cells[i][k].getPosition().getX();
                        double cellY = this.cells[i][k].getPosition().getY() * -1.0;
                        cellX *= this.scaleFactor;
                        cellY *= this.scaleFactor;
                        cellX += this.translateX;
                        cellY += this.translateY;
                        int[] xPoints = new int[6];
                        int[] yPoints = new int[6];
                        for (j = 0; j < 6; ++j) {
                            xPoints[j] = (int)(Mathematics.cosD((double)j * angle) * radius + cellX + shiftX[k]);
                            yPoints[j] = (int)(Mathematics.sinD((double)j * angle) * radius + cellY + shiftY[k]);
                        }
                        gr.setColor(cellColor);
                        if (systemID == 0) {
                            gr.setStroke(this.activeClusterStroke);
                            this.centerSystem.put(new Polygon(xPoints, yPoints, xPoints.length), this.cells[i][k]);
                        } else {
                            gr.setStroke(this.wrapAroundStroke);
                        }
                        for (j = 0; j < 6; ++j) {
                            int X = (int)(Mathematics.cosD((double)(j + 1) * angle) * radius + cellX + shiftX[k]);
                            int Y = (int)(Mathematics.sinD((double)(j + 1) * angle) * radius + cellY + shiftY[k]);
                            gr.drawLine(xPoints[j], yPoints[j], X, Y);
                        }
                        if (systemID == 0 && this.plotWrapAround) {
                            gr.setColor(this.activeClusterBackgroundColor);
                            gr.fillPolygon(xPoints, yPoints, xPoints.length);
                        }
                        if (systemID == 0 && this.mouseOverCells.contains(this.cells[i][k])) {
                            gr.setColor(this.mouseOverColor);
                            gr.fillPolygon(xPoints, yPoints, xPoints.length);
                        }
                        if (systemID == 0 && selected.contains(this.cells[i][k])) {
                            gr.setColor(this.selectedCellColor);
                            gr.fillPolygon(xPoints, yPoints, xPoints.length);
                        }
                        gr.setColor(this.textColor);
                        if (systemID != 0 || this.plotWrapAround) continue;
                        gr.drawString("#" + i, (int)cellX, (int)cellY - 1);
                    }
                }
            }
        }
    }

    public void setPlotWrapAround(boolean plotWrapAround) {
        this.plotWrapAround = plotWrapAround;
        this.repaint();
    }

    public void generateCells() {
        CellularPosition position = this.model.getCellularPosition();
        CellUI[][] cellUIArray = this.cells = ReferenceCellSelector.generateCells(this.getNumberOfCellSitesInPowerControlCluster(), position.sectorType(), position.cellRadius());
        int n = cellUIArray.length;
        for (int i = 0; i < n; ++i) {
            CellUI[] cell;
            for (CellUI cellUI : cell = cellUIArray[i]) {
                this.sectorCellMap.put(cellUI, cell);
            }
        }
    }

    public static CellUI[][] generateCells(int bs, HybridSystemPlugin.SectorSetup setup, double radius) {
        int sectors = setup == HybridSystemPlugin.SectorSetup.SingleSector ? 1 : 3;
        CellUI[][] cells = new CellUI[bs][sectors];
        for (int i1 = 0; i1 < cells.length; ++i1) {
            for (int i = 0; i < cells[i1].length; ++i) {
                cells[i1][i] = new CellUI();
            }
        }
        double dist = ReferenceCellSelector.getInterCellDistance(setup, radius);
        Point2D p = new Point2D();
        for (int j = 0; j < cells.length; ++j) {
            for (int i = 0; i < cells[0].length; ++i) {
                if (setup == HybridSystemPlugin.SectorSetup.TriSector3GPP) {
                    cells[j][i].setPosition(GridPositionCalculator.standard(j, p, dist), dist);
                    continue;
                }
                cells[j][i].setPosition(GridPositionCalculator.ppg2(j, p, dist), dist);
            }
        }
        return cells;
    }

    private int getNumberOfCellSitesInPowerControlCluster() {
        switch (this.model.getCellularPosition().tiers()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 7;
            }
        }
        return 19;
    }

    public CellularPositionHolder getModel() {
        return this.model;
    }

    public void setModel(CellularPositionHolder model) {
        this.model = model;
    }
}

