/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.seamcat.model.factory.Factory;
import org.seamcat.presentation.layout.VerticalSubPanelLayoutManager;
import org.seamcat.presentation.systems.CellularPosition;
import org.seamcat.presentation.systems.CellularPositionHolder;
import org.seamcat.presentation.systems.CellularPositionPanel;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class SystemLayoutPanel
extends JPanel {
    private JRadioButton center = new JRadioButton("Center of \"infinite\" network");
    private JRadioButton left = new JRadioButton("Left hand side of network edge");
    private JRadioButton right = new JRadioButton("Right hand side of network edge");
    private JCheckBox interferenceFromCluster = new JCheckBox("Measure Interference from entire cluster");
    private JCheckBox plotWrapAround = new JCheckBox("Generate Wrap-Around");
    private Box innerPanel;
    private boolean entireEnable;
    private CellularPositionPanel.Refresher refresher;
    private CellularPositionHolder cellularPositionHolder;

    public SystemLayoutPanel(boolean entireEnable, CellularPositionPanel.Refresher refresher) {
        this.entireEnable = entireEnable;
        this.refresher = refresher;
        this.initializeWidgets();
        this.setLayout(new VerticalSubPanelLayoutManager());
        this.add(this.innerPanel);
    }

    public void setModel(CellularPositionHolder cellularPositionHolder) {
        this.cellularPositionHolder = cellularPositionHolder;
        this.refreshFromModel();
    }

    public CellularPositionHolder getModel() {
        return this.cellularPositionHolder;
    }

    public void initializeWidgets() {
        this.innerPanel = Box.createVerticalBox();
        ButtonGroup networkEdgeButtons = new ButtonGroup();
        networkEdgeButtons.add(this.center);
        networkEdgeButtons.add(this.left);
        networkEdgeButtons.add(this.right);
        this.innerPanel.add(this.center);
        this.innerPanel.add(this.left);
        this.innerPanel.add(this.right);
        this.innerPanel.add(Box.createVerticalStrut(20));
        this.innerPanel.add(this.interferenceFromCluster);
        this.innerPanel.add(this.plotWrapAround);
        for (Component c : this.innerPanel.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            ((JComponent)c).setAlignmentX(0.0f);
        }
        this.center.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SystemLayoutPanel.this.center.isSelected()) {
                    SystemLayoutPanel.this.localUpdate();
                    SystemLayoutPanel.this.updateModel();
                }
            }
        });
        this.left.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SystemLayoutPanel.this.left.isSelected()) {
                    SystemLayoutPanel.this.localUpdate();
                    SystemLayoutPanel.this.updateModel();
                }
            }
        });
        this.right.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SystemLayoutPanel.this.right.isSelected()) {
                    SystemLayoutPanel.this.localUpdate();
                    SystemLayoutPanel.this.updateModel();
                }
            }
        });
        this.plotWrapAround.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SystemLayoutPanel.this.updateModel();
            }
        });
        if (!this.entireEnable) {
            this.interferenceFromCluster.setVisible(false);
        } else {
            this.interferenceFromCluster.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SystemLayoutPanel.this.updateModel();
                }
            });
        }
    }

    public void refreshFromModel() {
        CellularPosition model = this.getModel().getCellularPosition();
        if (model.tiers() != 2) {
            this.plotWrapAround.setSelected(false);
            this.plotWrapAround.setEnabled(false);
        } else {
            this.plotWrapAround.setEnabled(true);
            this.plotWrapAround.setSelected(model.generateWrapAround());
        }
        if (model.layout().equals((Object)HybridSystemPlugin.SystemLayout.CenterOfInfiniteNetwork)) {
            this.center.setSelected(true);
        } else if (model.layout().equals((Object)HybridSystemPlugin.SystemLayout.LeftHandSideOfNetworkEdge)) {
            this.left.setSelected(true);
        } else {
            this.right.setSelected(true);
        }
        this.interferenceFromCluster.setEnabled(true);
        this.interferenceFromCluster.setSelected(model.measureFromEntireCluster());
    }

    private void localUpdate() {
        CellularPosition prototype = Factory.prototype(CellularPosition.class, this.getModel().getCellularPosition());
        if (this.center.isSelected()) {
            Factory.when(prototype.referenceSector()).thenReturn(0);
            Factory.when(prototype.referenceCellId()).thenReturn(0);
        } else {
            Factory.when(prototype.referenceSector()).thenReturn(0);
            switch (this.getModel().getCellularPosition().tiers()) {
                case 2: {
                    Factory.when(prototype.referenceCellId()).thenReturn(this.left.isSelected() ? 13 : 7);
                    break;
                }
                case 1: {
                    if (this.getModel().getCellularPosition().sectorType().equals((Object)HybridSystemPlugin.SectorSetup.TriSector3GPP)) {
                        Factory.when(prototype.referenceCellId()).thenReturn(this.left.isSelected() ? 4 : 1);
                        break;
                    }
                    Factory.when(prototype.referenceCellId()).thenReturn(this.left.isSelected() ? 3 : 1);
                    break;
                }
                default: {
                    Factory.when(prototype.referenceCellId()).thenReturn(0);
                }
            }
        }
        this.getModel().setCellularPosition(Factory.build(prototype));
    }

    public void updateModel() {
        CellularPosition prototype = Factory.prototype(CellularPosition.class, this.getModel().getCellularPosition());
        Factory.when(prototype.generateWrapAround()).thenReturn(this.plotWrapAround.isSelected());
        Factory.when(prototype.measureFromEntireCluster()).thenReturn(this.interferenceFromCluster.isSelected());
        if (this.center.isSelected()) {
            Factory.when(prototype.layout()).thenReturn(HybridSystemPlugin.SystemLayout.CenterOfInfiniteNetwork);
        } else {
            HybridSystemPlugin.SystemLayout layout = this.left.isSelected() ? HybridSystemPlugin.SystemLayout.LeftHandSideOfNetworkEdge : HybridSystemPlugin.SystemLayout.RightHandSideOfNetworkEdge;
            Factory.when(prototype.layout()).thenReturn(layout);
        }
        this.getModel().setCellularPosition(Factory.build(prototype));
        this.refresher.refresh();
    }
}

