/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class CDMAEditModel
implements TableModel {
    public static final String[] COLUMN_NAMES = new String[]{"Geometry*", "AWGN", "3 km/h", "30 km/h", "100 km/h"};
    private Vector<Vector<Double>> data;
    private final List<TableModelListener> tableModelListeners = new ArrayList<TableModelListener>();

    public void addRow() {
        Vector<Object> row = new Vector<Object>();
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        this.data.add(row);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (!this.tableModelListeners.contains(l)) {
            this.tableModelListeners.add(l);
        }
    }

    public void deleteRow(int index) {
        if (index > -1 && index < this.data.size()) {
            this.data.remove(index);
            this.fireChangeListeners(index, -1);
        }
    }

    public void fireChangeListeners(int row, int column, int type) {
        TableModelEvent tme = new TableModelEvent(this, row, row, column, type);
        for (TableModelListener listener : this.tableModelListeners) {
            listener.tableChanged(tme);
        }
    }

    public void fireChangeListeners(int row, int type) {
        TableModelEvent tme = new TableModelEvent(this, row, type);
        for (TableModelListener listener : this.tableModelListeners) {
            listener.tableChanged(tme);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data.get(rowIndex).get(columnIndex);
    }

    public XYSeriesCollection getXYSeriesCollection() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        int stop = this.getColumnCount();
        for (int x = 1; x < stop; ++x) {
            XYSeries series = new XYSeries((Comparable)((Object)COLUMN_NAMES[x]));
            int _stop = this.getRowCount();
            for (int y = 0; y < _stop; ++y) {
                if (this.getValueAt(y, x) == null || this.getValueAt(y, 0) == null) continue;
                double a = (Double)this.getValueAt(y, 0);
                double b = (Double)this.getValueAt(y, x);
                series.add(a, b);
            }
            dataset.addSeries(series);
        }
        return dataset;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    public void setData(Vector<Vector<Double>> vector) {
        this.data = vector;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Vector<Double> row = this.data.get(rowIndex);
        row.set(columnIndex, Double.valueOf(aValue.toString()));
        this.fireChangeListeners(rowIndex, columnIndex, 0);
    }
}

