/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.seamcat.presentation.systems.cdma.CDMAPlotModel;
import org.seamcat.presentation.systems.cdma.CDMASystemsComboBoxModel;
import org.seamcat.presentation.systems.cdma.DetailedSystemPlot;
import org.seamcat.presentation.systems.cdma.DrawingControlPanel;
import org.seamcat.presentation.systems.cdma.InspectSystemDetailsPanel;

public class CDMASystemPlotPanel
extends JPanel {
    private final DetailedSystemPlot cdmaplot;
    private final DrawingControlPanel controls;
    private final InspectSystemDetailsPanel infoPanel;
    private CDMASystemsComboBoxModel model;

    public CDMASystemPlotPanel(Map<String, CDMAPlotModel> model, int eventNumber) {
        super(new BorderLayout());
        this.model = new CDMASystemsComboBoxModel(model);
        this.cdmaplot = new DetailedSystemPlot();
        this.controls = new DrawingControlPanel(this.cdmaplot);
        this.infoPanel = new InspectSystemDetailsPanel(eventNumber);
        this.infoPanel.addSystemSelectionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actevent) {
                CDMAPlotModel model = (CDMAPlotModel)((JComboBox)actevent.getSource()).getSelectedItem();
                if (model != null) {
                    CDMASystemPlotPanel.this.cdmaplot.setModel(model);
                    CDMASystemPlotPanel.this.infoPanel.setDetailedSystemPlot(CDMASystemPlotPanel.this.cdmaplot);
                    CDMASystemPlotPanel.this.cdmaplot.repaint();
                }
            }
        });
        JSplitPane sp = new JSplitPane(1, this.cdmaplot, this.infoPanel);
        sp.setOneTouchExpandable(true);
        sp.setDividerLocation(800);
        this.add((Component)sp, "Center");
        this.add((Component)this.controls, "North");
    }

    public DetailedSystemPlot getPlot() {
        return this.cdmaplot;
    }

    public void reset() {
        this.cdmaplot.setModel(null);
        this.cdmaplot.repaint();
        this.infoPanel.reset();
    }

    public void setModel(CDMAPlotModel model) {
        this.cdmaplot.setModel(model);
        this.infoPanel.setDetailedSystemPlot(this.cdmaplot);
        this.controls.updateCheckBoxes();
    }

    public void refresh() {
        this.model.refresh();
        if (this.model.getSize() > 0) {
            this.setModel((CDMAPlotModel)this.model.getElementAt(0));
            this.infoPanel.setSystemSelectionModel(this.model);
        }
    }
}

