/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.ofdma.OfdmaMobile;
import org.seamcat.ofdma.OfdmaUplink;
import org.seamcat.presentation.systems.cdma.CDMAPlotModel;
import org.seamcat.simulation.hybrid.HybridCDMADownLinkPlugin;
import org.seamcat.simulation.hybrid.HybridCDMAUpLinkPlugin;
import org.seamcat.simulation.hybrid.HybridOFDMADownLinkPlugin;
import org.seamcat.simulation.hybrid.HybridOFDMAUpLinkPlugin;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class SnapshotVectorsListModel
implements ListModel {
    protected List<String> vectorNames;
    protected List<ListDataListener> listeners;
    protected Map<String, SnapshotVectorGenerator> generators;
    protected CDMAPlotModel model;

    public SnapshotVectorsListModel(CDMAPlotModel model) {
        this.model = model;
        this.listeners = new ArrayList<ListDataListener>();
        this.generators = new HashMap<String, SnapshotVectorGenerator>();
        this.init();
        this.vectorNames = new ArrayList<String>(this.generators.keySet());
        Collections.sort(this.vectorNames);
    }

    protected void init() {
        HybridSystemPlugin plugin;
        this.initGeneric();
        if (this.model.getActiveUsers().size() > 0) {
            this.initGenericActive();
        }
        if ((plugin = this.model.getPlugin()) instanceof HybridOFDMADownLinkPlugin || plugin instanceof HybridOFDMAUpLinkPlugin) {
            this.initGenericOfdma();
            if (!this.model.isUplink) {
                if (this.model.getActiveUsers().size() > 0) {
                    this.initGenericOfdmaActiveSystem();
                    this.initGenericOfdmaDownlink_ReferenceCellHasActiveConnections();
                }
                this.initGenericDownlink();
                this.initOfdmaDownlink();
            }
            if (this.model.isUplink) {
                this.initGenericUplink();
                this.initOfdmaUplink();
            }
        }
        if (plugin instanceof HybridCDMAUpLinkPlugin || plugin instanceof HybridCDMADownLinkPlugin) {
            this.initGenericCdma();
            if (!this.model.isUplink) {
                this.initGenericDownlink();
                this.initCdmaDownlink();
            }
            if (this.model.isUplink) {
                this.initGenericUplink();
                this.initCdmaUplink();
            }
        }
    }

    protected void initGeneric() {
        if (this.model.isVictimSystem()) {
            this.generators.put("TX Power External Interferers", new SnapshotVectorGenerator("External Interferer", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (Interferer inter : system.getExternalInterferers()) {
                        data.add(inter.getLinkResult().getTxPower());
                    }
                    return data;
                }
            });
            this.generators.put("Number of dropped users per BS", new SnapshotVectorGenerator("BS", "Number of dropped users per BS"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                        data.add(Double.valueOf(base.countDroppedUsers()));
                    }
                    return data;
                }
            });
        }
    }

    protected void initGenericActive() {
        this.generators.put("Effective Pathloss, active links (all cells)", new SnapshotVectorGenerator("Active Users", "dB"){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                    for (AbstractDmaLink link : base.getOldTypeActiveConnections()) {
                        double value = link.getEffectivePathloss();
                        data.add(value);
                    }
                }
                return data;
            }
        });
        this.generators.put("Effective Pathloss to Ext. Interferer (ref cell, all interferers)", new SnapshotVectorGenerator("Active Links", "dB"){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                AbstractDmaBaseStation referenceCell = system.getReferenceCell();
                List<AbstractDmaLink> activeConnections = referenceCell.getOldTypeActiveConnections();
                for (AbstractDmaLink link : activeConnections) {
                    double value = link.getEffectivePathloss();
                    data.add(value);
                }
                return data;
            }
        });
        this.generators.put("Calculated Pathloss, active links (all cells)", new SnapshotVectorGenerator("Active Links", "dB"){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                    for (AbstractDmaLink link : base.getOldTypeActiveConnections()) {
                        double value = link.getTxRxPathLoss();
                        data.add(value);
                    }
                }
                return data;
            }
        });
        this.generators.put("Size of activelist, active users (all cells)", new SnapshotVectorGenerator("Active Users", ""){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                    for (AbstractDmaLink link : base.getOldTypeActiveConnections()) {
                        data.add(Double.valueOf(link.getUserTerminal().getActiveList().size()));
                    }
                }
                return data;
            }
        });
        this.generators.put("Distance to first basestation in active list, active users (all cells)", new SnapshotVectorGenerator("Active Users", "km"){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                    for (AbstractDmaLink link : base.getOldTypeActiveConnections()) {
                        data.add(link.getDistance());
                    }
                }
                return data;
            }
        });
        this.generators.put("RX Power, active links (all cells)", new SnapshotVectorGenerator("Active Links", "dBm"){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                    for (AbstractDmaLink link : base.getOldTypeActiveConnections()) {
                        data.add(link.getTotalReceivedPower());
                    }
                }
                return data;
            }
        });
    }

    protected void initGenericDownlink() {
        this.generators.put("TX Power, basestations", new SnapshotVectorGenerator("BaseStations", "dBm"){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                    data.add(base.getCurrentTransmitPower_dBm());
                }
                return data;
            }
        });
        if (this.model.isVictimSystem()) {
            if (this.model.getReferenceCell().countActiveUsers() > 0) {
                this.generators.put("External Interference, active users (Ref Cell)", new SnapshotVectorGenerator("Active Users", "dBm"){

                    @Override
                    public List<Double> generateVector(CDMAPlotModel system) {
                        ArrayList<Double> data = new ArrayList<Double>();
                        for (AbstractDmaLink link : system.getReferenceCell().getOldTypeActiveConnections()) {
                            data.add(link.getUserTerminal().getExternalInterference());
                        }
                        return data;
                    }
                });
            }
            if (this.model.getReferenceCell().countDroppedUsers() > 0) {
                this.generators.put("External Interference, dropped users (Ref Cell)", new SnapshotVectorGenerator("Dropped Users", "dBm"){

                    @Override
                    public List<Double> generateVector(CDMAPlotModel system) {
                        ArrayList<Double> data = new ArrayList<Double>();
                        for (AbstractDmaLink link : system.getReferenceCell().getDroppedUsers()) {
                            data.add(link.getUserTerminal().getExternalInterference());
                        }
                        return data;
                    }
                });
            }
        }
        if (this.model.getActiveUsers().size() > 0 && this.model.isVictimSystem()) {
            this.generators.put("External Interference, active users (all cells)", new SnapshotVectorGenerator("Active Users", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                        for (AbstractDmaLink link : base.getOldTypeActiveConnections()) {
                            data.add(link.getUserTerminal().getExternalInterference());
                        }
                    }
                    return data;
                }
            });
        }
        if (this.model.getDroppedUsers().size() > 0 && this.model.isVictimSystem()) {
            this.generators.put("External Interference, dropped users (all cells)", new SnapshotVectorGenerator("Dropped Users", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                        for (AbstractDmaLink link : base.getDroppedUsers()) {
                            data.add(link.getUserTerminal().getExternalInterference());
                        }
                    }
                    return data;
                }
            });
        }
    }

    protected void initGenericUplink() {
        this.generators.put("Inter System Interference, base stations", new SnapshotVectorGenerator("BaseStations", "dBm"){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                    data.add(base.getInterSystemInterference());
                }
                return data;
            }
        });
        if (this.model.getActiveUsers().size() > 0) {
            this.generators.put("TX Power, active users (all cells)", new SnapshotVectorGenerator("Active Users", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                        for (AbstractDmaLink link : base.getOldTypeActiveConnections()) {
                            data.add(link.getUserTerminal().getCurrentTransmitPowerIndBm());
                        }
                    }
                    return data;
                }
            });
        }
    }

    protected void initGenericOfdma() {
        if (this.model.isVictimSystem()) {
            this.generators.put("Effective Pathloss to Ext. Interferer (all victims, all interferers)", new SnapshotVectorGenerator("All Victim Receivers", "dB"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (Victim victim : SnapshotVectorsListModel.this.model.eventResult.getVictimResult().getVictims()) {
                        data.addAll(SnapshotVectorsListModel.this.model.eventResult.getExternalInterferersPathLoss(victim));
                    }
                    return data;
                }
            });
            this.generators.put("External Interference - blocking (all victims, all interferers)", new SnapshotVectorGenerator("All Interfering Signals", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (Victim victim : SnapshotVectorsListModel.this.model.eventResult.getVictimResult().getVictims()) {
                        data.addAll(SnapshotVectorsListModel.this.model.eventResult.getExternalInterferersBlocking(victim));
                    }
                    return data;
                }
            });
            this.generators.put("External Interference - unwanted (all victims, all interferers)", new SnapshotVectorGenerator("All Interfering Signals", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (Victim victim : SnapshotVectorsListModel.this.model.eventResult.getVictimResult().getVictims()) {
                        data.addAll(SnapshotVectorsListModel.this.model.eventResult.getExternalInterferersUnwanted(victim));
                    }
                    return data;
                }
            });
        }
    }

    private void initGenericOfdmaDownlink_ReferenceCellHasActiveConnections() {
        if (this.model.isVictimSystem()) {
            this.generators.put("External Interference, Blocking (ref cell)", new SnapshotVectorGenerator("Active Links", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (AbstractDmaLink link : SnapshotVectorsListModel.this.model.getReferenceCell().getOldTypeActiveConnections()) {
                        data.addAll(SnapshotVectorsListModel.this.model.eventResult.getExternalInterferersBlocking(link.getUserTerminal().getVictim()));
                    }
                    return data;
                }
            });
            this.generators.put("External Interference, Unwanted (ref cell)", new SnapshotVectorGenerator("Active Links", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (AbstractDmaLink link : SnapshotVectorsListModel.this.model.getReferenceCell().getOldTypeActiveConnections()) {
                        data.addAll(SnapshotVectorsListModel.this.model.eventResult.getExternalInterferersUnwanted(link.getUserTerminal().getVictim()));
                    }
                    return data;
                }
            });
        }
        this.generators.put("Achieved SINR, active users (Ref Cell)", new SnapshotVectorGenerator("Active Users", "dB"){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                for (AbstractDmaLink link : system.getReferenceCell().getOldTypeActiveConnections()) {
                    data.add(link.getUserTerminal().getSINRAchieved());
                }
                return data;
            }
        });
    }

    private void initGenericOfdmaActiveSystem() {
        this.generators.put("Achieved SINR, active users (all cells)", new SnapshotVectorGenerator("Active Users", "dB"){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                    for (AbstractDmaLink link : base.getOldTypeActiveConnections()) {
                        data.add(link.getUserTerminal().getSINRAchieved());
                    }
                }
                return data;
            }
        });
        this.generators.put("Achieved bitrate, active users (all cells)", new SnapshotVectorGenerator("Active Users", "kbps"){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                    for (AbstractDmaLink link : base.getOldTypeActiveConnections()) {
                        data.add(((OfdmaMobile)link.getUserTerminal()).getBitRateAchieved());
                    }
                }
                return data;
            }
        });
    }

    protected void initGenericCdma() {
        this.generators.put("Geometry, active users (all cells)", new SnapshotVectorGenerator("Active Users", "dB"){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                    for (AbstractDmaLink link : base.getOldTypeActiveConnections()) {
                        data.add(link.getUserTerminal().getGeometry());
                    }
                }
                return data;
            }
        });
    }

    protected void initOfdmaDownlink() {
        if (this.model.isVictimSystem()) {
            this.generators.put("External Interference, Blocking (all victims)", new SnapshotVectorGenerator("All Victim Receivers", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (Victim victim : SnapshotVectorsListModel.this.model.eventResult.getVictimResult().getVictims()) {
                        data.add(SnapshotVectorsListModel.this.model.eventResult.totalInterferenceBlocking(victim));
                    }
                    return data;
                }
            });
            this.generators.put("External Interference, Unwanted (all victims)", new SnapshotVectorGenerator("All Victim Receivers", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (Victim victim : SnapshotVectorsListModel.this.model.eventResult.getVictimResult().getVictims()) {
                        data.add(SnapshotVectorsListModel.this.model.eventResult.totalInterferenceUnwanted(victim));
                    }
                    return data;
                }
            });
        }
    }

    protected void initOfdmaUplink() {
        if (this.model.isVictimSystem()) {
            this.generators.put("External Interference, Blocking (all victims)", new SnapshotVectorGenerator("All Victim Receivers", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (Victim victim : system.victims) {
                        data.add(victim.getTotalInterferenceBlocking());
                    }
                    return data;
                }
            });
            this.generators.put("External Interference, Unwanted (all victims)", new SnapshotVectorGenerator("All Victim Receivers", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (Victim victim : system.victims) {
                        data.add(victim.getTotalInterferenceUnwanted());
                    }
                    return data;
                }
            });
            this.generators.put("External Interference, all cells", new SnapshotVectorGenerator("BaseStations", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (Victim victim : system.victims) {
                        data.add(Mathematics.fromWatt2dBm(Mathematics.fromdBm2Watt(victim.getTotalInterferenceBlocking()) + Mathematics.fromdBm2Watt(victim.getTotalInterferenceUnwanted())));
                    }
                    return data;
                }
            });
            this.generators.put("Frequency of Mobiles", new SnapshotVectorGenerator("Active Links", "MHz"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                        List<AbstractDmaLink> list = base.getOldTypeActiveConnections();
                        for (AbstractDmaLink l : list) {
                            OfdmaUplink link = (OfdmaUplink)l;
                            data.add(link.calculateFrequency());
                        }
                    }
                    return data;
                }
            });
        }
    }

    protected void initCdmaUplink() {
        if (this.model.isVictimSystem()) {
            this.generators.put("External Interference, all cells", new SnapshotVectorGenerator("BaseStations", "dBm"){

                @Override
                public List<Double> generateVector(CDMAPlotModel system) {
                    ArrayList<Double> data = new ArrayList<Double>();
                    for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                        data.add(base.getExternalInterference());
                    }
                    return data;
                }
            });
        }
        this.generators.put("Noise Rise over Noise Floor", new SnapshotVectorGenerator("Noise Rise over Noise Floor", "dB"){

            @Override
            public List<Double> generateVector(CDMAPlotModel system) {
                ArrayList<Double> data = new ArrayList<Double>();
                for (AbstractDmaBaseStation base : system.getAllBaseStations()) {
                    data.add(base.calculateNoiseRiseOverThermalNoise_dB());
                }
                return data;
            }
        });
    }

    protected void initCdmaDownlink() {
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    public Object getElementAt(int index) {
        return this.vectorNames.get(index);
    }

    @Override
    public int getSize() {
        return this.vectorNames.size();
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public double[] getVectorData(String name) {
        List<Double> data = this.generators.get(name).generateVector(this.model);
        double[] rawdata = new double[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            rawdata[i] = data.get(i);
        }
        return rawdata;
    }

    public String getUnit(String name) {
        return this.generators.get(name).getUnit();
    }

    public String getLabel(String name) {
        return this.generators.get(name).getXLabel();
    }

    public static abstract class SnapshotVectorGenerator {
        protected boolean hasData = true;
        protected String errorMessage = "";
        protected String xLabel;
        private String unit;

        public SnapshotVectorGenerator(String x, String unit) {
            this.xLabel = x;
            this.unit = unit;
        }

        public abstract List<Double> generateVector(CDMAPlotModel var1);

        public final String getUnit() {
            return this.unit;
        }

        public boolean hasData() {
            return this.hasData;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getXLabel() {
            return this.xLabel;
        }
    }
}

