/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma.tablemodels;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.seamcat.cdma.CdmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.ofdma.UplinkOfdmaBaseStation;
import org.seamcat.presentation.systems.cdma.CDMAPlotModel;
import org.seamcat.presentation.systems.cdma.tablemodels.CDMAElementTableValue;

public class CDMACellTableModel
implements TableModel {
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private AbstractDmaBaseStation selectedCell;
    private List<CDMAElementTableValue> tableentries = new ArrayList<CDMAElementTableValue>();
    private CDMAPlotModel model;

    public void initTableModel() {
        this.tableentries.clear();
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Cell ID";
                }
                return CDMACellTableModel.this.selectedCell.getCellid();
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Number of served users";
                }
                return new Integer(CDMACellTableModel.this.selectedCell.countServedUsers()) + " users";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Antenna height";
                }
                return CDMACellTableModel.this.selectedCell.getAntennaHeight() + " meters";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Number of dropped users";
                }
                return CDMACellTableModel.this.selectedCell.countDroppedUsers() + " users";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Position";
                }
                return "(" + Mathematics.round(CDMACellTableModel.this.selectedCell.getPosition().getX()) + ", " + Mathematics.round(CDMACellTableModel.this.selectedCell.getPosition().getY()) + ")";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (CDMACellTableModel.this.selectedCell.isUpLinkMode()) {
                    if (columnIndex == 0) {
                        return "External Interference, Selectivity";
                    }
                    return Mathematics.round(CDMACellTableModel.this.selectedCell.getExternalInterferenceBlocking()) + " dBm";
                }
                if (columnIndex == 0) {
                    return "Number of active users";
                }
                return CDMACellTableModel.this.selectedCell.countActiveUsers() + " users";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (CDMACellTableModel.this.selectedCell.isUpLinkMode()) {
                    if (columnIndex == 0) {
                        return "External Interference, Unwanted";
                    }
                    return Mathematics.round(CDMACellTableModel.this.selectedCell.getExternalInterferenceUnwanted()) + " dBm";
                }
                if (columnIndex == 0) {
                    return "Transmit Power";
                }
                return Mathematics.round(CDMACellTableModel.this.selectedCell.getCurrentTransmitPower_dBm()) + " dBm";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (CDMACellTableModel.this.selectedCell.isUpLinkMode() && CDMACellTableModel.this.selectedCell instanceof UplinkOfdmaBaseStation) {
                    if (columnIndex == 0) {
                        return "Antenna Gain towards first external interferer";
                    }
                    Victim victim = CDMACellTableModel.this.selectedCell.getVictim();
                    if (victim != null && ((CDMACellTableModel)CDMACellTableModel.this).model.eventResult.getExternalInterferers(victim).size() > 0) {
                        return Mathematics.round(((CDMACellTableModel)CDMACellTableModel.this).model.eventResult.getExternalInterferers(victim).get(0).getLinkResult().rxAntenna().getGain()) + " dB";
                    }
                    return "0 dBm";
                }
                if (columnIndex == 0) {
                    return "Number of external interferers";
                }
                return CDMACellTableModel.this.model == null ? "" : ((CDMACellTableModel)CDMACellTableModel.this).model.externalInterferers.size() + "";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Active Connections";
                }
                if (CDMACellTableModel.this.selectedCell.getActiveConnections() != null) {
                    return CDMACellTableModel.this.selectedCell.getActiveConnections().size() + " connections";
                }
                return "0 connections";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Is Reference Cell";
                }
                return Boolean.toString(CDMACellTableModel.this.selectedCell == CDMACellTableModel.this.selectedCell.getSystem().getReferenceCell());
            }
        });
        if (this.selectedCell instanceof CdmaBaseStation) {
            final CdmaBaseStation selectedCell = (CdmaBaseStation)this.selectedCell;
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (selectedCell.isUpLinkMode()) {
                        if (columnIndex == 0) {
                            return "Total Interference";
                        }
                        return Mathematics.round(selectedCell.getTotalInterference()) + " dBm";
                    }
                    if (columnIndex == 0) {
                        return "Transmit Power";
                    }
                    selectedCell.calculateCurrentChannelPower_dBm();
                    if (selectedCell.getCurrentTransmitPower_dBm() > selectedCell.getMaximumTransmitPower()) {
                        // empty if block
                    }
                    return Mathematics.round(selectedCell.getCurrentTransmitPower_dBm()) + " dBm";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (selectedCell.isUpLinkMode()) {
                        if (columnIndex == 0) {
                            return "InterSystem Interference";
                        }
                        return Mathematics.round(selectedCell.getInterSystemInterference()) + " dBm";
                    }
                    if (columnIndex == 0) {
                        return "Pilot Channel Power";
                    }
                    return Mathematics.round(Mathematics.fromWatt2dBm(selectedCell.getPilotPower_Watt())) + " dBm";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (selectedCell.isUpLinkMode()) {
                        if (columnIndex == 0) {
                            return "External Interference, Unwanted";
                        }
                        return Mathematics.round(selectedCell.getExternalInterferenceUnwanted()) + " dBm";
                    }
                    if (columnIndex == 0) {
                        return "Overhead Channel Power";
                    }
                    return Mathematics.round(Mathematics.fromWatt2dBm(selectedCell.getOverheadPower_Watt())) + " dBm";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (selectedCell.isUpLinkMode()) {
                        if (columnIndex == 0) {
                            return "Noise Rise over Noise Floor";
                        }
                        return Mathematics.round(selectedCell.calculateNoiseRiseOverThermalNoise_dB()) + " dB";
                    }
                    if (columnIndex == 0) {
                        return "Outage percentage";
                    }
                    return Mathematics.round(selectedCell.getOutagePercentage()) + " %";
                }
            });
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "Name" : "Value";
    }

    @Override
    public int getRowCount() {
        if (this.selectedCell == null) {
            return 0;
        }
        return this.tableentries.size();
    }

    public AbstractDmaBaseStation getSelectedCell() {
        return this.selectedCell;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object obj = this.tableentries.get(rowIndex).getValue(columnIndex);
        if (obj instanceof Double) {
            obj = Mathematics.round((Double)obj);
        }
        return obj;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return rowIndex == 8;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void setSelectedCell(AbstractDmaBaseStation c) {
        this.selectedCell = c;
        this.initTableModel();
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void setModel(CDMAPlotModel model) {
        this.model = model;
    }
}

