/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma.tablemodels;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.presentation.systems.cdma.tablemodels.CDMAElementTableValue;

public class CDMAInterfererTableModel
implements TableModel {
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private Interferer selectedInterferer;
    private List<CDMAElementTableValue> tableentries = new ArrayList<CDMAElementTableValue>();

    public CDMAInterfererTableModel() {
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Type";
                }
                return "Interfering Transmitter";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Transmit Power";
                }
                return Mathematics.round(CDMAInterfererTableModel.this.selectedInterferer.getLinkResult().getTxPower()) + " dBm";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Position";
                }
                Point2D position = CDMAInterfererTableModel.this.selectedInterferer.getLinkResult().txAntenna().getPosition();
                return "(" + Mathematics.round(position.getX()) + ", " + Mathematics.round(position.getY()) + ")";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Frequency";
                }
                return CDMAInterfererTableModel.this.selectedInterferer.getLinkResult().getFrequency() + " MHz";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Antenna Peak Gain";
                }
                return CDMAInterfererTableModel.this.selectedInterferer.getAntennaGain().peakGain() + " dB";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Antenna Height";
                }
                return CDMAInterfererTableModel.this.selectedInterferer.getLinkResult().txAntenna().getHeight() + " meters";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "MCL (dB)";
                }
                return Double.toString(Mathematics.round(CDMAInterfererTableModel.this.selectedInterferer.getMinimumCouplingLoss()));
            }
        });
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "Name" : "Value";
    }

    @Override
    public int getRowCount() {
        if (this.selectedInterferer == null) {
            return 0;
        }
        return this.tableentries.size();
    }

    public Interferer getSelectedCell() {
        return this.selectedInterferer;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object obj = this.tableentries.get(rowIndex).getValue(columnIndex);
        if (obj instanceof Double) {
            obj = Mathematics.round((Double)obj);
        }
        return obj;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void setSelectedInterferer(Interferer selectedInterferer) {
        this.selectedInterferer = selectedInterferer;
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }
}

