/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.cdma.tablemodels;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.seamcat.cdma.CdmaUserTerminal;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.ofdma.DownlinkOfdmaMobile;
import org.seamcat.ofdma.OfdmaMobile;
import org.seamcat.ofdma.UplinkOfdmaMobile;
import org.seamcat.presentation.systems.cdma.tablemodels.CDMAElementTableValue;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class CDMAUserInfoTableModel
implements TableModel {
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private List<CDMAElementTableValue> tableentries = new ArrayList<CDMAElementTableValue>();
    private CdmaUserTerminal cuser;
    private UplinkOfdmaMobile ou_user;
    private DownlinkOfdmaMobile od_user;
    private OfdmaMobile ouser;
    private AbstractDmaMobile user;

    protected void initTableModel() {
        this.tableentries.clear();
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                return columnIndex == 0 ? "Userid" : Integer.valueOf(CDMAUserInfoTableModel.this.user.getUserId());
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Position";
                }
                return "(" + Mathematics.round(CDMAUserInfoTableModel.this.user.getPosition().getX()) + ", " + Mathematics.round(CDMAUserInfoTableModel.this.user.getPosition().getY()) + ")";
            }
        });
        if (this.user instanceof CdmaUserTerminal) {
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Speed";
                    }
                    return Double.toString(CDMAUserInfoTableModel.this.user.getMobilitySpeed()) + " km/h";
                }
            });
        }
        if (this.cuser != null) {
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Status";
                    }
                    if (CDMAUserInfoTableModel.this.user.isConnected()) {
                        return "Connected";
                    }
                    if (CDMAUserInfoTableModel.this.user.isDropped()) {
                        return "Dropped - " + CDMAUserInfoTableModel.this.user.getDropReason();
                    }
                    if (!CDMAUserInfoTableModel.this.user.isAllowedToConnect()) {
                        return "Not allowed to connect";
                    }
                    return "Not connected";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (CDMAUserInfoTableModel.this.cuser.isUpLinkMode()) {
                        if (columnIndex == 0) {
                            return "Multi-Path";
                        }
                        return Integer.toString(CDMAUserInfoTableModel.this.cuser.getMultiPathChannel());
                    }
                    if (columnIndex == 0) {
                        return "Geometry";
                    }
                    return Mathematics.round(CDMAUserInfoTableModel.this.cuser.getGeometry()) + " dB";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (CDMAUserInfoTableModel.this.cuser.isUpLinkMode()) {
                        if (columnIndex == 0) {
                            return "Achieved CI";
                        }
                        return Double.toString(Mathematics.round(CDMAUserInfoTableModel.this.cuser.getAchievedCI())) + " dB";
                    }
                    if (columnIndex == 0) {
                        return "Achieved Ec/Ior";
                    }
                    return Double.toString(Mathematics.round(CDMAUserInfoTableModel.this.cuser.getAchievedEcIor())) + " dB";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (CDMAUserInfoTableModel.this.cuser.isUpLinkMode()) {
                        return columnIndex == 0 ? "Required Eb/No" : Double.toString(Mathematics.round(CDMAUserInfoTableModel.this.cuser.getLinkLevelData().getEbNo())) + " dB";
                    }
                    return columnIndex == 0 ? "Required Ec/Ior" : Double.toString(Mathematics.round(CDMAUserInfoTableModel.this.cuser.getLinkLevelData().getEcIor())) + " dB";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Total Power Received from Inactive Set";
                    }
                    if (CDMAUserInfoTableModel.this.user.isUpLinkMode()) {
                        return "Not applicable";
                    }
                    return Mathematics.round(CDMAUserInfoTableModel.this.cuser.getTotalPowerReceivedFromBaseStationsNotInActiveSetdBm()) + " dBm";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Total Power Received from Active Set";
                    }
                    if (CDMAUserInfoTableModel.this.user.isUpLinkMode()) {
                        return "Not applicable";
                    }
                    return Mathematics.round(Mathematics.fromWatt2dBm(CDMAUserInfoTableModel.this.cuser.getTotalPowerReceivedFromBaseStationsActiveSetInWatt())) + " dBm";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Traffic Channel Power";
                    }
                    if (CDMAUserInfoTableModel.this.user.isUpLinkMode()) {
                        return "Not applicable";
                    }
                    return Mathematics.round(Mathematics.fromWatt2dBm(CDMAUserInfoTableModel.this.cuser.getReceivedTrafficChannelPowerWatt())) + " dBm";
                }
            });
        }
        if (this.ouser != null) {
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int column) {
                    if (column == 0) {
                        return "Achieved SINR";
                    }
                    return Mathematics.round(CDMAUserInfoTableModel.this.ouser.getSINRAchieved()) + "dB";
                }
            });
        }
        if (this.ou_user != null) {
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int column) {
                    if (column == 0) {
                        return "Power Received (serving link)";
                    }
                    return Mathematics.round(CDMAUserInfoTableModel.this.ouser.getServingLink().getTotalReceivedPower()) + " dBm";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int column) {
                    if (column == 0) {
                        return "Total interference";
                    }
                    return Mathematics.round(Mathematics.fromWatt2dBm(CDMAUserInfoTableModel.this.ouser.getTotalInterference())) + " dBm";
                }
            });
        }
        if (this.ouser != null) {
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int column) {
                    if (column == 0) {
                        return "Frequency";
                    }
                    return Mathematics.round(CDMAUserInfoTableModel.this.ouser.getFrequency()) + " MHz";
                }
            });
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int column) {
                    if (column == 0) {
                        return "Bandwidth";
                    }
                    return Mathematics.round(CDMAUserInfoTableModel.this.ouser.getBandwidth()) + " MHz";
                }
            });
        }
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (CDMAUserInfoTableModel.this.user.isUpLinkMode()) {
                    if (columnIndex == 0) {
                        return "Transmit Power";
                    }
                    return Mathematics.round(CDMAUserInfoTableModel.this.user.getCurrentTransmitPowerIndBm()) + " dBm";
                }
                if (columnIndex == 0) {
                    return "External interference";
                }
                double extInf = CDMAUserInfoTableModel.this.user.getExternalInterference();
                if (extInf < -900.0) {
                    return "No External Interference";
                }
                return Mathematics.round(extInf) + " dBm";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Active List";
                }
                return CDMAUserInfoTableModel.this.user.getActiveList().size() + " connection(s)";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Connection List";
                }
                return CDMAUserInfoTableModel.this.user.getAllLinks().length - CDMAUserInfoTableModel.this.user.getActiveList().size() + " connection(s)";
            }
        });
        if (this.user instanceof CdmaUserTerminal) {
            this.tableentries.add(new CDMAElementTableValue(){

                @Override
                public Object getValue(int columnIndex) {
                    if (columnIndex == 0) {
                        return "Is in softhandover";
                    }
                    return CDMAUserInfoTableModel.this.user.isInSoftHandover();
                }
            });
        }
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Distance to first cell in active list";
                }
                return Mathematics.round(CDMAUserInfoTableModel.this.user.getActiveList().get(0).getDistance()) + " km";
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    if (CDMAUserInfoTableModel.this.user.getActiveList().get(0).isUpLink()) {
                        return "Azimuth antenna angle\u00a0to\u00a0first cell in active list";
                    }
                    return "Azimuth antenna angle\u00a0from\u00a0first cell in active list";
                }
                return Double.toString(Mathematics.round(CDMAUserInfoTableModel.this.user.getActiveList().get(0).asLinkResult().txAntenna().getAzimuth())) + '\u00b0';
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    if (CDMAUserInfoTableModel.this.user.getActiveList().get(0).isUpLink()) {
                        return "Elevation antenna angle\u00a0to\u00a0first cell in active list";
                    }
                    return "Elevation antenna angle\u00a0from\u00a0first cell in active list";
                }
                return Double.toString(Mathematics.round(CDMAUserInfoTableModel.this.user.getActiveList().get(0).asLinkResult().txAntenna().getElevation())) + '\u00b0';
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Connected sector of first cell in active list";
                }
                AbstractDmaBaseStation cell = CDMAUserInfoTableModel.this.user.getActiveList().get(0).getBaseStation();
                if (cell.getSystem().getPlugin().getSectorSetup() == HybridSystemPlugin.SectorSetup.SingleSector) {
                    return "N/A - Cell is Omni directional";
                }
                return cell.getSectorId();
            }
        });
        this.tableentries.add(new CDMAElementTableValue(){

            @Override
            public Object getValue(int columnIndex) {
                if (columnIndex == 0) {
                    return "Antenna Gain from first BS in active list";
                }
                AbstractDmaLink link = CDMAUserInfoTableModel.this.user.getActiveList().get(0);
                return Mathematics.round(link.isUpLink() ? link.asLinkResult().rxAntenna().getGain() : link.asLinkResult().txAntenna().getGain()) + " dB";
            }
        });
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Value";
            }
        }
        return "Unknown";
    }

    @Override
    public int getRowCount() {
        if (this.user == null) {
            return 0;
        }
        return this.tableentries.size();
    }

    public CdmaUserTerminal getUser() {
        return this.cuser;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object obj = this.tableentries.get(rowIndex).getValue(columnIndex);
        if (obj instanceof Double) {
            obj = Mathematics.round((Double)obj);
        }
        return obj;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 && (rowIndex == 8 || rowIndex == 9);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void setUserTerminal(AbstractDmaMobile _user) {
        this.user = _user;
        this.ouser = null;
        this.cuser = null;
        this.ou_user = null;
        this.od_user = null;
        if (_user instanceof CdmaUserTerminal) {
            this.cuser = (CdmaUserTerminal)_user;
        } else if (_user instanceof OfdmaMobile) {
            this.ouser = (OfdmaMobile)_user;
            if (this.ouser.isUpLinkMode()) {
                this.ou_user = (UplinkOfdmaMobile)_user;
            } else {
                this.od_user = (DownlinkOfdmaMobile)_user;
            }
        }
        this.initTableModel();
        int stop = this.listeners.size();
        for (int i = 0; i < stop; ++i) {
            this.listeners.get(i).tableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }
}

