/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.systems.correlation;

import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.UIEventHandler;
import org.seamcat.model.InterferenceLinkElement;
import org.seamcat.model.Workspace;
import org.seamcat.model.workspace.CorrelationSettingsUI;
import org.seamcat.presentation.genericgui.GenericPanel;
import org.seamcat.presentation.genericgui.ItemChangedEvent;
import org.seamcat.presentation.genericgui.item.OptionalSelectionItem;
import org.seamcat.presentation.genericgui.item.ValueWithUsageFlag;
import org.seamcat.presentation.systems.correlation.CorrelationModePanel;

public class CoLocationPanel
extends GenericPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private final CorrelationModePanel panel;
    private OptionalSelectionItem<InterferenceLinkElement> item;

    public CoLocationPanel(InterferenceLinkElement self, Workspace workspace, CorrelationModePanel panel) {
        this.panel = panel;
        ArrayList<InterferenceLinkElement> selection = new ArrayList<InterferenceLinkElement>();
        CorrelationSettingsUI settingsUI = self.getSettings().path().correlationSettings();
        boolean isC = settingsUI.isCoLocated();
        String coLocatedWith = settingsUI.coLocatedWith();
        InterferenceLinkElement selected = null;
        for (InterferenceLinkElement link : workspace.getInterferenceLinkUIs()) {
            if (link == self || link.getSettings().path().correlationSettings().isCoLocated()) continue;
            selection.add(link);
            if (!isC || !link.getId().equals(coLocatedWith)) continue;
            selected = link;
        }
        if (selected == null) {
            selected = (InterferenceLinkElement)selection.get(0);
        }
        this.item = ((OptionalSelectionItem)new OptionalSelectionItem().label("To position with")).values(selection);
        this.item.information(STRINGLIST.getString("COLOCATION_INFORMATION"));
        this.addItem(this.item);
        this.item.initialize();
        this.item.setValue(new ValueWithUsageFlag<InterferenceLinkElement>(isC, selected));
        this.initializeWidgets();
        EventBusFactory.getEventBus().subscribe(this);
    }

    @UIEventHandler
    public void handle(ItemChangedEvent event) {
        if (event.getItem() == this.item) {
            this.panel.coLocationEnabled(((ValueWithUsageFlag)this.item.getValue()).useValue);
        }
    }

    public ValueWithUsageFlag<InterferenceLinkElement> getSelection() {
        return this.item.getValue();
    }
}

