/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.valuepreview;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.seamcat.presentation.valuepreview.ValuePreviewPopup;
import org.seamcat.presentation.valuepreview.ValuePreviewable;

class ValuePreviewPopupHandler {
    private ValuePreviewable previewable;
    private Popup popup;
    private JComponent component;
    private MouseListener listener;

    ValuePreviewPopupHandler(JComponent component) {
        this.component = component;
        this.listener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ValuePreviewPopupHandler.this.hidePopup();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ValuePreviewPopupHandler.this.hidePopup();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ValuePreviewPopupHandler.this.component.isEnabled()) {
                    ValuePreviewPopupHandler.this.showPopup(e);
                }
            }
        };
        component.addMouseListener(this.listener);
    }

    void setPreviewable(ValuePreviewable previewable) {
        this.previewable = previewable;
    }

    void showPopup(MouseEvent e) {
        this.hidePopup();
        if (this.previewable != null) {
            Point popupLocation = new Point(e.getX() + 10, this.component.getHeight() / 2);
            SwingUtilities.convertPointToScreen(popupLocation, this.component);
            ValuePreviewPopup tooltipComponent = new ValuePreviewPopup(this.previewable);
            this.popup = PopupFactory.getSharedInstance().getPopup(this.component, tooltipComponent, popupLocation.x, popupLocation.y);
            ((Component)tooltipComponent).setVisible(true);
            tooltipComponent.setSize(((Component)tooltipComponent).getPreferredSize());
            this.popup.show();
        }
    }

    void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    public void dispose() {
        this.component.removeMouseListener(this.listener);
    }
}

