/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation.vectorscatter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.presentation.ChartSaver;
import org.seamcat.presentation.compare.VectorNode;
import org.seamcat.presentation.components.SaveFileChooser;
import org.seamcat.presentation.display.ControlButtonPanel;
import org.seamcat.presentation.layout.VerticalSubPanelLayoutManager;
import org.seamcat.tabulardataio.FileDataIO;

public class VectorScatterPanel
extends JPanel {
    private JPanel main = new JPanel(new BorderLayout());
    private VectorNode first;
    private VectorNode second;

    public VectorScatterPanel() {
        super(new BorderLayout());
        this.add((Component)this.main, "Center");
    }

    public void add(VectorNode vector) {
        if (this.first == null) {
            this.first = vector;
        } else {
            this.second = vector;
            this.display();
        }
    }

    public void empty() {
        this.first = null;
        this.second = null;
        this.clear();
    }

    private void clear() {
        this.main.removeAll();
        this.revalidate();
        this.repaint();
    }

    private void display() {
        double[] y;
        String title = this.first.getHolder().getTitle() + " x " + this.second.getHolder().getTitle();
        XYSeriesCollection collection = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)title));
        final double[] x = this.first.getHolder().getData();
        int size = x.length > (y = this.second.getHolder().getData()).length ? y.length : x.length;
        for (int i = 0; i < size; ++i) {
            series.add(x[i], y[i]);
        }
        collection.addSeries(series);
        JFreeChart scatterPlot = ChartFactory.createScatterPlot(title, this.first.getHolder().getUnit(), this.second.getHolder().getUnit(), collection, PlotOrientation.VERTICAL, false, false, false);
        XYPlot p = scatterPlot.getXYPlot();
        scatterPlot.setBackgroundPaint(this.getBackground());
        p.setBackgroundPaint(Color.white);
        p.setDomainGridlinePaint(Color.black);
        p.setRangeGridlinePaint(Color.black);
        final ChartPanel chartPanel = new ChartPanel(scatterPlot);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.main.add((Component)chartPanel, "Center");
        JPanel right = new JPanel();
        right.setLayout(new VerticalSubPanelLayoutManager());
        right.setPreferredSize(new Dimension(200, right.getPreferredSize().height));
        right.add(new ControlButtonPanel(this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileDataIO fileIO = SaveFileChooser.chooseFile(VectorScatterPanel.this.getParent());
                if (fileIO != null) {
                    fileIO.saveValues(x, VectorScatterPanel.this.first.getHolder().getUnit(), y, VectorScatterPanel.this.second.getHolder().getUnit());
                }
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartSaver.saveChart(chartPanel);
            }
        }));
        this.main.add((Component)right, "East");
        this.revalidate();
        this.repaint();
    }
}

