/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.scenario;

import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.GaussianDistributionImpl;
import org.seamcat.model.distributions.RayleighDistributionImpl;
import org.seamcat.model.distributions.UniformPolarAngleDistributionImpl;
import org.seamcat.model.distributions.UniformPolarDistanceDistributionImpl;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.scenariocheck.InterferingLinkCheck;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.presentation.WarningColors;
import org.seamcat.simulation.generic.CognitiveRadio;

public class GeneralVictimConsistencyCheck {
    public static void victim(Scenario scenario, RadioSystem victim, Validator validator) {
        Function function;
        Transmitter vt = victim.getTransmitter();
        Bounds bounds = scenario.getVictim().getFrequency().getBounds();
        double rFreqVrMin = bounds.getMin();
        double rFreqVrMax = bounds.getMax();
        boolean bFreqVrBounded = bounds.isBounded();
        double victimFreqRange = rFreqVrMax - rFreqVrMin;
        Receiver vr = victim.getReceiver();
        double bandwidthRange = victimFreqRange + vr.getBandwidth() / 2.0;
        boolean isUsingCognitiveRadio = CognitiveRadio.isActive(scenario.getInterferenceLinks());
        if (bFreqVrBounded) {
            if (!isUsingCognitiveRadio) {
                GeneralVictimConsistencyCheck.checkBlocking(scenario, vr, rFreqVrMin, rFreqVrMax, validator);
                if (vr.isIntermodulationRejectionOption()) {
                    // empty if block
                }
            }
        } else {
            validator.error("Unbounded frequency distribution in victim link");
        }
        if (isUsingCognitiveRadio && !(function = vr.getBlockingMask().getFunction()).isConstant()) {
            DiscreteFunction func = (DiscreteFunction)function;
            double min = func.getBounds().getMin();
            double max = func.getBounds().getMax();
            if (!func.isConstant() && (max < victimFreqRange || Math.abs(min) < victimFreqRange)) {
                validator.error(String.format("Victim Receiver: Blocking response function does not cover the full frequency offset range: -%s to +%s", InterferingLinkCheck.fAndU(victimFreqRange), InterferingLinkCheck.fAndU(victimFreqRange)) + "<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
            }
        }
        if (isUsingCognitiveRadio) {
            Distribution freqDist = scenario.getVictim().getFrequency();
            if (freqDist instanceof GaussianDistributionImpl || freqDist instanceof RayleighDistributionImpl || freqDist instanceof UniformPolarDistanceDistributionImpl || freqDist instanceof UniformPolarAngleDistributionImpl) {
                validator.error("<html>Frequency distribution of the victim system link cannot be of type Gaussian,<br>Rayleigh or UniformPolar distance/angle in combination with cognitive radio features</html>");
            }
            MaskFunction emissionsMask = vt.getEmissionsMask().getEmissionMask();
            Bounds emissionsMaskBounds = emissionsMask.getBounds();
            double emissionsMaskMin = emissionsMaskBounds.getMin();
            double emissionsMaskMax = emissionsMaskBounds.getMax();
            if (!emissionsMask.isConstant() && (emissionsMaskMax < bandwidthRange || Math.abs(emissionsMaskMin) < bandwidthRange)) {
                validator.error(String.format("Victim Link Transmitter: Emissions mask function does not cover the full frequency offset range: -%s to +%s", InterferingLinkCheck.fAndU(bandwidthRange), InterferingLinkCheck.fAndU(bandwidthRange)) + "<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
            }
            if (vt.isUsingEmissionsFloor()) {
                MaskFunction emissionsFloor = vt.getEmissionsFloor();
                Bounds emissionsFloorBounds = emissionsFloor.getBounds();
                double emissionsFloorMin = emissionsFloorBounds.getMin();
                double emissionsFloorMax = emissionsFloorBounds.getMax();
                if (!emissionsFloor.isConstant() && (emissionsFloorMax < bandwidthRange || Math.abs(emissionsFloorMin) < bandwidthRange)) {
                    validator.error(String.format("Victim Link Transmitter: Unwanted emissions floor function does not cover the full frequency offset range: -%s to +%s", InterferingLinkCheck.fAndU(bandwidthRange), InterferingLinkCheck.fAndU(bandwidthRange)) + "<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                }
            }
        }
    }

    private static void checkBlocking(Scenario scenario, Receiver receiver, double rFreqVrMin, double rFreqVrMax, Validator validator) {
        Function function = receiver.getBlockingMask().getFunction();
        if (!function.isConstant()) {
            DiscreteFunction func = (DiscreteFunction)function;
            double min = func.getBounds().getMin();
            double max = func.getBounds().getMax();
            for (InterferenceLink link : scenario.getInterferenceLinks()) {
                Distribution freq = link.getFrequency();
                Bounds itbounds = freq.getBounds();
                if (!itbounds.isBounded()) continue;
                String name = link.getInterferer().getName();
                if (rFreqVrMin == rFreqVrMax && itbounds.getMax() == itbounds.getMin()) {
                    if (rFreqVrMax - itbounds.getMax() == 0.0) {
                        if (max < itbounds.getMax() - rFreqVrMax) {
                            validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                        if (min > rFreqVrMax - itbounds.getMin()) {
                            validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                    }
                    if (rFreqVrMax - itbounds.getMax() < 0.0 && max < itbounds.getMax() - rFreqVrMax) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (!(rFreqVrMax - itbounds.getMax() > 0.0) || !(min > itbounds.getMin() - rFreqVrMax)) continue;
                    validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    continue;
                }
                if (rFreqVrMin - itbounds.getMin() < 0.0 && rFreqVrMax - itbounds.getMin() < 0.0 && max < itbounds.getMax() - rFreqVrMin) {
                    validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                }
                if (rFreqVrMin - itbounds.getMin() < 0.0 && rFreqVrMax - itbounds.getMin() >= 0.0 && rFreqVrMax - itbounds.getMax() < 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMin) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (min > itbounds.getMin() - rFreqVrMax) {
                        validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                }
                if (rFreqVrMin - itbounds.getMin() >= 0.0 && rFreqVrMax - itbounds.getMax() <= 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMin) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (min > itbounds.getMin() - rFreqVrMax) {
                        validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                }
                if (rFreqVrMin - itbounds.getMin() > 0.0 && rFreqVrMin - itbounds.getMax() <= 0.0 && rFreqVrMax - itbounds.getMax() > 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMin) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (min > itbounds.getMin() - rFreqVrMax) {
                        validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                }
                if (!(rFreqVrMin - itbounds.getMax() > 0.0) || !(rFreqVrMax - itbounds.getMax() > 0.0) || !(min > itbounds.getMin() - rFreqVrMax)) continue;
                validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
            }
        }
    }

    private static void checkIntermodulation(Scenario scenario, Receiver vr, double rFreqVrMin, double rFreqVrMax, Validator validator) {
        Function function = vr.getIntermodulationRejection();
        if (!function.isConstant()) {
            DiscreteFunction func = (DiscreteFunction)function;
            double min = func.getBounds().getMin();
            double max = func.getBounds().getMax();
            for (InterferenceLink link : scenario.getInterferenceLinks()) {
                RadioSystem interferingSystem = link.getInterferer().getSystem();
                Distribution freq = link.getFrequency();
                Bounds itbounds = freq.getBounds();
                if (!itbounds.isBounded()) continue;
                String name = link.getInterferer().getName();
                if (rFreqVrMin == rFreqVrMax && itbounds.getMax() == itbounds.getMin()) {
                    if (rFreqVrMax - itbounds.getMax() == 0.0) {
                        if (max < itbounds.getMax() - rFreqVrMax) {
                            validator.error("Intermodulation rejection upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                        if (min > rFreqVrMax - itbounds.getMin()) {
                            validator.error("Intermodulation rejection lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                    }
                    if (rFreqVrMax - itbounds.getMax() < 0.0 && max < itbounds.getMax() - rFreqVrMax) {
                        validator.error("Intermodulation rejection upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (!(rFreqVrMax - itbounds.getMax() > 0.0) || !(min > itbounds.getMin() - rFreqVrMax)) continue;
                    validator.error("Intermodulation rejection lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    continue;
                }
                if (rFreqVrMin - itbounds.getMin() < 0.0 && rFreqVrMax - itbounds.getMin() < 0.0 && max < itbounds.getMax() - rFreqVrMin) {
                    validator.error("Intermodulation rejection upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                }
                if (rFreqVrMin - itbounds.getMin() < 0.0 && rFreqVrMax - itbounds.getMin() >= 0.0 && rFreqVrMax - itbounds.getMax() < 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMin) {
                        validator.error("Intermodulation rejection upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (min > itbounds.getMin() - rFreqVrMax) {
                        validator.error("Intermodulation rejection lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                }
                if (rFreqVrMin - itbounds.getMin() >= 0.0 && rFreqVrMax - itbounds.getMax() <= 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMin) {
                        validator.error("Intermodulation rejection upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (min > itbounds.getMin() - rFreqVrMax) {
                        validator.error("Intermodulation rejection lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                }
                if (rFreqVrMin - itbounds.getMin() > 0.0 && rFreqVrMin - itbounds.getMax() <= 0.0 && rFreqVrMax - itbounds.getMax() > 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMin) {
                        validator.error("Intermodulation rejection upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (min > itbounds.getMin() - rFreqVrMax) {
                        validator.error("Intermodulation rejection lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                }
                if (!(rFreqVrMin - itbounds.getMax() > 0.0) || !(rFreqVrMax - itbounds.getMax() > 0.0) || !(min > itbounds.getMin() - rFreqVrMax)) continue;
                validator.error("Intermodulation rejection lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
            }
        }
    }
}

