/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.scenario;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.correlation.Closest;
import org.seamcat.model.correlation.None;
import org.seamcat.model.correlation.NoneMode;
import org.seamcat.model.correlation.UniformDensity;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.GaussianDistribution;
import org.seamcat.model.distributions.LimitedGaussianDistribution;
import org.seamcat.model.distributions.LimitedRayleighDistribution;
import org.seamcat.model.distributions.RayleighDistribution;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.simulation.consistency.ConsistencyError;
import org.seamcat.model.simulation.consistency.PluginValidator;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.plugin.ValidatorImpl;
import org.seamcat.scenario.GeneralSystemConsistencyCheck;
import org.seamcat.scenario.LocalEnvironmentsConsistencyCheck;
import org.seamcat.simulation.generic.ClosestMode;
import org.seamcat.simulation.generic.UniformMode;
import org.seamcat.simulation.result.ConsistencyCheckContextImpl;

public class ScenarioConsistencyCheck {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);

    public static List<ConsistencyError> checkScenario(Scenario scenario) {
        return ScenarioConsistencyCheck.checkScenario(scenario, "");
    }

    public static List<ConsistencyError> checkScenario(Scenario scenario, String prefix) {
        ArrayList<ConsistencyError> errors = new ArrayList<ConsistencyError>();
        ConsistencyCheckContextImpl context = new ConsistencyCheckContextImpl(scenario.getVictim(), scenario.getVictim().getFrequency());
        String sysName = ScenarioConsistencyCheck.name(context, prefix + "Victim system");
        ScenarioConsistencyCheck.checkSystem(context, errors, sysName);
        PluginValidator.appendErrors(GeneralSystemConsistencyCheck.check(true, scenario, scenario.getVictim(), null), sysName, errors);
        ValidatorImpl val = new ValidatorImpl();
        RadioSystem vic = scenario.getVictim().getSystem();
        LocalEnvironmentsConsistencyCheck.checkEnvironments(vic.getReceiver().getLocalEnvironments(), vic.getTransmitter().getLocalEnvironments(), context.getFrequency(), vic.getPropagationModel(), val);
        scenario.getVictim().getSystemPlugin().consistencyCheck(context, scenario, val);
        PluginValidator.appendErrors(val.getResult(), sysName, errors);
        int i = 1;
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            ConsistencyCheckContextImpl ctx = new ConsistencyCheckContextImpl(link.getInterferer(), link.getFrequency());
            String name = ScenarioConsistencyCheck.name(ctx, prefix + "Link " + i);
            ScenarioConsistencyCheck.checkSystem(ctx, errors, name);
            PluginValidator.appendErrors(GeneralSystemConsistencyCheck.check(false, scenario, link.getInterferer(), link), name, errors);
            ctx = new ConsistencyCheckContextImpl(link);
            val = new ValidatorImpl();
            LocalEnvironmentsConsistencyCheck.checkEnvironments(vic.getReceiver().getLocalEnvironments(), link.getInterferer().getSystem().getTransmitter().getLocalEnvironments(), link.getFrequency(), link.getPropagationModel(), val);
            ScenarioConsistencyCheck.checkDist(name + "->Relative Positioning", link.getCorrelationSettings().getDeltaX(), "delta x", errors);
            ScenarioConsistencyCheck.checkDist(name + "->Relative Positioning", link.getCorrelationSettings().getDeltaY(), "delta y", errors);
            CorrelationMode mode = link.getCorrelationSettings().getCorrelationMode();
            if (mode == NoneMode.MODE) {
                None none = link.getCorrelationSettings().getCorrelationConfiguration(None.class);
                ScenarioConsistencyCheck.checkDist(name + "->None", none.pathAzimuth(), "path azimuth", errors);
                ScenarioConsistencyCheck.checkDist(name + "->None", none.pathDistanceFactor(), "path distance factor", errors);
            } else if (mode == UniformMode.MODE) {
                UniformDensity uniformDensity = link.getCorrelationSettings().getCorrelationConfiguration(UniformDensity.class);
                ScenarioConsistencyCheck.checkDist(name + "->Uniform", uniformDensity.pathAzimuth(), "path azimuth", errors);
            } else if (mode == ClosestMode.MODE) {
                Closest closest = link.getCorrelationSettings().getCorrelationConfiguration(Closest.class);
                ScenarioConsistencyCheck.checkDist(name + "->Closest", closest.pathAzimuth(), "path azimuth", errors);
            }
            link.getInterferer().getSystemPlugin().consistencyCheck(ctx, scenario, val);
            PluginValidator.appendErrors(val.getResult(), name, errors);
            PluginValidator.plugin(ctx, errors, link.getPropagationModel(), name + "->Interference Link->Propagation Model");
            ++i;
        }
        List<EventProcessing> eventProcessingList = scenario.getEventProcessingList();
        for (EventProcessing processing : eventProcessingList) {
            PluginValidator.plugin(new ConsistencyCheckContextImpl(scenario), errors, processing, prefix + processing.description().name());
        }
        return errors;
    }

    private static void checkDist(String name, Distribution distribution, String variable, List<ConsistencyError> errors) {
        if (distribution instanceof GaussianDistribution && !(distribution instanceof LimitedGaussianDistribution)) {
            errors.add(ScenarioConsistencyCheck.error(name, "Gaussian distribution", variable));
            return;
        }
        if (distribution instanceof RayleighDistribution && !(distribution instanceof LimitedRayleighDistribution)) {
            errors.add(ScenarioConsistencyCheck.error(name, "Rayleigh distribution", variable));
        }
    }

    public static ConsistencyError error(String name, String dist, String variable) {
        return new ConsistencyError(name, String.format(STRINGLIST.getString("PATHS_POSSIBLE_INVALID_DISTRIBUTION"), dist, variable));
    }

    private static String name(ConsistencyCheckContext context, String prefix) {
        String name = "System";
        try {
            name = context.getSystemPlugin().getUI().description().name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prefix + "(" + name + ")";
    }

    private static void checkSystem(ConsistencyCheckContext context, List<ConsistencyError> errors, String prefix) {
        RadioSystem system = context.getSystem();
        PluginValidator.plugin(context, errors, system.getPropagationModel(), prefix + "->Propagation Model");
        AntennaGain ag = system.getReceiver().getAntennaGain();
        PluginValidator.plugin(context.setContextObject(system.getReceiver()), errors, ag, prefix + "->Receiver->Antenna Gain" + ag.description().name() + "->");
        ag = system.getTransmitter().getAntennaGain();
        PluginValidator.plugin(context.setContextObject(system.getTransmitter()), errors, ag, prefix + "->Transmitter->Antenna Gain" + ag.description().name() + "->");
    }
}

