/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation;

import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.seamcat.model.Scenario;
import org.seamcat.model.Workspace;
import org.seamcat.model.engines.SimulationListener;
import org.seamcat.model.engines.SingleResult;
import org.seamcat.model.engines.VectorDefinitions;
import org.seamcat.model.factory.Model;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.SimulationResult;
import org.seamcat.scenario.WorkspaceScenario;
import org.seamcat.simulation.result.SimulationResultImpl;

public class Simulation {
    private static Logger LOG = Logger.getLogger(Simulation.class);
    private Workspace workspace;
    private WorkspaceScenario scenario;
    private VectorDefinitions names;
    private SimulationListener listener;
    private File logfile;
    private FileAppender logfileAppender;
    private List<SimulationInstance> simulations;

    public Simulation(Workspace workspace, WorkspaceScenario scenario) {
        this(workspace, scenario, new SimulationListener(){

            @Override
            public void simulationBegin(int totalEvents) {
            }

            @Override
            public void eventComplete(SingleResult result) {
            }

            @Override
            public void simulationEnd() {
            }
        });
    }

    public Simulation(Workspace workspace, WorkspaceScenario scenario, SimulationListener listener) {
        this.workspace = workspace;
        this.workspace.setSimulationResult(new SimulationResultImpl());
        this.scenario = scenario;
        this.listener = listener;
        this.names = new VectorDefinitions(scenario.getVictim().getSystemPlugin());
    }

    public SimulationResult getSimulationResult() {
        return this.workspace.getSimulationResults();
    }

    public void appendDebugLog() {
        try {
            this.logfile = new File(Model.seamcatHome + File.separator + "logfiles" + File.separator);
            if (!this.logfile.exists()) {
                this.logfile.mkdirs();
            }
            Calendar cal = Calendar.getInstance(TimeZone.getDefault());
            cal.setTimeInMillis(System.currentTimeMillis());
            this.logfile = new File(this.logfile, this.workspace.getName() + " - " + cal.get(1) + (cal.get(2) + 1 < 10 ? "0" : "") + (cal.get(2) + 1) + cal.get(5) + "_" + cal.get(11) + "." + cal.get(12) + ".log");
            this.logfile.createNewFile();
            this.logfileAppender = new FileAppender(Model.getInstance().getLogFilePattern(), this.logfile.getAbsolutePath(), true);
            Logger.getLogger("org.seamcat").addAppender(this.logfileAppender);
            Logger.getLogger("org.seamcat").setLevel(Level.DEBUG);
        }
        catch (IOException ex) {
            LOG.warn("Unable to create EGE log file", ex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\nStarting new event generation at: " + new Timestamp(System.currentTimeMillis()) + "\n");
        }
    }

    public void removeDebugLog() {
        Logger.getLogger("org.seamcat").removeAppender(this.logfileAppender);
        Logger.getLogger("org.seamcat").setLevel(Logger.getRootLogger().getLevel());
        this.logfileAppender.close();
    }

    public void simulationBegin(long simulationSeed) {
        RandomAccessor.fixSeed(simulationSeed);
        if (this.workspace.getSimulationControl().debugMode()) {
            this.appendDebugLog();
        }
        this.workspace.setScenario(this.scenario);
        LOG.debug("Starting Event Generation");
        this.listener.simulationBegin(this.scenario.numberOfEvents());
    }

    public void eventComplete(EventResult eventResult, List<SimulationInstance> simulations) {
        if (this.lastEvent(eventResult)) {
            this.simulations = simulations;
        }
    }

    public void simulationEnd() {
        this.listener.simulationEnd();
        if (this.workspace.getSimulationControl().debugMode()) {
            this.removeDebugLog();
        }
    }

    public boolean lastEvent(EventResult eventResult) {
        return eventResult.getEventNumber() == this.scenario.numberOfEvents() - 1;
    }

    public List<SimulationInstance> getLastEventSimulations() {
        return this.simulations;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public File getLogfile() {
        return this.logfile;
    }

    public SimulationListener getListener() {
        return this.listener;
    }

    public VectorDefinitions getNames() {
        return this.names;
    }
}

