/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.calculator;

import org.apache.log4j.Logger;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public class InterferenceCalculator {
    private static final Logger LOG = Logger.getLogger(InterferenceCalculator.class);

    public static double unwantedInterference(Results iPreSim, InterferenceLinkResult result) {
        double rItPower = result.getTxPower();
        double rItVrEffectivePathLoss = result.getEffectiveTxRxPathLoss();
        double rUnwantedEmissionRel = InterferenceCalculator.itUnwantedEmissions(iPreSim, result);
        double rItPowerControlGain = 0.0;
        Transmitter transmitter = result.getInterferenceLink().getInterferer().getSystem().getTransmitter();
        if (transmitter.isUsingPowerControl()) {
            rItPowerControlGain = (Double)result.getInterferingSystemLink().getValue(SystemPlugin.TX_POWER_CONTROL_GAIN);
        }
        double rUnwantedEmissionAbs = rItPower + rUnwantedEmissionRel + rItPowerControlGain;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Interfering Transmitter Tx Power trial = " + rItPower);
            LOG.debug("Absolute Unwanted Emission = ItPower + RelUnwanted + ItPower Gain = " + rUnwantedEmissionAbs);
        }
        if (transmitter.isUsingEmissionsFloor()) {
            rUnwantedEmissionAbs = Math.max(rUnwantedEmissionAbs, InterferenceCalculator.itUnwantedReference(iPreSim, result));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using unwanted emission floor");
                LOG.debug("Absolute Unwanted Emission = MAX(Abs Unwanted, Ref Unwanted) = " + rUnwantedEmissionAbs);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Interfering Transmitter -> Victim Receiver Effective Path Loss (with MCL)= " + rItVrEffectivePathLoss);
            LOG.debug("IT power control gain = " + rItPowerControlGain);
        }
        return rUnwantedEmissionAbs - rItVrEffectivePathLoss;
    }

    public static double blockingAttenuation(Results iPreSim, InterferenceLinkResult result) {
        double rAttenuation = 0.0;
        double rFreqIt = result.getInterferingSystemLink().getFrequency();
        double rFreqVr = result.getVictimSystemLink().getFrequency();
        Function blockingMaskIntegral = iPreSim.findFunction(Receiver.BLOCKING_MASK_INTEGRAL);
        if (blockingMaskIntegral != null) {
            if (blockingMaskIntegral.getBounds().contains(rFreqIt - rFreqVr)) {
                rAttenuation = blockingMaskIntegral.evaluate(rFreqIt - rFreqVr);
            } else {
                LOG.error("OUT OF BOUNDS");
                rAttenuation = InterferenceCalculator.vrAttenuation(result);
            }
        } else {
            rAttenuation = InterferenceCalculator.vrAttenuation(result);
        }
        return rAttenuation;
    }

    public static double blockingInterference(InterferenceLinkResult result) {
        double rItPowerControlGain = 0.0;
        if (result.getInterferenceLink().getInterferer().getSystem().getTransmitter().isUsingPowerControl()) {
            rItPowerControlGain = (Double)result.getInterferingSystemLink().getValue(SystemPlugin.TX_POWER_CONTROL_GAIN);
        }
        double rItPower = result.getInterferingSystemLink().getTxPower();
        double rItVrEffectivePathLoss = result.getEffectiveTxRxPathLoss();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Interfering Transmitter power = " + rItPower);
            LOG.debug("Interfering Transmitter -> Victim Receiver Effective Path Loss (with MCL)= " + rItVrEffectivePathLoss);
            LOG.debug("Victim Receiver Attenuation = " + result.getBlockingAttenuation());
            LOG.debug("IT power control gain = " + rItPowerControlGain);
        }
        double bandwidthCorrection = 0.0;
        if (result.getVictimSystemLink().hasValue(SystemPlugin.BANDWIDTH_CORRECTION)) {
            bandwidthCorrection = (Double)result.getVictimSystemLink().getValue(SystemPlugin.BANDWIDTH_CORRECTION);
        }
        return rItPower + rItPowerControlGain - rItVrEffectivePathLoss - result.getBlockingAttenuation() + bandwidthCorrection;
    }

    private static double vrAttenuation(InterferenceLinkResult result) {
        double rFreqIt = result.getInterferingSystemLink().getFrequency();
        double rFreqVr = result.getVictimSystemLink().getFrequency();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cached Interfering Transmitter Frequency = " + rFreqIt);
            LOG.debug("Cached Victim Receiver Frequency = " + rFreqVr);
        }
        double offset = 0.0;
        Receiver receiver = result.getInterferenceLink().getVictim().getSystem().getReceiver();
        if (result.getInterferenceLink().getVictim().getSystemPlugin() instanceof GenericSystemPlugin) {
            GenericSystemPlugin plugin = (GenericSystemPlugin)result.getInterferenceLink().getVictim().getSystemPlugin();
            if (plugin.getBlockingAttenuationMode() == GenericSystemPlugin.BlockingAttenuationMode.PROTECTION_RATIO) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attenuation Mode = Protection ratio");
                }
                offset = InterferenceCalculator.vrAttenuationProcRatio(plugin);
            } else if (plugin.getBlockingAttenuationMode() == GenericSystemPlugin.BlockingAttenuationMode.MODE_SENSITIVITY) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attenuation Mode = Sensitivity");
                }
                offset = InterferenceCalculator.vrAttenuationSens(plugin);
            }
        }
        Function blockingAttenuation = receiver.getBlockingMask().getFunction();
        Function offsetFunction = blockingAttenuation.offset(offset);
        double rResult = offsetFunction.evaluate(rFreqIt - rFreqVr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Victim Receiver Blocking Response.evaluate(FrequencyIT (" + rFreqIt + ") - Frequency VR (" + rFreqVr + ") ) = " + rResult);
        }
        return rResult;
    }

    private static double vrAttenuationProcRatio(GenericSystemPlugin plugin) {
        double rOffset = plugin.getNoiseAugmentation() + plugin.getExtendedProtectionRatio() - plugin.getInterferenceToNoiseRatio();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Victim Receiver C/(N+I) Level = " + plugin.getExtendedProtectionRatio());
            LOG.debug("Victim Receiver (N+I)/N Level = " + plugin.getNoiseAugmentation());
            LOG.debug("Victim Receiver I/N Level = " + plugin.getInterferenceToNoiseRatio());
            LOG.debug("Victim Receiver Blocking Response Offset = " + rOffset + " = (N+I)/N + C/(N+I) + I/N");
        }
        return rOffset;
    }

    private static double vrAttenuationSens(GenericSystemPlugin plugin) {
        double rOffset = plugin.getExtendedProtectionRatio() - plugin.getSensitivity() - plugin.getInterferenceToNoiseRatio();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Victim Receiver CNI Level = " + plugin.getExtendedProtectionRatio());
            LOG.debug("Victim Receiver Sensitivity = " + plugin.getSensitivity());
            LOG.debug("Victim Receiver IN level = " + plugin.getInterferenceToNoiseRatio());
            LOG.debug("Victim Receiver Blocking Response Offset = " + rOffset + " = CNI - Sensitivity - IN");
        }
        return rOffset;
    }

    private static double itUnwantedEmissions(Results iPreSim, InterferenceLinkResult result) {
        double rFreqIt = result.getInterferingSystemLink().getFrequency();
        double rFreqVr = result.getVictimSystemLink().getFrequency();
        MaskFunction unWantEmission = (MaskFunction)iPreSim.findFunction(Transmitter.NORMALIZED_EMISSION_MASK);
        double rVrBandwidth = result.getRxBandwidth();
        double rResult = unWantEmission.integrate(rFreqVr - rFreqIt, rVrBandwidth);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Interfering Transmitter Frequency = " + rFreqIt);
            LOG.debug("Victim Receiver Frequency = " + rFreqVr);
            LOG.debug("Victim Receiver Bandwith = " + rVrBandwidth);
            LOG.debug("Relative Unwanted Emission = .integrate((VrFreq - ItFreq), VrBandwith) = " + rResult + " dBc");
        }
        return rResult;
    }

    private static double itUnwantedReference(Results iPreSim, InterferenceLinkResult result) {
        double rFreqIt = result.getInterferingSystemLink().getFrequency();
        double rFreqVr = result.getVictimSystemLink().getFrequency();
        double rVrBandwidth = result.getRxBandwidth();
        MaskFunction unWantReference = (MaskFunction)iPreSim.findFunction(Transmitter.NORMALIZED_EMISSION_FLOOR);
        double rResult = unWantReference.integrate(rFreqVr - rFreqIt, rVrBandwidth);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Interfering Transmitter Frequency = " + rFreqIt);
            LOG.debug("Victim Receiver Frequency = " + rFreqVr);
            LOG.debug("Victim Receiver Bandwith = " + rVrBandwidth);
            LOG.debug("Reference Unwanted Emission = .integrate((VrFreq - ItFreq), VrBandwith) = " + rResult + " dBc");
        }
        return rResult;
    }

    public static Bounds calculateBounds(MaskFunction emissionMask, double receptionBandwidth) {
        double lower = 0.0;
        double upper = 0.0;
        double limit = emissionMask.evaluate(0.0) - 23.0;
        double start = emissionMask.getBounds().getMin();
        double step = receptionBandwidth * 1.0E-4;
        double offset = start;
        double powerStep = emissionMask.evaluate(start);
        if (powerStep >= limit) {
            lower = start;
        } else {
            while (powerStep < limit) {
                powerStep = emissionMask.evaluate(offset += step);
            }
            lower = offset;
        }
        offset = start = emissionMask.getBounds().getMax();
        powerStep = emissionMask.evaluate(start);
        if (powerStep >= limit) {
            upper = start;
        } else {
            while (powerStep < limit) {
                powerStep = emissionMask.evaluate(offset -= step);
            }
            upper = offset;
        }
        return new Bounds(lower, upper, true);
    }
}

