/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.cdma.CDMADownlinkSystem;
import org.seamcat.cdma.CdmaUserTerminal;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.Unit;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.simulation.cellular.CDMADownLinkVictim;
import org.seamcat.simulation.cellular.CellularVictimSystemSimulation;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;
import org.seamcat.simulation.result.MultiPlotDefImpl;
import org.seamcat.simulation.result.VectorDefImpl;

public class CDMADownLinkVictimSystemSimulation
extends CellularVictimSystemSimulation {
    public CDMADownLinkVictimSystemSimulation(Scenario scenario, AbstractDmaSystem dmaSystem) {
        super(scenario, dmaSystem);
    }

    @Override
    public AbstractDmaSystem getVictim() {
        AbstractDmaSystem victim = (AbstractDmaSystem)victimSystem.get();
        if (victim == null) {
            victim = new CDMADownlinkSystem(this.dmaSystem);
            victimSystem.set(victim);
        }
        return victim;
    }

    @Override
    public void simulate(VictimResultCollector collector) {
        super.simulate(collector);
        CDMADownlinkSystem system = (CDMADownlinkSystem)this.getVictim();
        collector.add(droppedBeforeInterference, (double)system.countDroppedUsers());
        this.add(collector, nonInterferedCapacity, Unit.users.name(), system.getNumberOfActiveServedMobilesInReferenceCell());
        this.add(collector, initialCapacitySystem, Unit.users.name(), system.getNumberOfActiveServedMobilesInSystem());
        collector.add(nonInterferedCapacityCombinedRefCell, (double)system.getNumberOfServedMobilesInReferenceCell());
        collector.add(nonInterferedCapacityCombinedSystem, (double)system.getNumberOfServedMobilesInSystem());
        collector.add((VectorDef)new VectorDefImpl(initialOutageSystem, "%", false), system.getSystemMeasurement());
        double initialOut = system.getReferenceCellMeasurement();
        collector.add(initialVictimOutage, initialOut);
        for (CdmaUserTerminal user : system.getActiveUsers()) {
            collector.add(new CDMADownLinkVictim(user));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initial Victim Capacity = " + system.getNumberOfActiveServedMobilesInReferenceCell() + " users in reference cell");
            LOG.debug("Initial Victim Bit rate = " + initialOut + " kbps in reference cell");
        }
    }

    @Override
    public void simulateWithInterference(EventResult eventResult, VictimResultCollector vCollector, List<InterfererResultCollector> iCollectors) {
        CDMADownlinkSystem system = (CDMADownlinkSystem)this.getVictim();
        system.balanceInterferedSystem();
        HashMap<String, Integer> dropReasons = new HashMap<String, Integer>();
        for (CdmaUserTerminal cdmaUserTerminal : system.getDroppedUsers()) {
            if (!dropReasons.containsKey(cdmaUserTerminal.getDropReason())) {
                dropReasons.put(cdmaUserTerminal.getDropReason(), 1);
                continue;
            }
            dropReasons.put(cdmaUserTerminal.getDropReason(), (Integer)dropReasons.get(cdmaUserTerminal.getDropReason()) + 1);
        }
        MultiPlotDefImpl droppedReasons = new MultiPlotDefImpl("Dropped users", "Drop reason", "Users", false);
        for (Map.Entry entry : dropReasons.entrySet()) {
            system.getCollector().add((MultiValueDef)droppedReasons, new BarChartValue((String)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        this.add(vCollector, "Interfered Outage, ref cell", "%", system.getReferenceCellMeasurement());
        double d = HybridSystemPlugin.calculateLossAvgPercentageSystemPerEvent(system.countDroppedUsers(), system.countTotalNumberOfUsers());
        vCollector.add(capacityLossDroppedSystem, d);
        double SystemCapacityLossActiveAndInactivePercentage = HybridSystemPlugin.calculateLossAvgPercentagePerEvent(vCollector.get(nonInterferedCapacityCombinedSystem), system.getNumberOfServedMobilesInSystem());
        vCollector.add(capacityLossCombinedSystem, SystemCapacityLossActiveAndInactivePercentage);
        double referenceCellCapacityLossPercentage = HybridSystemPlugin.calculateLossAvgPercentagePerEvent(vCollector.get(nonInterferedCapacityCombinedRefCell), system.getNumberOfServedMobilesInReferenceCell());
        vCollector.add(capacityLossCombinedRefCell, referenceCellCapacityLossPercentage);
        vCollector.add(interferedCapacity, (double)system.getNumberOfActiveServedMobilesInReferenceCell());
        this.add(vCollector, totalDroppedUsers, Unit.users.name(), system.countDroppedUsers());
        this.add(vCollector, simulatedUsers, Unit.users.name(), system.countTotalNumberOfUsers());
        this.add(vCollector, interferedCapacitySystem, Unit.users.name(), system.getNumberOfActiveServedMobilesInSystem());
        vCollector.add((VectorDef)new VectorDefImpl(interferedCapacityCombinedSystem, Unit.users.name(), false), (double)system.getNumberOfServedMobilesInSystem());
        vCollector.add((VectorDef)new VectorDefImpl(interferedCapacityCombinedRefCell, Unit.users.name(), false), (double)system.getNumberOfServedMobilesInReferenceCell());
        vCollector.add((VectorDef)new VectorDefImpl(interferedOutageSystemPercentage, "%", false), system.getSystemMeasurement());
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        ArrayList<Victim> relevantVictims = new ArrayList<Victim>();
        for (Victim victim : vCollector.getVictims()) {
            if (!((CDMADownLinkVictim)victim).isConnectedToReferenceCell()) continue;
            relevantVictims.add(victim);
        }
        return relevantVictims;
    }
}

