/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class CellularCalculations {
    public static List<Point2D> getWrapAroundBS(Point2D mobile, Point2D base, double D, boolean usingWrapAround, HybridSystemPlugin.SectorSetup sector) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        double a = base.getX();
        double b = base.getY();
        if (usingWrapAround) {
            if (sector == HybridSystemPlugin.SectorSetup.TriSector3GPP) {
                result.add(new Point2D(a + 3.5 * D, b + 1.5 * D * Mathematics.SQRT3));
                result.add(new Point2D(a - 0.5 * D, b + 2.5 * D * Mathematics.SQRT3));
                result.add(new Point2D(a - 4.0 * D, b + D * Mathematics.SQRT3));
                result.add(new Point2D(a - 3.5 * D, b - 1.5 * D * Mathematics.SQRT3));
                result.add(new Point2D(a + 0.5 * D, b - 2.5 * D * Mathematics.SQRT3));
                result.add(new Point2D(a + 4.0 * D, b - D * Mathematics.SQRT3));
            } else {
                result.add(new Point2D(a + 3.0 * D / Mathematics.SQRT3, b + 4.0 * D));
                result.add(new Point2D(a - 3.0 * D / Mathematics.SQRT3, b - 4.0 * D));
                result.add(new Point2D(a - 4.5 * D / Mathematics.SQRT3, b + 7.0 * D / 2.0));
                result.add(new Point2D(a + 4.5 * D / Mathematics.SQRT3, b - 7.0 * D / 2.0));
                result.add(new Point2D(a - 7.5 * D / Mathematics.SQRT3, b - D / 2.0));
                result.add(new Point2D(a + 7.5 * D / Mathematics.SQRT3, b + D / 2.0));
            }
        }
        return result;
    }

    public static Point2D findNewCoordinate(Point2D mobile, Point2D base, double D, boolean usingWrapAround, HybridSystemPlugin.SectorSetup sector) {
        Point2D[] baseStationNewCoordinate = new Point2D[]{base};
        double currentMinimum = Mathematics.distance(mobile, base);
        double a = base.getX();
        double b = base.getY();
        if (usingWrapAround) {
            if (sector == HybridSystemPlugin.SectorSetup.TriSector3GPP) {
                Point2D tempP = new Point2D(a + 3.5 * D, b + 1.5 * D * Mathematics.SQRT3);
                currentMinimum = CellularCalculations.updateMinimum(currentMinimum, mobile, tempP, baseStationNewCoordinate);
                tempP = new Point2D(a - 0.5 * D, b + 2.5 * D * Mathematics.SQRT3);
                currentMinimum = CellularCalculations.updateMinimum(currentMinimum, mobile, tempP, baseStationNewCoordinate);
                tempP = new Point2D(a - 4.0 * D, b + D * Mathematics.SQRT3);
                currentMinimum = CellularCalculations.updateMinimum(currentMinimum, mobile, tempP, baseStationNewCoordinate);
                tempP = new Point2D(a - 3.5 * D, b - 1.5 * D * Mathematics.SQRT3);
                currentMinimum = CellularCalculations.updateMinimum(currentMinimum, mobile, tempP, baseStationNewCoordinate);
                tempP = new Point2D(a + 0.5 * D, b - 2.5 * D * Mathematics.SQRT3);
                currentMinimum = CellularCalculations.updateMinimum(currentMinimum, mobile, tempP, baseStationNewCoordinate);
                tempP = new Point2D(a + 4.0 * D, b - D * Mathematics.SQRT3);
                CellularCalculations.updateMinimum(currentMinimum, mobile, tempP, baseStationNewCoordinate);
            } else {
                Point2D tempP = new Point2D(a + 3.0 * D / Mathematics.SQRT3, b + 4.0 * D);
                currentMinimum = CellularCalculations.updateMinimum(currentMinimum, mobile, tempP, baseStationNewCoordinate);
                tempP = new Point2D(a - 3.0 * D / Mathematics.SQRT3, b - 4.0 * D);
                currentMinimum = CellularCalculations.updateMinimum(currentMinimum, mobile, tempP, baseStationNewCoordinate);
                tempP = new Point2D(a - 4.5 * D / Mathematics.SQRT3, b + 7.0 * D / 2.0);
                currentMinimum = CellularCalculations.updateMinimum(currentMinimum, mobile, tempP, baseStationNewCoordinate);
                tempP = new Point2D(a + 4.5 * D / Mathematics.SQRT3, b - 7.0 * D / 2.0);
                currentMinimum = CellularCalculations.updateMinimum(currentMinimum, mobile, tempP, baseStationNewCoordinate);
                tempP = new Point2D(a - 7.5 * D / Mathematics.SQRT3, b - D / 2.0);
                currentMinimum = CellularCalculations.updateMinimum(currentMinimum, mobile, tempP, baseStationNewCoordinate);
                tempP = new Point2D(a + 7.5 * D / Mathematics.SQRT3, b + D / 2.0);
                CellularCalculations.updateMinimum(currentMinimum, mobile, tempP, baseStationNewCoordinate);
            }
        }
        return baseStationNewCoordinate[0];
    }

    private static double updateMinimum(double currentMinimum, Point2D mobile, Point2D tempP, Point2D[] baseStationNewCoordinate) {
        double distance = Mathematics.distance(mobile, tempP);
        if (Mathematics.distance(mobile, tempP) < currentMinimum) {
            baseStationNewCoordinate[0] = tempP;
            return distance;
        }
        return currentMinimum;
    }

    public static double calculateThermalNoise(double bandwidth, double receiverNoiseFigure) {
        return -173.977 + Mathematics.linear2dB(bandwidth * 1000000.0) + receiverNoiseFigure;
    }

    public static AntennaGainConfiguration[] createSectorAntennas(HybridSystemPlugin.SectorSetup setup, AntennaGainConfiguration gain) {
        AntennaGainConfiguration gain3;
        AntennaGainConfiguration gain2;
        AntennaGainConfiguration gain1;
        boolean triSectorCells = setup != HybridSystemPlugin.SectorSetup.SingleSector;
        AntennaGainConfiguration[] antennas = triSectorCells ? new AntennaGainConfiguration[]{gain1 = (AntennaGainConfiguration)Factory.antennaGainFactory().getByClass(gain.getPluginClass(), gain.getModel(), gain.peakGain(), CellularCalculations.getSectorOffset(1, setup)), gain2 = (AntennaGainConfiguration)Factory.antennaGainFactory().getByClass(gain.getPluginClass(), gain.getModel(), gain.peakGain(), CellularCalculations.getSectorOffset(2, setup)), gain3 = (AntennaGainConfiguration)Factory.antennaGainFactory().getByClass(gain.getPluginClass(), gain.getModel(), gain.peakGain(), CellularCalculations.getSectorOffset(3, setup))} : new AntennaGainConfiguration[]{gain = (AntennaGainConfiguration)Factory.antennaGainFactory().getByClass(gain.getPluginClass(), gain.getModel(), gain.peakGain(), CellularCalculations.getSectorOffset(1, setup))};
        return antennas;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double getSectorOffset(int sectorId, HybridSystemPlugin.SectorSetup setup) {
        double sectorOffset = 0.0;
        if (setup == HybridSystemPlugin.SectorSetup.TriSector3GPP) {
            if (sectorId == 1) {
                return 0.0;
            }
            if (sectorId == 2) {
                return 120.0;
            }
            if (sectorId != 3) throw new IllegalStateException("Unknown sector id");
            return 240.0;
        }
        if (setup != HybridSystemPlugin.SectorSetup.TriSector3GPP2) return 0.0;
        if (sectorId == 1) {
            return 60.0;
        }
        if (sectorId == 2) {
            return 180.0;
        }
        if (sectorId != 3) throw new IllegalStateException("Unknown sector id");
        return 300.0;
    }
}

