/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular;

import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.FunctionException;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.DefaultVictimImpl;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.ofdma.DownlinkOfdmaMobile;
import org.seamcat.ofdma.DownlinkOfdmaSystem;
import org.seamcat.simulation.cellular.ofdma.OFDMASettings;
import org.seamcat.simulation.result.LinkResultImpl;

public class OFDMADownLinkVictim
extends DefaultVictimImpl<OFDMADownLinkVictim> {
    private final int cellid;
    private DownlinkOfdmaMobile mobile;

    public OFDMADownLinkVictim(DownlinkOfdmaMobile mobile) {
        super(Factory.antennaGainFactory().getPeakGainAntenna(mobile.getAntennaGain()), mobile.getServingLink().asLinkResult());
        this.mobile = mobile;
        mobile.setVictim(this);
        this.cellid = mobile.getServingLink().getBaseStation().getCellid();
    }

    @Override
    public LinkResult getLinkResult() {
        LinkResultImpl result = (LinkResultImpl)super.getLinkResult();
        result.setFrequency(this.mobile.getFrequency());
        return result;
    }

    @Override
    public void adjustTotalInterference(double totalU, double totalB) {
        super.adjustTotalInterference(totalU, totalB);
        this.mobile.setExternalInterferenceUnwanted(totalU);
        this.mobile.setExternalInterferenceBlocking(totalB);
    }

    public boolean isConnectedToReferenceCell() {
        AbstractDmaBaseStation cell = this.mobile.getSystem().getReferenceCell();
        return this.mobile.getServingLink().getBaseStation() == cell;
    }

    @Override
    public boolean isSameTx(OFDMADownLinkVictim other) {
        return other.cellid == this.cellid;
    }

    public double calculateInterferedSINRWatt() {
        double receivePowerWatt = this.mobile.getServingLink().calculateCurrentReceivePower_Watt();
        double totalInterferenceWatt = this.mobile.getTotalInterference();
        double extIntWatt = Mathematics.fromdBm2Watt(this.getTotalInterferenceBlocking()) + Mathematics.fromdBm2Watt(this.getTotalInterferenceUnwanted());
        return receivePowerWatt / (totalInterferenceWatt + extIntWatt);
    }

    public double calculateAchievedBitrate(DownlinkOfdmaSystem system, double sinr) {
        double maxAch = this.getMaxAchievableBitRate(system, sinr);
        int requestedSubCarriers = system.getOFDMASettings().getNumberOfSubCarriersPerMobileStation();
        return (double)requestedSubCarriers * (maxAch / (double)system.getOFDMASettings().getMaxSubCarriersPerBaseStation());
    }

    protected double getMaxAchievableBitRate(DownlinkOfdmaSystem system, double sinrAchieved) {
        OFDMASettings settings = system.getOFDMASettings();
        Function function = settings.getBitrateMapping();
        double value = 0.0;
        if (sinrAchieved < function.getBounds().getMin()) {
            value = function.evaluateMin();
        } else if (sinrAchieved > function.getBounds().getMax()) {
            value = function.evaluateMax();
        } else {
            try {
                value = function.evaluate(sinrAchieved);
            }
            catch (FunctionException ex) {
                throw new RuntimeException(ex);
            }
        }
        return settings.getBandwidthOfResourceBlock() * (double)settings.getNumberOfSubCarriersPerMobileStation() * value;
    }

    @Override
    public String getRxName() {
        return "MS " + this.mobile.getUserId();
    }

    @Override
    public String getTxName() {
        return this.mobile.getServingLink().getBaseStation().getName();
    }
}

